(function ($) {
    $(document).ready(function () {
        function bulk_option_operations(action) {
            var totalCheckboxes = $("td .checkb_main [type=checkbox]").length;
            if (action == 'show') {
                if ($("#bulk_actions_dropdown").length > 0 && totalCheckboxes > 0) {
                    $("#bulk_actions_dropdown").show();
                }
            } else {
                if ($("#bulk_actions_dropdown").length > 0) {
                    $("#bulk_actions_dropdown").hide();
                }
            }
        }

        $(document).on('change', "#md_checkbox_all", function () {
            if ($(this).is(":checked")) {
                $(".checkb_main [id^=md_checkbox_]:not(#md_checkbox_all)").prop('checked', true);
                table.rows().select();
                bulk_option_operations("show");
            } else {
                $(".checkb_main [id^=md_checkbox_]:not(#md_checkbox_all)").prop('checked', false);
                table.rows().deselect();
                bulk_option_operations("hide");
            }
        });

        $(document).on('change', "[id^=md_checkbox_]:not(#md_checkbox_all)"  , function () {
            var totalCheckboxes = $("td .checkb_main [type=checkbox]").length;
            var checkedBoxes = $("td .checkb_main [type=checkbox]:checked").length;
            if (totalCheckboxes == checkedBoxes) {
                $("#md_checkbox_all").prop('checked', true);
                bulk_option_operations("show");
            } else {
                if (checkedBoxes > 0) {
                    bulk_option_operations("show");
                } else {
                    bulk_option_operations("hide");
                }
                $("#md_checkbox_all").prop('checked', false);
            }
        });

        $('.dateranges').daterangepicker({
            drops: 'down',
            ranges: {
                'Today': [moment(), moment()],
                'Yesterday': [moment().subtract(1, 'days'), moment().subtract(1, 'days')],
                'Last 7 Days': [moment().subtract(6, 'days'), moment()],
                'Last 30 Days': [moment().subtract(29, 'days'), moment()],
                'This Month': [moment().startOf('month'), moment().endOf('month')],
                'Last Month': [moment().subtract(1, 'month').startOf('month'), moment().subtract(1, 'month').endOf('month')]
            }
        });
        $('.dateranges.upcoming').daterangepicker({
            drops: 'down',
            ranges: {
                'Today': [moment(), moment()],
                'Tomorrow': [moment().add(1, 'days'), moment().add(1, 'days')],
                'Next 7 Days': [moment(), moment().add(6, 'days')],
                'Next 30 Days': [moment(), moment().add(29, 'days')],
                'This Month': [moment().startOf('month'), moment().endOf('month')],
                'Next Month': [moment().add(1, 'month').startOf('month'), moment().add(1, 'month').endOf('month')]
            }
        });
        /* if ($('.datepicker').length > 0) {
            $('.datepicker').each(function () {
                var form_id = $(this).parents('form').attr('id');
                var this_id = $(this).attr('id');
                $("#"+form_id+" #"+this_id).daterangepicker({
                    "singleDatePicker": true,
                    "showDropdowns": true,
                    "minDate": "06/05/2020",
                    "maxDate": "06/20/2020"
                });
                // $("#" + form_id + " #" + this_id).data('daterangepicker').minDate('06/05/2020');
            });
        } */
        if ($('.datepicker').length > 0) {
            $('.datepicker').daterangepicker({
                singleDatePicker: true,
                showDropdowns: true,
                // maxYear: parseInt(moment().format('YYYY'), 10)
                // parentEl: "._add_form .modal-body",
            });
            $('.datepicker.past').daterangepicker({
                singleDatePicker: true,
                showDropdowns: true,
                maxDate: moment()
                // maxYear: parseInt(moment().format('YYYY'), 10)
                // parentEl: "._add_form .modal-body",
            });
            $('.datepicker.upcoming').daterangepicker({
                singleDatePicker: true,
                showDropdowns: true,
                minDate: moment()
                // maxYear: parseInt(moment().format('YYYY'), 10)
                // parentEl: "._add_form .modal-body",
            });
        }

        if ($('.frm_filter [id^="md_checkbox_"]').length > 0) {
            $('.frm_filter [id^="md_checkbox_"]').on('change', function () {
                var filter_id = $(this).data('filter-id');
                if ($('.frm_filter #md_checkbox_' + filter_id + ':checked').val() == 'on') {
                    $('.frm_filter #' + filter_id).show();
                } else {
                    $('.frm_filter #' + filter_id).hide();
                    $('.frm_filter #' + filter_id).val('')
                }
            })
        }
    });
})(jQuery);
