<?php
// API FIELDS
define('API_FIELDS_AUTHUSER', [
    'user.user_id', 'user.signup_type', 'IFNULL(`user`.social_id,"") AS social_id', 'user.firstname', 'user.lastname', 'user.fullname', 'user.email', 'user.profilepic', 'user.is_profile_completed'
]);
define('API_FIELDS_USER', [
    'user.user_id', 'user.firstname', 'user.lastname', 'user.fullname', 'user.email', 'user.profilepic'
]);
define('API_FIELDS_PASSWORD', ['user.password']);
define('API_FIELDS_DEVICE', ['device.user_device_id', 'device.device_unique_id', 'device.wholesaler_user', 'device.is_expired_from_sdk', 'device.device_name', 'device.device_token', 'device.device_type', 'device.app_version','device.updated_at']);
define('API_FIELDS_DEVICE_PART', [
    "IFNULL(device1.user_device_id, device2.user_device_id) AS user_device_id",
    "IFNULL(device1.device_unique_id, device2.device_unique_id) AS device_unique_id",
    "IFNULL(device1.wholesaler_user, device2.wholesaler_user) AS wholesaler_user",
    "IFNULL(device1.is_expired_from_sdk, device2.is_expired_from_sdk) AS is_expired_from_sdk",
    "IFNULL(device1.device_name, device2.device_name) AS device_name",
    "IFNULL(device1.device_token, device2.device_token) AS device_token",
    "IFNULL(device1.device_type, device2.device_type) AS device_type",
    "IFNULL(device1.app_version, device2.app_version) AS app_version",
    "IFNULL(device1.updated_at, device2.updated_at) AS updated_at",
]);
define('API_FIELDS_EMAIL_VERIFICATION_STATUS', ['email_verify.email_verification_status']);
define('API_FIELDS_EMAIL_VERIFICATION', [
    'email_verify.email_verification_code', 'email_verify.email_verification_status', 'email_verify.email_verification_sent_at', 'email_verify.email_verified_at'
]);
define('API_FIELDS_FORGOT_PASSWORD', ['passtoken.password_token', 'passtoken.token_validity']);
define('API_FIELDS_USER_SUBSCRIPTION', ['usubscription.user_id']);
define('API_FIELDS_DEVICE_SUBSCRIPTION', ['usubscription.user_device_id']);
// define('API_FIELDS_SUBSCRIPTION_EXP_FLAG', '(web_subscription.expires_date_ms < (unix_timestamp() * 1000)) AS is_expired');
define('API_FIELDS_WEBHOOK_SUBSCRIPTION', ['web_subscription.webhook_subscription_id', 'web_subscription.notification_store', 'web_subscription.notification_type', 'web_subscription.environment', 'web_subscription.auto_renew_product_id', 'web_subscription.auto_renew_status', 'web_subscription.auto_renew_status_change_date_ms', 'web_subscription.password', 'web_subscription.bid', 'web_subscription.bvrs', 'web_subscription.in_app_ownership_type', 'web_subscription.purchase_date_ms', 'web_subscription.transaction_id', 'web_subscription.original_purchase_date_ms', 'web_subscription.original_transaction_id', 'web_subscription.quantity', 'web_subscription.expires_date_ms', 'web_subscription.product_id', 'web_subscription.is_trial_period', 'web_subscription.is_in_intro_offer_period', 'web_subscription.expiration_intent', 'web_subscription.cancellation_date_ms', 'web_subscription.price', 'web_subscription.is_expired', 'web_subscription.created_at']);
define('API_FIELDS_WEBHOOK_SUBSCRIPTION_TRAN', ['web_subscription_tran.webhook_subscription_id', 'web_subscription_tran.notification_store', 'web_subscription_tran.notification_type', 'web_subscription_tran.environment', 'web_subscription_tran.auto_renew_product_id', 'web_subscription_tran.auto_renew_status', 'web_subscription_tran.auto_renew_status_change_date_ms', 'web_subscription_tran.password', 'web_subscription_tran.bid', 'web_subscription_tran.bvrs', 'web_subscription_tran.in_app_ownership_type', 'web_subscription_tran.purchase_date_ms', 'web_subscription_tran.transaction_id', 'web_subscription_tran.original_purchase_date_ms', 'web_subscription_tran.original_transaction_id', 'web_subscription_tran.quantity', 'web_subscription_tran.expires_date_ms', 'web_subscription_tran.product_id', 'web_subscription_tran.is_trial_period', 'web_subscription_tran.is_in_intro_offer_period', 'web_subscription_tran.expiration_intent', 'web_subscription_tran.cancellation_date_ms', 'web_subscription_tran.price', 'web_subscription_tran.created_at']);
define('API_FIELDS_SUBSCRIPTION_ANALYTICS', ['subscription_analytic.month', 'subscription_analytic.year', 'subscription_analytic.users', 'subscription_analytic.new_users', 'subscription_analytic.guest_users', 'subscription_analytic.new_guest_users', 'subscription_analytic.active_guests', 'subscription_analytic.active_users', 'subscription_analytic.expired_guests', 'subscription_analytic.expired_users', 'subscription_analytic.active_trial_users', 'subscription_analytic.active_trial_guests']);
define('API_FIELD_OPEN_GATE_SERVER_FIELD', [
    'open_get_server.id', 'open_get_server.country', 'open_get_server.country_code', 'open_get_server.ip_address', 'open_get_server.state',
    'open_get_server.premium', 'open_get_server.recommend', 'open_get_server.is_active', 'open_get_server.created_at', 'open_get_server.updated_at', 'open_get_server.ovpn'
]);
define('API_FIELD_COUNTRY_FIELD', [
    'countries.country_id', 'countries.country', 'countries.country_code', 'countries.premium',
    'countries.recommend', 'countries.is_active', 'countries.created_at', 'countries.updated_at', 'countries.flag', '"[]" as servers'
]);
define('API_VPN_SERVER_FIELD', [
    'vpn_servers.server_id', 'vpn_servers.country_id as parent_country_id', 'vpn_servers.recommend', 'vpn_servers.is_active ',
    'vpn_servers.ovpn', 'vpn_servers.created_at', 'vpn_servers.updated_at', 'vpn_servers.ip_address',
]);
define('API_FIELD_OPTIMAL_SERVER_FIELD', [
    'country.country_id', 'country.country', 'country.country_code', 'country.premium', 'country.is_active', 'country.flag', 'vpn_server.server_id', 'vpn_server.country_id as parent_country_id', 'vpn_server.ovpn','vpn_server.ip_address','vpn_server.is_active AS is_active_vpn_server','vpn_server.updated_at AS updated_at_vpn_server'
]);
define('API_SUBSCRIPTION_STAT_FIELD',[
    'subscription_stats.stat_id','subscription_stats.store','subscription_stats.stat_date', 'subscription_stats.paid_subscribers', 'subscription_stats.trial_subscribers','subscription_stats.expired_subscribers','subscription_stats.created_date'
]);

define('API_SUBSCRIPTION_STAT_FIELDS',[
    'paid_subscribers', 'trial_subscribers','expired_subscribers'
]);

define('API_SUBSCRIPTION_STAT_TOTAL',[
    'SUM(paid_subscribers) AS total_paid,SUM(trial_subscribers) AS total_trial,SUM(expired_subscribers) AS total_exp'
]);
