<?php
defined('BASEPATH') or exit('No direct script access allowed');
class Front_ajax extends CI_Controller
{
    public function __construct(){
        parent::__construct();
        $this->load->model('api_model');
        $this->data = [];
    }

    public function reset_password(){
        $rules = [
            'token' => [
                'field' => 'token', 'label' => 'Password Token', 'rules' => 'required|exact_length[15]',
            ],
            'new_password' => [
                'field' => 'new_password', 'label' => 'New Password', 'rules' => 'required|min_length[6]',
            ],
            'confirm_password' => [
                'field' => 'confirm_password', 'label' => 'Email', 'rules' => 'required|min_length[6]|matches[new_password]',
            ],
        ];
        checkIfValidated($rules);
        $postdata = $this->input->post();
        $row = $this->api_model->getPasswordTokenDetails($postdata['token']);
        if(!$row):
            $msg = 'Token expired or invalid';
            $this->session->set_flashdata('error', $msg);
            sendResponse(false, $msg);
        endif;
        if (password_verify($postdata['new_password'], $row['password'])):
            $msg = 'Old & new password cannot be same';
            $this->session->set_flashdata('error', $msg);
            sendResponse(false, $msg);
        else:
            $flag = $this->api_model->updateUserDetails($row['user_id'], ['password' => $postdata['new_password']]);
            if($flag === FALSE):
                sendResponse(false, SYSTEM_ERROR);
            endif;
            $this->api_model->verifyPasswordResetToken($row['user_id']);
            $msg = 'Password reset successfully';
            $this->session->set_flashdata('success', $msg);
            sendResponse(true, $msg);
        endif;
    }

    public function reset_my_password(){
        $rules = [
            'token' => [
                'field' => 'token', 'label' => 'Password Token', 'rules' => 'required|exact_length[15]',
            ],
            'new_password' => [
                'field' => 'new_password', 'label' => 'New Password', 'rules' => 'required|min_length[6]',
            ],
            'confirm_password' => [
                'field' => 'confirm_password', 'label' => 'Email', 'rules' => 'required|min_length[6]|matches[new_password]',
            ],
        ];
        checkIfValidated($rules);
        $postdata = $this->input->post();
        $staging = $this->load->database('staging', true);

        $row =  $this->api_model->getPasswordTokenDetails($postdata['token']);
        $row = $staging->query($this->db->last_query())->row_array();
        if(!$row):
            $msg = 'Token expired or invalid';
            $this->session->set_flashdata('error', $msg);
            sendResponse(false, $msg);
        endif;
        $postdata['email'] = $row['email'];
        $response = $this->curl->call(['method' => 'POST', 'url' => STAG_API_URL . 'reset-password-with-token', 'payload' => $postdata]);

        if (!$response['success']):
            $msg = $response['message'];
            $this->session->set_flashdata('error', $msg);
            sendResponse(false, $msg);
        else:
            $msg = $response['message'];
            $this->session->set_flashdata('success', $msg);
            sendResponse(true, $msg);
        endif;
    }
}