<?php
defined('BASEPATH') or exit('No direct script access allowed');
class Web_reset_password extends CI_Controller
{
    public function __construct(){
        parent::__construct();
        $this->load->model('api_model');
        $this->data = [];
    }

    public function recover($token = ''){
        if(empty($token)){
            $this->data['page_title'] = 'Invalid/Broken Link';
            show_custom_404();
        }else{
            $tokenData =  $this->api_model->getPasswordTokenDetails($token);
            if(!$tokenData){
                $this->data['page_title'] = 'Invalid/Broken Link';
                show_custom_404();
            }else{
                $this->data['page_title'] = 'Reset Password';
                $this->data['forms'] = [
                    'frm_reset_password' => ['id' => 'frm_reset_password', 'method' => 'POST'],
                ];
                $this->data['form_rules'] = [
                    'frm_reset_password' => [
                        'new_password' => ['required' => true, 'minlength' => 6],
                        'confirm_password' => ['required' => true, 'minlength' => 6, 'equalTo' => '#new_password'],
                    ],
                ];
                $this->data['form_ajax'] = [
                    'frm_reset_password' => [
                        'ajax_url' => FRONT_AJAX_URL.'reset-password',
                        'redirect_url' => SITE_URL.'reset-password/success',
                    ],
                ];
                $this->load->web_guest_template('reset-password',$this->data);
            }
        }
    }

    public function generate($token = ''){
        if(empty($token)){
            $this->data['page_title'] = 'Invalid/Broken Link';
            show_custom_404();
        }else{
            $staging = $this->load->database('staging', true);
            $tokenData = $this->api_model->getPasswordTokenDetails($token);
            $tokenData = $staging->query($this->db->last_query())->row_array();
            if(!$tokenData){
                $this->data['page_title'] = 'Invalid/Broken Link';
                show_custom_404();
            }else{
                $this->data['page_title'] = 'Reset Password';
                $this->data['forms'] = [
                    'frm_reset_password' => ['id' => 'frm_reset_password', 'method' => 'POST'],
                ];
                $this->data['form_rules'] = [
                    'frm_reset_password' => [
                        'new_password' => ['required' => true, 'minlength' => 6],
                        'confirm_password' => ['required' => true, 'minlength' => 6, 'equalTo' => '#new_password'],
                    ],
                ];
                $this->data['form_ajax'] = [
                    'frm_reset_password' => [
                        'ajax_url' => FRONT_AJAX_URL.'reset-my-password',
                        'redirect_url' => WEB_URL.'reset-password/success',
                    ],
                ];
                $this->load->web_guest_template('reset-password',$this->data);
            }
        }
    }

    public function success(){
        $this->data['page_title'] = 'Reset Password Success';
        $this->data['email_verified'] = TRUE;
        $this->load->web_guest_template('reset-password-success',$this->data);
    }

}