<?php
defined('BASEPATH') or exit('No direct script access allowed');
class Profile extends Administrator
{
    public function __construct(){
        parent::__construct();
    }

    public function index(){
        $module = $this->data['module'];
        $this->data['page_title'] = $this->data['singular_title'];
        $this->data['breadcrumb'] = [
            ['title' => 'Home', 'url' => ADMIN_URL],
            ['title' => $this->data['singular_title'], 'url' => ''],
        ];
        $this->data['forms'] = [
            'frm_profile' => ['id' => 'frm_profile', 'method' => 'POST'],
            'frm_cpassword' => ['id' => 'frm_cpassword', 'method' => 'POST'],
        ];
        $this->data['form_rules'] = [
            'frm_profile' => [
                'admin_fullname' => ['required' => true, 'minlength' => 2, 'maxlength' => 255],
                'admin_email' => ['required' => true, 'email' => true,'minlength' => 2, 'maxlength' => 255],
            ],
            'frm_cpassword' => [
                'old_password' => ['required' => true, 'minlength' => 6],
                'new_password' => ['required' => true, 'minlength' => 6 ],
                'confirm_password' => ['required' => true, 'minlength' => 6, 'equalTo' => '#new_password'],
            ],
        ];
        $this->data['form_ajax'] = [
            'frm_profile' => [
                'ajax_url' => ADMIN_AJAX_URL . 'update-'.$module,
                'redirect_url' => ADMIN_URL . $module,
            ],
            'frm_cpassword' => [
                'ajax_url' => ADMIN_AJAX_URL . 'change-password',
                'redirect_url' => ADMIN_URL . $module,
            ],
        ];
        $this->load->admin_auth_template($module.'/index', $this->data);
    }
}