<?php
defined('BASEPATH') or exit('No direct script access allowed');
class Role extends Administrator
{
    public function __construct(){
        parent::__construct();
    }

    public function index(){
        $module = $this->data['module'];
        $this->data['page_title'] = $this->data['module_title'];
        $this->data['breadcrumb'] = [
            ['title'=>'Home','url'=>ADMIN_URL],
            ['title'=>$this->data['module_title'],'url'=>ADMIN_URL . $module],
            ['title'=>'List','url'=>''],
        ];
        $this->data['datatable_url'] = ADMIN_AJAX_URL . 'get-'.$module.'-list';
        $this->data['columns'] = [
            ['type' => 'checkbox'],
            ['type' => 'counter'],
            ['type' => 'input', 'has_filter' => TRUE, 'id' => 'role_title', 'label' => 'Role Title', 'list_params' => ['width' => '15%']],
            ['type' => 'select', 'has_filter' => TRUE, 'id' => 'is_active', 'label' => 'Status', 'options' => ACTIVE_INACTIVE_OPTIONS, 'list_params' => ['width' => '8%']],
            ['type' => 'daterange', 'has_filter' => TRUE, 'id' => 'created_at', 'label' => 'Created at', 'list_params' => ['width' => '8%']],
            ['type' => 'actions', 'has_filter' => FALSE, 'label' => 'Action', 'list_params' => ['width' => '5%', 'class' => 'action-column', 'data-orderable' => 'false', 'data-searchable' => 'false']],
        ];
        $this->data['forms'] = [
            'frm_add' => ['id' => 'frm_add', 'method' => 'POST'],
            'frm_edit' => ['id' => 'frm_edit', 'method' => 'POST'],
            'frm_permission' => ['id' => 'frm_permission', 'method' => 'POST'],
        ];
        $this->data['form_rules'] = [
            'frm_add' => [
                'role_title' => ['required' => true, 'minlength' => 2, 'maxlength' => 255],
                'is_active' => ['required' => true],
            ],
            'frm_edit' => [
                'role_title' => ['required' => true, 'minlength' => 2, 'maxlength' => 255],
                'is_active' => ['required' => true],
            ],
            'frm_permission' => [
                'role_id' => ['required' => true],
            ],
        ];
        $this->data['form_ajax'] = [
            'frm_add' => [
                'ajax_url' => ADMIN_AJAX_URL . 'add-'.$module,
                'redirect_url' => ADMIN_URL . $module,
            ],
            'frm_edit' => [
                'ajax_url' => ADMIN_AJAX_URL . 'update-'.$module,
                'redirect_url' => ADMIN_URL . $module,
            ],
            'frm_permission' => [
                'ajax_url' => ADMIN_AJAX_URL . 'update-'.$module.'-permission',
                'redirect_url' => ADMIN_URL . $module,
            ],
        ];
        $this->data['form_filter'] = [
            'id' => 'frm_filter',
            'class' => 'frm_filter',
            'fields' => [
                'role_title' => [
                    'class' => 'form-control',
                    'type' => 'text', 'name' => 'role_title', 'id' => 'role_title', 'placeholder' => 'Enter text here',
                    'style' => 'display: none',
                ],
                'is_active' => [
                    'class' => 'form-control',
                    'name' => 'is_active', 'id' => 'is_active',
                    'style' => 'display: none',
                ],
                'created_at' => [
                    'class' => 'form-control dateranges',
                    'type' => 'text', 'name' => 'created_at', 'id' => 'created_at', 'placeholder' => 'Select datetime range',
                    'style' => 'display: none',
                ],
            ],
        ];
        $modules = $this->module_model->getRecords();
        if(!empty($modules) && count($modules) > 0){
            $modules = array_map(function($module){
                $module['methods'] = $this->module_model->getModuleMethodsInfo($module['module_id']);
                return $module;
            }, $modules);
        }
        $this->data['modules'] = $modules;
        $this->load->admin_auth_template($module.'/list', $this->data);
    }

    /* public function edit($id){
        $row = $this->role_model->getRow($id);
        if(!$row){
            show_404();
        }
        $module = $this->data['module'];
        $this->data['page_title'] = 'Update '.$this->data['singular_title'];
        $this->data['breadcrumb'] = [
            ['title'=>'Home','url'=>ADMIN_URL],
            ['title'=>$this->data['module_title'],'url'=>ADMIN_URL . $module],
            ['title'=>'Update','url'=>''],
        ];
        $this->data['forms'] = [
            'frm_edit' => ['id' => 'frm_edit', 'method' => 'POST'],
        ];
        $this->data['form_rules'] = [
            'frm_edit' => [
                'role_title' => ['required' => true, 'minlength' => 2, 'maxlength' => 255],
                'is_active' => ['required' => true],
            ],
        ];
        $this->data['form_ajax'] = [
            'frm_edit' => [
                'ajax_url' => ADMIN_AJAX_URL . 'update-'.$module,
                'redirect_url' => ADMIN_URL . $module,
            ],
        ];
        $this->data['row'] = $row;
        $this->load->admin_auth_template($module.'/edit', $this->data);
    } */

    public function permission($id){
        $row = $this->role_model->getRow($id);
        if(!$row){
            show_404();
        }
        $module = $this->data['module'];
        $this->data['page_title'] = 'Update '.$this->data['singular_title'].' Permissions';
        $this->data['breadcrumb'] = [
            ['title'=>'Home','url'=>ADMIN_URL],
            ['title'=>$this->data['module_title'],'url'=>ADMIN_URL . $module],
            ['title'=>'Update','url'=>''],
        ];
        $this->data['forms'] = [
            'frm_edit' => ['id' => 'frm_edit', 'method' => 'POST'],
        ];
        $this->data['form_rules'] = [
            'frm_edit' => [
                'role_title' => ['required' => true, 'minlength' => 2, 'maxlength' => 255],
                'is_active' => ['required' => true],
            ],
        ];
        $this->data['form_ajax'] = [
            'frm_edit' => [
                'ajax_url' => ADMIN_AJAX_URL . 'update-'.$module.'-permission',
                'redirect_url' => ADMIN_URL . $module,
            ],
        ];
        $modules = $this->module_model->getRecords();
        if(!empty($modules) && count($modules) > 0){
            $modules = array_map(function($module){
                $module['methods'] = $this->module_model->getModuleMethodsInfo($module['module_id']);
                return $module;
            }, $modules);
        }
        $this->data['modules'] = $modules;
        $this->data['row'] = $row;
        $selected_permissions = $this->role_model->getModulePermissions($row['role_id']);
        $this->data['row']['selected_permissions'] = array_map(function ($module_method) {
            return $module_method['module_method_id'];
        }, $selected_permissions);
        $this->load->admin_auth_template($module.'/permission', $this->data);
    }
}