<?php
class Authlib
{
    public function __construct()
    {
        $this->ci = &get_instance();
    }

    public function isAuthorized($permissions)
    {
        $controller = $this->ci->router->fetch_class();
        $method = $this->ci->router->fetch_method();
        $keys = $this->isHaveAccess($permissions, $controller, $method);
        if (empty($keys)) {
            show_404();
        }
    }

    public function isAuthorizedLink($permissions, $controller, $method = 'index')
    {
        $keys = $this->isHaveAccess($permissions, $controller, $method);
        return (empty($keys)) ? FALSE : TRUE;
    }

    public function isHaveAccess($permissions, $controller, $method = 'index')
    {
        if ($controller == 'ajax') {
            if (fnmatch('get_*_list', $method)) {
                $controller = str_replace(['get_', '_list'], ['', ''], $method);
                $method = 'index';
            } elseif (fnmatch('get_*_details', $method)) {
                $controller = str_replace(['get_', '_details'], ['', ''], $method);
                $method = 'edit';
            } elseif (fnmatch('get_*_permissions', $method)) {
                $controller = str_replace(['get_', '_permissions'], ['', ''], $method);
                $method = 'permission';
            } elseif (fnmatch('add_*', $method)) {
                $controller = str_replace(['add_'], [''], $method);
                $method = 'add';
            } elseif (in_array($method, ['update_status', 'update_status_bulk'])) {
                $controller = $_POST['module'];
                $method = 'update_status';
            } elseif ($method == 'update_role_permission') {
                $controller = 'role';
                $method = 'permission';
            } elseif (fnmatch('update_*', $method) && !in_array($method, ['update_status', 'update_status_bulk'])) {
                $controller = str_replace(['update_'], [''], $method);
                $method = 'edit';
            } elseif (fnmatch('import_*', $method)) {
                $controller = str_replace(['import_'], [''], $method);
                $method = 'import';
            } elseif ($method == 'delete_record') {
                $controller = $_POST['module'];
                $method = 'delete';
            } elseif ($method == 'change_password') {
                $controller = 'profile';
                $method = 'change-password';
            } elseif ($method == 'reset_password') {
                $controller = 'profile';
                $method = 'reset-password';
            } elseif (fnmatch('dashboard_*', $method)) {
                $controller = 'dashboard';
                $method = str_replace(['dashboard_'], [''], $method);
            }
        }
        if ($method == 'latest') {
            $method = 'index-latest';
        }
        // echo $controller.'--'.$method;die;
        $controller_method = $method;
        /* switch ($method) {
            case 'index':$controller_method = 'list';
                break;
        } */
        $search = [
            'module_slug' => str_replace('_', '-', $controller),
            'method_identifier' => str_replace('_', '-', $controller_method),
        ];
        // echo '<pre>';print_r($permissions);die;

        if (in_array($controller, DEFAULT_CONTROLLERS)) {
            return [1];
        }
        $keys = array_keys(
            array_filter(
                $permissions,
                function ($permission) use ($search) {
                    return $permission['module_slug'] == $search['module_slug'] &&
                        $permission['method_identifier'] == $search['method_identifier'];
                }
            )
        );
        return $keys;
    }
}
