<?php
require APPPATH . 'third_party/vendor/autoload.php';
use \Firebase\JWT\JWT;

class Loginlib
{
    public function __construct()
    {
        $this->ci = &get_instance();
        $this->ci->load->library('session');
    }

    public function set_session($admin, $timezone='UTC', $timezone_offset = 0)
    {
        $this->ci->session->set_userdata('admin_email', $admin['admin_email']);
        $this->ci->session->set_userdata('admin_id', $admin['admin_id']);
        $this->ci->session->set_userdata('timezone', $timezone);
        $this->ci->session->set_userdata('timezone_offset', $timezone_offset);
    }

    public function unset_session(){
        $this->ci->session->unset_userdata('admin_email');
        $this->ci->session->unset_userdata('admin_id');
        $this->ci->session->unset_userdata('timezone');
        $this->ci->session->unset_userdata('timezone_offset');
    }

    public function getLoggedInData(){
        $admin_id = $this->ci->session->userdata('admin_id');
        $adminRow = $this->ci->login_model->getLoggedInAdminData(['admin_id' => $admin_id]);
        // $adminRow['reset_offset'] = reset_timezone_offset($this->ci->session->userdata('timezone'));
        $adminRow['reset_offset'] = $this->ci->session->userdata('timezone_offset');
        $adminRow['set_offset'] = $adminRow['reset_offset'] * -1;
        return $adminRow;
    }
}
