<?php 
if (!defined('BASEPATH')) exit('No direct script access allowed');

class Vpn{
 
    function __construct(){
        $this->api_key = VPN_WHOLESALER_API_KEY;
        $this->api_url_prefix = VPN_WHOLESALER_API_URL_PREFIX;
    }
    
    function cancel_renewals($email){
        $email = $email ?? "";
        if(empty($email)){
            return FALSE;
        }
        $api = 'Cancel Renewals';
        mylog($api);
        $password = explode('@',$email)[0];
        $params = [
            'apikey' => $this->api_key,
            'email' => $email,
            'password' => $password,
            'type' => 'immediate',
            'reason' => 'expired'
        ];
        $response = $this->send($this->api_url_prefix.'amapi/CancelRenew', $params);
        if($response['status'] == "success"){
            mylog($api.' Response (Success): '.$response['result']);
            return TRUE;
        }else{
            if($response['message'] == 'No active product found'){
                mylog($api.' Response (Success): '.$response['message']);
                return TRUE;
            }
            if($response['message'] == "Wrong email/password combination or client doesn't exists"){
                mylog($api.' Response (Success): '.$response['message']);
                return TRUE;
            }
            mylog($api.' Response (Failed): '.$response['message']);
            return FALSE;
        }
    }

    function renew($email, $plan_type){
        $email = $email ?? "";
        if(empty($email)){
            return FALSE;
        }
        $api = 'Renew - New Product';
        mylog($api);
        $password = explode('@',$email)[0];
        $params = [
            'apikey' => $this->api_key,
            'email' => $email,
            'password' => $password,
            'type' => $plan_type,
        ];
        $response = $this->send($this->api_url_prefix.'amapi/NewProduct', $params);
        if($response['status'] == "success"){
            mylog($api.' Response (Success): '.$response['result']);
            return TRUE;
        }else{
            if($response['message'] == "Wrong email/password combination or client doesn't exists"){
                mylog($api.' Response (Failed): '.$response['message']);
                $CI = &get_instance();
                $url = "https://ipinfo.io/";
                $url .= $CI->input->ip_address()."/";
                $url .= "json";
                $response = $CI->curl->call(['url' => $url]);
                mylog("IP Response: ".$response);

                $flag = $this->add_account($email, $plan_type, $response['country']);
                if($flag){
                    return TRUE;
                }else{
                    return FALSE;
                }
            }else{
                mylog($api.' Response (Failed): '.$response['message']);
                return FALSE;
            }
       }
    }

    function login($email){
        $api = 'Login / My Packages';
        mylog($api);
        $password = explode('@',$email)[0];
        $params = [
            'apikey' => $this->api_key,
            'email' => $email,
            'password' => $password,
        ];
        $response = $this->send($this->api_url_prefix.'public/packages', $params);
        return $response;
        /* if($response['status'] == "success"){
            // Array ( [status] => success [result] => success [client_id] => 1201078 [email] => 0C2F5882-1B40-4F6A-88A3-C54E239C12CE@vpw.vpnproxymaster.app [first_name] => [last_name] => [company_name] => [active] => 1 [uniqueid] => upsq_GYZje9uAF7pKEB15AbMmUPz6UwVTLZtpT [last_product_change_ts] => 1671606942 [short_token] => 0x16adb18d66cbdf5b517c57b64da1c4b7b [short_token_expire] => 2022-12-21 19:15:42 [short_token_expire_ts] => 1671650142 [long_token] => 0x2d0fc5c3adc7ca46dd6829489895aa34a [long_token_expire] => 2023-12-21 00:00:00 [long_token_expire_ts] => 1703116800 [products] => Array ( [product] => Array ( [0] => Array ( [id] => 2212598 [clientid] => 1201078 [regdate] => 2022-12-21 [name] => 12 Months [product_type] => 1 [billingcycle] => Annually [nextduedate] => 2023-12-21 [status] => Active [username] => upsq_fvhrmlbxs [password] => HL7oQvgWt [expired_dt] => 2023-12-21 23:00 [expired_ts] => 1703199600 ) ) ) )
            mylog($api.' Response (Success): '.$response['result']);
            return TRUE;
        }else{
            // Array ( [status] => error [result] => error [code] => 404 [message] => Wrong email/password combination or client doesn't exists )
            mylog($api.' Response (Failed): '.$response['message']);
            return FALSE;
        } */
    }

    function add_account($email, $plan_type, $country){
        $email = $email ?? "";
        if(empty($email)){
            return FALSE;
        }
        $api = 'Add Account';
        mylog($api);
        $password = explode('@',$email)[0];

        $params = [
            'apikey' => $this->api_key,
            'email' => $email,
            'password' => $password,
            'type' => $plan_type,
            'country' => $country
        ];
        $response = $this->send($this->api_url_prefix.'amapi/AddClient', $params);
        if($response['status'] == "success"){
            mylog($api.' Response (Success): '.$response['result']);
            return TRUE;
        }else{
            mylog($api.' Response (Failed): '.$response['message']);
            return FALSE;
        }
    }

    function close_account($email){
        $email = $email ?? "";
        if(empty($email)){
            return FALSE;
        }
        $api = 'Close Account';
        mylog($api);
        $password = explode('@',$email)[0];

        $params = [
            'apikey' => $this->api_key,
            'email' => $email,
            'password' => $password
        ];
        $response = $this->send($this->api_url_prefix.'amapi/CloseClient', $params);
        if($response['status'] == "success"){
            mylog($api.' Response (Success): '.$response['result']);
            return TRUE;
        }else{
            mylog($api.' Response (Failed): '.$response['message']);
            return FALSE;
        }
    }

    function send($url, $params){
        mylog($params);
        $post_params = http_build_query($params);
        $curl = curl_init();
        curl_setopt_array($curl, array(
            CURLOPT_URL => $url,
            CURLOPT_RETURNTRANSFER => true,
            CURLOPT_ENCODING => '',
            CURLOPT_MAXREDIRS => 10,
            CURLOPT_TIMEOUT => 0,
            CURLOPT_FOLLOWLOCATION => true,
            CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
            CURLOPT_CUSTOMREQUEST => 'POST',
            CURLOPT_POSTFIELDS => $post_params,
        ));
        $response = curl_exec($curl);
        curl_close($curl);
        $response = json_decode($response, true); //{"status":"success","result":"success"}
        return $response;
    }
}
