<?php
defined('BASEPATH') or exit('No direct script access allowed');

class Login_model extends My_Model {

    public function __construct()
    {
        parent::__construct();
    }

    public function checkIfAdminDetailExist($email)
    {
        $this->db->from($this->admin_table);
        $this->db->where('admin_email',$email);
        $query = $this->db->get();
        return $query->row_array();
    }

    public function getLoggedInAdminData($where=[]){
        $this->db->select('admin.*,role.role_title,role.role_slug');
        $this->db->where($where);
        $this->db->from($this->admin_table.' AS admin');
        $this->db->join($this->role_table.' AS role','role.role_id = admin.role_id');
        $query = $this->db->get();
        return $query->row_array();
    }

    private function checkForExistingToken($id){
        $where = ['admin.admin_id' => $id];
        return $this->getPasswordTokenDetails($where);
    }

    public function generatePasswordToken($id){
        $existing = $this->checkForExistingToken($id);
        if($existing){
            $password_token = get_unique_id(15);
            $token = [
                'password_token' => $password_token,
                'token_validity' => (time() + (2 * CALC_DAYS)),
                'created_at' => time(),
            ];
            $this->db->where('admin_id',$id);
            $flag = $this->db->update($this->admin_password_token_table,$token);
            if(!$flag){
                return FALSE;
            }
            return $this->getPasswordTokenDetails(['password_token'=>$password_token]);
        }
        $row = [
            'admin_id' => $id,
            'password_token' => get_unique_id(15),
            'token_validity' => time() + (2 * CALC_DAYS),
            'created_at' => time(),
        ];
        $flag = $this->db->insert($this->admin_password_token_table,$row);
        if(!$flag){
            return FALSE;
        }
        return $this->getPasswordTokenDetails(['password_token_id'=>$this->db->insert_id()]);
    }

    public function getPasswordTokenDetails($where=[]){
        $this->db->select('admin.*,passtoken.password_token,passtoken.token_validity');
        $this->db->where($where);
        $this->db->from($this->admin_password_token_table.' AS passtoken');
        $this->db->join($this->admin_table.' AS admin','passtoken.admin_id = admin.admin_id');
        $query = $this->db->get();
        return $query->row_array();
    }
}