<?php
defined('BASEPATH') or exit('No direct script access allowed');

class Open_gate_server_model extends My_Model
{

    public function __construct()
    {
        parent::__construct();
    }

    public function getOpenGateServerList($where = [])
    {
        $this->db->select(API_FIELD_OPEN_GATE_SERVER_FIELD);
        $this->db->from($this->open_get_server_table . ' as open_get_server');
        $this->db->where($where);
        $query = $this->db->get();
        return $query->result_array();
    }

    public function getRecords($params = [])
    {
        $params = init_model_params($params);
        // $fields = array_merge(API_FIELDS_DEVICE, ['open_get_server.created_at']);
        $this->db->select(API_FIELD_OPEN_GATE_SERVER_FIELD);
        get_where($params['where']);
        $this->db->from($this->open_get_server_table . ' AS open_get_server');
        if ($params['action'] != 'count') get_order($params['order']);
        get_limit($params['limit'], $params['offset']);
        $query = $this->db->get();
        return get_data($params, $query);
    }

    public function getDatatableList($params = [])
    {
        $params = init_model_params($params);
        $this->db->select(API_FIELD_OPEN_GATE_SERVER_FIELD);
        get_where($params['where']);
        get_filter_where(OPEN_GATE_SERVER_SEARCHABLE_FIELD);
        if ($params['action'] != 'count') {
            get_filter_order($_REQUEST, $params['order'], OPEN_GATE_SERVER_ORDERABLE_FIELD);
            get_limit($params['limit'], $params['offset']);
        }
        $this->db->from($this->open_get_server_table . ' AS open_get_server');
        $query = $this->db->get();
        return get_data($params, $query);
    }

    public function insertVPNServer($postData)
    {
        $postData['created_at'] = time();
        $postData['updated_at'] = time();
        unset($postData['admin_id']);
        $this->db->insert($this->open_get_server_table, $postData);
    }

    public function updateExisting($postdata, $id)
    {
        $postdata['updated_at'] = time();
        unset($postdata['id']);
        $this->db->where('id', $id);
        $flag = $this->db->update($this->open_get_server_table, $postdata);
        if (!$flag) {
            return FALSE;
        }
        return $this->db->affected_rows();
    }

    public function getRow($id)
    {
        return $this->getRecords(['where' => ['open_get_server.id' => $id], 'action' => 'row']);
    }

    public function checkIfExist($country_name, $id = NULL)
    {
        $where = ['open_get_server.country' => $country_name];
        if ($id) {
            $where['id != '] = $id;
        }
        return $this->getRecords(['where' => $where, 'action' => 'row']);
    }
}
