<?php
defined('BASEPATH') or exit('No direct script access allowed');

class Question_model extends My_Model {

    public function __construct()
    {
        parent::__construct();
    }

    public function getRow($id)
    {
        return $this->getRecords(['where'=>['question_id'=>$id],'action'=>'row']);
    }

    public function checkIfExist($question, $id = NULL)
    {
        $where = ['question' => $question];
        if($id){ $where['question_id != '] = $id; }
        return $this->getRecords(['where' => $where, 'action' => 'row']);
    }

    public function getRecords($params = [])
    {
        $params = init_model_params($params);
        $this->db->select('que.*,cat.category_label,cat.category_slug');
        get_where($params['where']);
        $this->db->from($this->question_table.' AS que');
        $this->db->join($this->category_table.' AS cat','cat.category_id = que.question_category_id');
        if($params['action'] != 'count') get_order($params['order']);
        get_limit($params['limit'],$params['offset']);
        $query = $this->db->get();
        return get_data($params, $query);
    }

    public function getDatatableList($params)
    {
        $params = init_model_params($params);
        $this->db->select('que.*,cat.category_label');
        get_where($params['where']);
        get_filter_where(QUESTIONS_SEARCHABLE_FIELDS);
        if($params['action'] != 'count'){
            get_filter_order($_REQUEST, $params['order'], QUESTIONS_ORDERABLE_FIELDS);
            get_limit($params['limit'], $params['offset']);
        }
        $this->db->from($this->question_table . ' AS que');
        $this->db->join($this->category_table . ' AS cat', 'cat.category_id = que.question_category_id');
        $query = $this->db->get();
        return get_data($params, $query);
    }

    public function addNew($postdata)
    {
        $row = [
            'question_category_id' => $postdata['question_category_id'],
            'question' => $postdata['question'],
            'question_type' => $postdata['question_type'],
            'is_active' => $postdata['is_active'],
            'created_at' => time(),
            'updated_at' => time(),
        ];
        $flag = $this->db->insert($this->question_table,$row);
        if(!$flag){
            return FALSE;
        }
        return $this->db->insert_id();
    }

    public function updateExisting($postdata, $id)
    {
        $row = [
            'question_category_id' => $postdata['question_category_id'],
            'question' => $postdata['question'],
            'question_type' => $postdata['question_type'],
            'is_active' => $postdata['is_active'],
            'updated_at' => time(),
        ];
        $this->db->where('question_id',$id);
        $flag = $this->db->update($this->question_table,$row);
        if(!$flag){
            return FALSE;
        }
        return $this->db->affected_rows();
    }
}