<?php
defined('BASEPATH') or exit('No direct script access allowed');

class Subscription_stat_model extends My_Model
{

    public function __construct()
    {
        parent::__construct();
    }

    public function getRecords($params = []){
        $params = init_model_params($params);
        $this->db->select(API_SUBSCRIPTION_STAT_FIELD);
        get_where($params['where']);
        $this->db->from($this->subscription_stat_table . ' AS subscription_stats');
        if ($params['action'] != 'count') get_order($params['order']);
        get_limit($params['limit'], $params['offset']);
        $query = $this->db->get();
        return get_data($params, $query);
    }

    public function getDatatableList($params = []){
        $params = init_model_params($params);
        $this->db->select(API_SUBSCRIPTION_STAT_FIELD);
        get_where($params['where']);
        get_filter_where(SUBSCRIPTION_STAT_SEARCHABLE_FIELD);
        if ($params['action'] != 'count') {
            get_filter_order($_REQUEST, $params['order'], SUBSCRIPTION_STAT_ORDERABLE_FIELD);
            get_limit($params['limit'], $params['offset']);
        }
        $this->db->from($this->subscription_stat_table . ' AS subscription_stats');
        $query = $this->db->get();
        return get_data($params, $query);
    }

    public function apple_subscription_stats($date){
        return $this->db->get_where($this->subscription_stat_table,array('store' => 'apple','stat_date'=>$date))->row();
    }

    public function android_subscription_stats($date){
        return $this->db->get_where($this->subscription_stat_table,array('store' => 'android','stat_date'=>$date))->row();
    }
    
    public function monthly_dates($start,$end){
        $query = $this->db->select('DISTINCT(stat_date) AS stat_date')
        ->from($this->subscription_stat_table)
        ->where("stat_date >= '".$start."' and stat_date < '".$end."'");
        $query = $this->db->get();
        return $query->result();
    }

    public function monthly_apple_subscription_stat($date){
        $query = $this->db->select(API_SUBSCRIPTION_STAT_FIELDS)
        ->from($this->subscription_stat_table)
        ->where('store', 'apple')
        ->where('stat_date',$date);
        $query = $this->db->get();
        return $query->result();
    }

    public function monthly_android_subscription_stat($date){
        $query = $this->db->select(API_SUBSCRIPTION_STAT_FIELDS)
        ->from($this->subscription_stat_table)
        ->where('store', 'android')
        ->where('stat_date',$date);
        $query = $this->db->get();
        return $query->result();
    }

    public function total_ios_stats($start,$end){
        $query = $this->db->select(API_SUBSCRIPTION_STAT_TOTAL)
        ->from($this->subscription_stat_table)
        ->where('store','apple')
        ->where("stat_date >= '".$start."' and stat_date < '".$end."'");
        $query = $this->db->get();
        return $query->result();
    }

    public function total_android_stats($start,$end){
        $query = $this->db->select(API_SUBSCRIPTION_STAT_TOTAL)
        ->from($this->subscription_stat_table)
        ->where('store','android')
        ->where("stat_date >= '".$start."' and stat_date < '".$end."'");
        $query = $this->db->get();
        return $query->result();
    }
    
}
?>