<?php $permission_auth = $this->authlib->isAuthorizedLink($permissions,'user'); ?>
<?php if($permission_auth): ?>
<div class="card">
    <div class="card-header h5">
        <h3 class="card-title cursor-pointer" data-card-widget="collapse">User Analytics</h3>
        <div class="card-tools">
            <button type="button" class="btn btn-tool" data-card-widget="collapse"><i class="fas fa-minus"></i></button>
        </div>
    </div>
    <div class="card-body collapsed">
        <div class="form-row">
            <div class="col-md-3 col-sm-6 col-xs-12 mb-2 mb-lg-0">
                <div class="small-box bg-light mb-0">
                    <div class="inner"><h3><?=$stats['users'];?></h3><p>Users</p></div>
                    <div class="icon"><i class="fas fa-users"></i></div>
                    <a href="<?=ADMIN_URL.'user';?>" class="small-box-footer">More info <i class="fas fa-arrow-circle-right"></i></a>
                </div>
            </div>
            <div class="col-md-3 col-sm-6 col-xs-12 mb-2 mb-lg-0">
                <div class="small-box bg-light mb-0">
                    <div class="inner"><h3><?=$stats['new_users'];?></h3><p>Latest Users</p></div>
                    <div class="icon"><i class="fas fa-user-friends"></i></div>
                    <a href="<?=ADMIN_URL.'user/latest';?>" class="small-box-footer">More info <i class="fas fa-arrow-circle-right"></i></a>
                </div>
            </div>
            <div class="col-md-3 col-sm-6 col-xs-12 mb-2 mb-lg-0">
                <div class="small-box bg-light mb-0">
                    <div class="inner"><h3><?=$stats['guest_users'];?></h3><p>Guest Users</p></div>
                    <div class="icon"><i class="fas fa-fas fa-user-secret"></i></div>
                    <a href="<?=ADMIN_URL.'guest-user';?>" class="small-box-footer">More info <i class="fas fa-arrow-circle-right"></i></a>
                </div>
            </div>
            <div class="col-md-3 col-sm-6 col-xs-12 mb-2 mb-lg-0">
                <div class="small-box bg-light mb-0">
                    <div class="inner"><h3><?=$stats['new_guest_users'];?></h3><p>Latest Guest Users</p></div>
                    <div class="icon"><i class="fas fa-fas fa-user-secret"></i></div>
                    <a href="<?=ADMIN_URL.'guest-user/latest';?>" class="small-box-footer">More info <i class="fas fa-arrow-circle-right"></i></a>
                </div>
            </div>
        </div>
    </div>
</div>
<?php endif; ?>
<div class="card">
    <div class="card-header h5">
        <h3 class="card-title cursor-pointer" data-card-widget="collapse">Subscription Analytics</h3>
        <div class="card-tools">
            <button type="button" class="btn btn-tool" data-card-widget="collapse"><i class="fas fa-minus"></i></button>
        </div>
    </div>
    <div class="card-body collapsed">
        <div class="form-row">
            <div class="col-md-3 col-sm-6 col-xs-12 mb-2 mb-lg-0">
                <div class="small-box bg-light mb-0">
                    <div class="inner"><h3><?=$stats['active_subscribers'];?></h3><p>Active Subscriptions</p></div>
                    <div class="icon"><i class="fas fa-user-check"></i></div>
                </div>
            </div>
            <div class="col-md-3 col-sm-6 col-xs-12 mb-2 mb-lg-0">
                <div class="small-box bg-light mb-0">
                    <div class="inner"><h3><?=$stats['expired_subscribers'];?></h3><p>Expired Subscriptions</p></div>
                    <div class="icon"><i class="fas fa-user-times"></i></div>
                </div>
            </div>
            <div class="col-md-3 col-sm-6 col-xs-12 mb-2 mb-lg-0">
                <div class="small-box bg-light mb-0">
                    <div class="inner"><h3><?=$stats['trial_subscribers'];?></h3><p>Active Trials</p></div>
                    <div class="icon"><i class="fas fa-user-clock"></i></div>
                </div>
            </div>
            <div class="col-md-3 col-sm-6 col-xs-12 mb-2 mb-lg-0">
                <div class="small-box bg-light mb-0">
                    <div class="inner"><h3><i class="fas fa-dollar-sign"></i> <?=number_format($stats['auth_revenue'], 2);?></h3><p>MRR</p></div>
                    <div class="icon"><i class="fas fa-money-bill-alt"></i></div>
                </div>
            </div>
        </div>
    </div>
</div>
<div class="card">
    <div class="card-header h5">
        <h3 class="card-title cursor-pointer" data-card-widget="collapse">Guest Subscription Analytics</h3>
        <div class="card-tools">
            <button type="button" class="btn btn-tool" data-card-widget="collapse"><i class="fas fa-minus"></i></button>
        </div>
    </div>
    <div class="card-body collapsed">
        <div class="form-row">
            <div class="col-md-3 col-sm-6 col-xs-12 mb-2 mb-lg-0">
                <div class="small-box bg-light mb-0">
                    <div class="inner"><h3><?=$stats['active_guest_subscribers'];?></h3><p>Active Subscriptions</p></div>
                    <div class="icon"><i class="fas fa-user-check"></i></div>
                </div>
            </div>
            <div class="col-md-3 col-sm-6 col-xs-12 mb-2 mb-lg-0">
                <div class="small-box bg-light mb-0">
                    <div class="inner"><h3><?=$stats['expired_guest_subscribers'];?></h3><p>Expired Subscriptions</p></div>
                    <div class="icon"><i class="fas fa-user-times"></i></div>
                </div>
            </div>
            <div class="col-md-3 col-sm-6 col-xs-12 mb-2 mb-lg-0">
                <div class="small-box bg-light mb-0">
                    <div class="inner"><h3><?=$stats['trial_guest_subscribers'];?></h3><p>Active Trials</p></div>
                    <div class="icon"><i class="fas fa-user-clock"></i></div>
                </div>
            </div>
            <div class="col-md-3 col-sm-6 col-xs-12 mb-2 mb-lg-0">
                <div class="small-box bg-light mb-0">
                    <div class="inner"><h3><i class="fas fa-dollar-sign"></i> <?=number_format($stats['guest_revenue'], 2);?></h3><p>MRR</p></div>
                    <div class="icon"><i class="fas fa-money-bill-alt"></i></div>
                </div>
            </div>
        </div>
    </div>
</div>
<div class="card my-3 collapsed-card">
    <div class="card-header h5">
        <h3 class="card-title">Monthly Subscription Analytics</h3>
        <div class="card-tools">
            <button class="btn btn-tool btn-theme user-device-stats-chart" data-type="line">Line</button>
            <button class="btn btn-tool btn-default user-device-stats-chart" data-type="column">Column</button>
            <button class="btn btn-tool btn-default user-device-stats-chart" data-type="bar">Bar</button>
            <button type="button" class="btn btn-tool btn-default" data-card-widget="collapse"><i class="fas fa-plus"></i></button>
        </div>
    </div>
    <div class="card-body" style="display: none;">
        <div class="row">
            <div id="user-device-stats-chart" class="col">
                <figure class="highcharts-figure">
                    <div id="user-device-stats"></div>
                </figure>
            </div>
        </div>
    </div>
</div>
<div class="card my-3 collapsed-card">
    <div class="card-header h5">
        <h3 class="card-title">Monthly Guest Subscription Analytics</h3>
        <div class="card-tools">
            <button class="btn btn-tool btn-theme guest-user-device-stats-chart" data-type="line">Line</button>
            <button class="btn btn-tool btn-default guest-user-device-stats-chart" data-type="column">Column</button>
            <button class="btn btn-tool btn-default guest-user-device-stats-chart" data-type="bar">Bar</button>
            <button type="button" class="btn btn-tool btn-default" data-card-widget="collapse"><i class="fas fa-plus"></i></button>
        </div>
    </div>
    <div class="card-body" style="display: none;">
        <div class="row">
            <div id="guest-user-device-stats-chart" class="col">
                <figure class="highcharts-figure">
                    <div id="guest-user-device-stats"></div>
                </figure>
            </div>
        </div>
    </div>
</div>
