<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta http-equiv="X-UA-Compatible" content="IE=edge">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Report of Premium Servers</title>
</head>
<body>
    <table border="1">
        <tbody>
            <tr>
                <th colspan="11"><h2 style="text-align: center; margin: 5px;">Inactive Premium Servers</h2></th>
            </tr>
            <tr>
                <th rowspan="2">#</th>
                <th rowspan="2">Flag</th>
                <th rowspan="2">Country</th>
                <th rowspan="2">Country Code</th>
                <th rowspan="2">IP Address</th>
                <th rowspan="2">Hostname</th>
                <th colspan="5">Protocols</th>
            </tr>
            <tr>
                <th>l2tp</th>
                <th>openvpn</th>
                <th>ikev2</th>
                <th>ss2</th>
                <th>wg</th>
            </tr>
            <?php if(!empty($inactive_servers) && count($inactive_servers) > 0): ?>
                <?php $i=0; ?>
                <?php foreach($inactive_servers as $server): ?>
                <tr>
                    <td align="center"><?=++$i;?></td>
                    <td><img src="<?=$server['flag'];?>" width="30"/></td>
                    <td align="center"><?=$server['name'];?></td>
                    <td align="center"><?=$server['country'];?></td>
                    <td align="center"><?=$server['ip'];?></td>
                    <td align="center"><?=$server['hostname'];?></td>
                    <td align="center" width="60"><?=json_decode($server['protocols'], true)['l2tp'] ? '✔' : '✖';?></td>
                    <td align="center" width="60"><?=json_decode($server['protocols'], true)['openvpn'] ? '✔' : '✖';?></td>
                    <td align="center" width="60"><?=json_decode($server['protocols'], true)['ikev2'] ? '✔' : '✖';?></td>
                    <td align="center" width="60"><?=json_decode($server['protocols'], true)['ss2'] ? '✔' : '✖';?></td>
                    <td align="center" width="60"><?=json_decode($server['protocols'], true)['wg'] ? '✔' : '✖';?></td>
                </tr>
                <?php endforeach; ?>
            <?php else: ?>
                <td colspan="11" align="center">No server found</td>
            <?php endif; ?>
            <tr><td colspan="11" align="center">&nbsp;</td></tr>
            <tr>
                <th colspan="11"><h2 style="text-align: center; margin: 5px;">Active Premium Servers</h2></th>
            </tr>
            <tr>
                <th rowspan="2">#</th>
                <th rowspan="2">Flag</th>
                <th rowspan="2">Country</th>
                <th rowspan="2">Country Code</th>
                <th rowspan="2">IP Address</th>
                <th rowspan="2">Hostname</th>
                <th colspan="5">Protocols</th>
            </tr>
            <tr>
                <th>l2tp</th>
                <th>openvpn</th>
                <th>ikev2</th>
                <th>ss2</th>
                <th>wg</th>
            </tr>
            <?php if(!empty($active_servers) && count($active_servers) > 0): ?>
                <?php $i=0; ?>
                <?php foreach($active_servers as $server): ?>
                <tr>
                    <td align="center"><?=++$i;?></td>
                    <td><img src="<?=$server['flag'];?>" width="30"/></td>
                    <td align="center"><?=$server['name'];?></td>
                    <td align="center"><?=$server['country'];?></td>
                    <td align="center"><?=$server['ip'];?></td>
                    <td align="center"><?=$server['hostname'];?></td>
                    <td align="center" width="60"><?=json_decode($server['protocols'], true)['l2tp'] ? '✔' : '✖';?></td>
                    <td align="center" width="60"><?=json_decode($server['protocols'], true)['openvpn'] ? '✔' : '✖';?></td>
                    <td align="center" width="60"><?=json_decode($server['protocols'], true)['ikev2'] ? '✔' : '✖';?></td>
                    <td align="center" width="60"><?=json_decode($server['protocols'], true)['ss2'] ? '✔' : '✖';?></td>
                    <td align="center" width="60"><?=json_decode($server['protocols'], true)['wg'] ? '✔' : '✖';?></td>
                </tr>
                <?php endforeach; ?>
            <?php else: ?>
                <td colspan="11" align="center">No server found</td>
            <?php endif; ?>
        </tbody>
    </table>
</body>
</html>