-- 
UPDATE webhook_subscriptions SET created_at = purchase_date_ms / 1000 WHERE 1;
SELECT * FROM `webhook_subscriptions` WHERE `original_transaction_id` NOT IN (SELECT `original_transaction_id` FROM `user_subscriptions`);

-- 06/09/2021
ALTER TABLE `user_devices` ADD `wholesaler_key` VARCHAR(255) NULL DEFAULT NULL AFTER `device_unique_id`;
ALTER TABLE `user_subscriptions` ADD `user_device_id` INT NULL AFTER `user_id`;
ALTER TABLE `user_subscriptions` ADD CONSTRAINT `user_subscriptions_ibfk_2` FOREIGN KEY (`user_device_id`) REFERENCES `user_devices`(`user_device_id`) ON DELETE CASCADE ON UPDATE CASCADE;
ALTER TABLE `user_subscriptions` CHANGE `user_id` `user_id` INT(11) NULL;

UPDATE user_subscriptions subs
JOIN (SELECT * FROM `user_device_logins` where user_id in (SELECT user_id FROM `user_subscriptions`) group by user_id) AS temp on temp.user_id = subs.user_id
SET subs.user_device_id = temp.user_device_id
WHERE 1;

ALTER TABLE `user_subscriptions` ADD `updated_at` INT NOT NULL AFTER `created_at`;
UPDATE `user_subscriptions` SET `updated_at`= created_at WHERE 1;

ALTER TABLE `user_devices` CHANGE `wholesaler_key` `wholesaler_user` VARCHAR(255) CHARACTER SET latin1 COLLATE latin1_swedish_ci NULL DEFAULT NULL;
-- Done

ALTER TABLE `user_subscriptions` DROP `is_expired`;

-- 13/09/2021
ALTER TABLE `user_subscriptions` ADD INDEX(`original_transaction_id`);
ALTER TABLE `webhook_subscriptions` ADD INDEX(`original_transaction_id`);
ALTER TABLE `admins` ADD INDEX(`admin_email`);
ALTER TABLE `users` ADD INDEX(`email`);

-- 30/09/2021
ALTER TABLE `user_subscriptions` CHANGE `original_transaction_id` `original_transaction_id` VARCHAR(255) NOT NULL;

-- 01/10/2021
ALTER TABLE `webhook_subscriptions` ADD `price` FLOAT NOT NULL DEFAULT '0' AFTER `cancellation_date_ms`;
UPDATE `webhook_subscriptions` SET price = 8.99 WHERE `notification_type` in ('DID_RENEW','INITIAL_BUY') AND product_id = 'com.optimal.vpn.month';
UPDATE `webhook_subscriptions` SET price = 33.99 WHERE `notification_type` in ('DID_RENEW','INITIAL_BUY') AND product_id = 'com.optimal.vpn.year';
UPDATE `webhook_subscriptions` SET price = 11.99 WHERE `notification_type` in ('DID_RENEW','INITIAL_BUY') AND product_id = 'com.optimal.vpn.stream.month';
UPDATE `webhook_subscriptions` SET price = 69.99 WHERE `notification_type` in ('DID_RENEW','INITIAL_BUY') AND product_id = 'com.optimal.vpn.stream.year';

-- 04/10/2021
UPDATE `user_devices` SET device_type = 'A' WHERE LENGTH(device_unique_id) = 16;
ALTER TABLE `webhook_subscriptions` ADD INDEX(`product_id`);

-- 05/10/2021
UPDATE `webhook_subscriptions` SET price = 8.99 WHERE `notification_type` in ('INITIAL_BUY','DID_RENEW','INTERACTIVE_RENEWAL') AND product_id = 'com.optimal.vpn.month';
UPDATE `webhook_subscriptions` SET price = 33.99 WHERE `notification_type` in ('INITIAL_BUY','DID_RENEW','INTERACTIVE_RENEWAL') AND product_id = 'com.optimal.vpn.year';
UPDATE `webhook_subscriptions` SET price = 11.99 WHERE `notification_type` in ('INITIAL_BUY','DID_RENEW','INTERACTIVE_RENEWAL') AND product_id = 'com.optimal.vpn.stream.month';
UPDATE `webhook_subscriptions` SET price = 69.99 WHERE `notification_type` in ('INITIAL_BUY','DID_RENEW','INTERACTIVE_RENEWAL') AND product_id = 'com.optimal.vpn.stream.year';

-- 24/11/2021
CREATE TABLE `subscription_receipts` ( `transaction_id` VARCHAR(255) NOT NULL , `latest_receipt` TEXT NOT NULL ) ENGINE = InnoDB;
ALTER TABLE `subscription_receipts` ADD INDEX(`transaction_id`);
INSERT INTO subscription_receipts (transaction_id, latest_receipt) SELECT transaction_id, latest_receipt FROM `webhook_subscriptions` WHERE 1 ORDER by transaction_id asc;
UPDATE webhook_subscriptions SET latest_receipt = "" WHERE 1;
ALTER TABLE `webhook_subscriptions` DROP `latest_receipt`;

-- 26/11/2021
ALTER TABLE `webhook_subscriptions` ADD INDEX(`is_trial_period`);

-- 30/11/2021
ALTER TABLE `user_devices` ADD `is_expired_from_sdk` BOOLEAN NOT NULL DEFAULT FALSE AFTER `wholesaler_user`;

-- 03/12/2021
CREATE TABLE `subscription_analytics` (
    `analytics_id` INT NOT NULL AUTO_INCREMENT,
    `month` INT NOT NULL,
    `year` INT NOT NULL,
    `active_guests` INT NOT NULL DEFAULT '0',
    `active_users` INT NOT NULL DEFAULT '0',
    `expired_guests` INT NOT NULL DEFAULT '0',
    `expired_users` INT NOT NULL DEFAULT '0',
    `active_trial_users` INT NOT NULL DEFAULT '0',
    `active_trial_guests` INT NOT NULL DEFAULT '0',
    `created_at` BIGINT NOT NULL,
    PRIMARY KEY  (`analytics_id`)
) ENGINE = InnoDB;

-- 08/12/2021
ALTER TABLE `webhook_subscriptions` ADD `notification_store` VARCHAR(255) NOT NULL DEFAULT 'apple' AFTER `webhook_subscription_id`;
ALTER TABLE `webhook_subscriptions` CHANGE `notification_store` `notification_store` ENUM('apple','android','amazon') CHARACTER SET latin1 COLLATE latin1_swedish_ci NOT NULL DEFAULT 'apple';
UPDATE webhook_subscriptions set notification_store = "android" WHERE `transaction_id` LIKE 'GPA%';
UPDATE webhook_subscriptions set notification_type = 'SUBSCRIPTION_RECOVERED' WHERE notification_store = 'android' and notification_type = '';

-- 17/01/2022
ALTER TABLE `user_devices` CHANGE `device_type` `device_type` ENUM('I','A','M') CHARACTER SET latin1 COLLATE latin1_swedish_ci NOT NULL DEFAULT 'I' COMMENT 'I=iOS, A=Android';

-- 03/03/2022
ALTER TABLE `subscription_receipts` ADD `receipt_created_at` BIGINT(20) NULL DEFAULT NULL AFTER `latest_receipt`;
CREATE TRIGGER `receipt_creation_time` BEFORE INSERT ON `subscription_receipts` FOR EACH ROW SET NEW.receipt_created_at = UNIX_TIMESTAMP();
-- UPDATE `subscription_receipts` as sr JOIN webhook_subscriptions as ws on ws.transaction_id = sr.transaction_id SET sr.receipt_created_at = ws.created_at;

-- 23/03/2022

CREATE TABLE `open_get_server` (
  `id` int NOT NULL,
  `country` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `country_code` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `ip_address` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `ovpn` text CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `premium` tinyint(1) NOT NULL DEFAULT '0',
  `recommend` tinyint(1) NOT NULL DEFAULT '0',
  `state` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `is_active` tinyint(1) NOT NULL DEFAULT '1',
  `created_at` bigint NOT NULL,
  `updated_at` bigint NOT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

INSERT INTO `open_get_server` (`id`, `country`, `country_code`, `ip_address`, `ovpn`, `premium`, `recommend`, `state`, `is_active`, `created_at`, `updated_at`) VALUES
(79, 'Optimal Location', 'CA', '51.222.111.55', 'client\r\ndev tun\r\nproto udp\r\nremote 51.222.111.55 1194\r\nresolv-retry infinite\r\nnobind\r\nuser nobody\r\ngroup nogroup\r\npersist-key\r\npersist-tun\r\nmute-replay-warnings\r\nremote-cert-tls server\r\ncipher AES-256-CBC\r\nauth SHA256\r\nverb 4\r\nkey-direction 1\r\n\r\n<ca>\r\n-----BEGIN CERTIFICATE-----\r\nMIIDSzCCAjOgAwIBAgIULJ/P+2LAMxTSQIUOKma17+uWen4wDQYJKoZIhvcNAQEL\r\nBQAwFjEUMBIGA1UEAwwLRWFzeS1SU0EgQ0EwHhcNMjAwNzA3MTQ0OTMyWhcNMzAw\r\nNzA1MTQ0OTMyWjAWMRQwEgYDVQQDDAtFYXN5LVJTQSBDQTCCASIwDQYJKoZIhvcN\r\nAQEBBQADggEPADCCAQoCggEBALTDnabqBE7oYcE3mLBC91hhDtugCZQr+WIS/sV8\r\nujHmE9hSxs150b0VubNTA6B59Fcifj9R8hzRgi0EA1X8JKj+qF3+kOnsR4q+7Is/\r\nUcd3rV4UHrUFFEKMP+Ox5roiDrV3ZEHMY3JVZ0EJdNhpD1xpiEeAUoDrpI4EP/+r\r\n5a9e3e+ZpU24C0DKa2dDQpcwX5ZeM8GJXw+nzUo4JBCoultxcF/cCBwShSZr7u7z\r\nskvQSSkE4c2G1mbwKYF3xi61i9rIcGKjPufuHMS+hVZYwduyx9xSvXIu9MDReyQX\r\n9nEwh55MpKvE1gwYvevJNzsUnvG48vutrW/POxIr1DW3SmMCAwEAAaOBkDCBjTAd\r\nBgNVHQ4EFgQUehvU3gUNR3VDRrDVZDU+RbcGTtQwUQYDVR0jBEowSIAUehvU3gUN\r\nR3VDRrDVZDU+RbcGTtShGqQYMBYxFDASBgNVBAMMC0Vhc3ktUlNBIENBghQsn8/7\r\nYsAzFNJAhQ4qZrXv65Z6fjAMBgNVHRMEBTADAQH/MAsGA1UdDwQEAwIBBjANBgkq\r\nhkiG9w0BAQsFAAOCAQEAQcs0HubtqZIazSBK9mMqYnCmJ/P16iTXbro+te/T2Mfu\r\nqM1rFaumsibvvu9FhE7kdIG9F4mjB5K3JXtWc6CZqBcLooM6kzOxTeu0Rx4wNVdd\r\nBRjASWqZHhG3vNCI5gXUu2cI1EE6PjLyxuSYbNFZ6JIn0XxjQfvr7JrLBpMGjRgo\r\nrGjUT+jQ4KnegGBWNYtnDv7or660/gmhcvyhK4iTMqPGbEDEI4Qx1ZUwQjFjC18F\r\nlYl0FMXoVz/LB3U1weG8W5pe4E5xE2K+H8Ez943Szme8Bf6DEcZ9K2j+e258rBpc\r\nfYqDAkdRwpevMvXc/YD/7wMqw4pMgxu4dPJV7AOcsQ==\r\n-----END CERTIFICATE-----\r\n</ca>\r\n<cert>\r\nCertificate:\r\n    Data:\r\n        Version: 3 (0x2)\r\n        Serial Number:\r\n            62:73:e0:a9:06:aa:f6:f3:83:13:16:37:64:3c:d4:7e\r\n        Signature Algorithm: sha256WithRSAEncryption\r\n        Issuer: CN=Easy-RSA CA\r\n        Validity\r\n            Not Before: Jul  8 08:16:59 2020 GMT\r\n            Not After : Jul  6 08:16:59 2030 GMT\r\n        Subject: CN=client-de0\r\n        Subject Public Key Info:\r\n            Public Key Algorithm: rsaEncryption\r\n                RSA Public-Key: (2048 bit)\r\n                Modulus:\r\n                    00:db:d4:d2:63:6b:59:2a:92:68:99:35:e8:41:e7:\r\n                    e5:3f:1b:aa:ba:e7:c7:23:55:73:e4:1a:14:f2:1d:\r\n                    23:cd:36:8e:8b:cc:f9:2a:76:12:20:66:78:71:54:\r\n                    87:15:8b:5d:fc:c2:f4:6e:0e:37:6a:83:e0:9d:1e:\r\n                    71:fa:05:b3:28:3b:1c:aa:1b:ed:7c:c9:cc:57:75:\r\n                    13:1c:5f:aa:25:ed:cb:d2:29:7b:8a:cc:85:9a:1a:\r\n                    69:59:6f:11:6e:36:97:68:50:80:c3:00:97:69:5e:\r\n                    ff:c9:87:06:36:ad:fa:14:14:31:a3:45:95:eb:01:\r\n                    68:f6:2d:01:03:82:be:61:ab:14:a4:26:5f:1c:7e:\r\n                    81:ee:c5:e9:fe:64:11:b2:dd:56:5b:33:36:5a:33:\r\n                    a6:c8:9b:46:4a:b2:d9:30:28:79:bc:b0:bf:80:5b:\r\n                    c9:b6:ff:d4:09:4c:29:42:17:6a:75:35:eb:ff:8a:\r\n                    c8:b9:89:73:7d:e7:84:0d:64:00:3f:3a:52:8a:11:\r\n                    65:e7:9e:da:c3:1f:d4:a3:f7:37:e2:5d:25:8e:d4:\r\n                    42:24:9a:7a:a3:28:27:92:d4:49:5a:fa:df:61:00:\r\n                    12:50:b1:8e:67:81:01:12:b6:21:68:6b:4b:14:85:\r\n                    b7:29:54:2f:75:e6:07:4f:17:76:9a:63:cf:3e:71:\r\n                    cf:bd\r\n                Exponent: 65537 (0x10001)\r\n        X509v3 extensions:\r\n            X509v3 Basic Constraints: \r\n                CA:FALSE\r\n            X509v3 Subject Key Identifier: \r\n                69:9A:79:AD:CF:44:C8:04:B3:48:7F:67:1E:2E:A7:C8:C4:CA:D1:8F\r\n            X509v3 Authority Key Identifier: \r\n                keyid:7A:1B:D4:DE:05:0D:47:75:43:46:B0:D5:64:35:3E:45:B7:06:4E:D4\r\n                DirName:/CN=Easy-RSA CA\r\n                serial:2C:9F:CF:FB:62:C0:33:14:D2:40:85:0E:2A:66:B5:EF:EB:96:7A:7E\r\n\r\n            X509v3 Extended Key Usage: \r\n                TLS Web Client Authentication\r\n            X509v3 Key Usage: \r\n                Digital Signature\r\n    Signature Algorithm: sha256WithRSAEncryption\r\n         82:69:48:07:65:89:15:f3:89:49:8a:d3:19:fb:84:f6:6a:f7:\r\n         89:67:8d:bf:ae:6f:4a:83:0d:5d:82:df:79:be:86:68:e8:9a:\r\n         55:0c:0c:dd:c8:e5:fb:f9:4f:e1:61:3a:a3:05:97:0f:2a:f2:\r\n         a3:a5:7d:5b:c8:27:8a:9c:79:b8:dd:c7:56:05:6d:06:20:b4:\r\n         ca:f3:5c:c8:5c:df:e0:18:1b:34:6a:bf:a0:d8:50:e6:ad:d3:\r\n         4f:a0:17:3f:ef:cd:8a:a9:9b:97:a3:2c:75:0f:e5:c3:b4:b6:\r\n         b6:1e:72:f5:f6:2d:5f:0d:cf:1a:bc:f7:c4:c5:18:c3:db:89:\r\n         4e:38:89:7f:d2:f7:08:c2:59:76:3e:4a:25:75:7c:96:13:c8:\r\n         dd:56:bf:e0:e2:47:c3:30:93:41:7a:31:0d:c3:93:16:6d:e0:\r\n         55:d9:43:cf:2b:a0:18:3c:d4:4d:72:f8:df:dc:7b:49:83:e2:\r\n         0b:70:f3:02:7f:ea:a6:e9:6b:78:3e:a1:05:08:4d:ad:44:9d:\r\n         a5:cd:0a:de:6e:77:24:ab:73:66:38:cc:2b:da:d8:dc:b7:b8:\r\n         a1:15:d8:85:86:c7:6b:72:d5:09:e3:1d:41:e4:1a:79:9a:23:\r\n         a5:81:59:7b:8d:5e:8e:37:4d:04:f2:eb:7b:44:78:89:bc:02:\r\n         54:69:de:d7\r\n-----BEGIN CERTIFICATE-----\r\nMIIDWDCCAkCgAwIBAgIQYnPgqQaq9vODExY3ZDzUfjANBgkqhkiG9w0BAQsFADAW\r\nMRQwEgYDVQQDDAtFYXN5LVJTQSBDQTAeFw0yMDA3MDgwODE2NTlaFw0zMDA3MDYw\r\nODE2NTlaMBUxEzARBgNVBAMMCmNsaWVudC1kZTAwggEiMA0GCSqGSIb3DQEBAQUA\r\nA4IBDwAwggEKAoIBAQDb1NJja1kqkmiZNehB5+U/G6q658cjVXPkGhTyHSPNNo6L\r\nzPkqdhIgZnhxVIcVi138wvRuDjdqg+CdHnH6BbMoOxyqG+18ycxXdRMcX6ol7cvS\r\nKXuKzIWaGmlZbxFuNpdoUIDDAJdpXv/JhwY2rfoUFDGjRZXrAWj2LQEDgr5hqxSk\r\nJl8cfoHuxen+ZBGy3VZbMzZaM6bIm0ZKstkwKHm8sL+AW8m2/9QJTClCF2p1Nev/\r\nisi5iXN954QNZAA/OlKKEWXnntrDH9Sj9zfiXSWO1EIkmnqjKCeS1Ela+t9hABJQ\r\nsY5ngQEStiFoa0sUhbcpVC915gdPF3aaY88+cc+9AgMBAAGjgaIwgZ8wCQYDVR0T\r\nBAIwADAdBgNVHQ4EFgQUaZp5rc9EyASzSH9nHi6nyMTK0Y8wUQYDVR0jBEowSIAU\r\nehvU3gUNR3VDRrDVZDU+RbcGTtShGqQYMBYxFDASBgNVBAMMC0Vhc3ktUlNBIENB\r\nghQsn8/7YsAzFNJAhQ4qZrXv65Z6fjATBgNVHSUEDDAKBggrBgEFBQcDAjALBgNV\r\nHQ8EBAMCB4AwDQYJKoZIhvcNAQELBQADggEBAIJpSAdliRXziUmK0xn7hPZq94ln\r\njb+ub0qDDV2C33m+hmjomlUMDN3I5fv5T+FhOqMFlw8q8qOlfVvIJ4qcebjdx1YF\r\nbQYgtMrzXMhc3+AYGzRqv6DYUOat00+gFz/vzYqpm5ejLHUP5cO0trYecvX2LV8N\r\nzxq898TFGMPbiU44iX/S9wjCWXY+SiV1fJYTyN1Wv+DiR8Mwk0F6MQ3DkxZt4FXZ\r\nQ88roBg81E1y+N/ce0mD4gtw8wJ/6qbpa3g+oQUITa1EnaXNCt5udySrc2Y4zCva\r\n2Ny3uKEV2IWGx2ty1QnjHUHkGnmaI6WBWXuNXo43TQTy63tEeIm8AlRp3tc=\r\n-----END CERTIFICATE-----\r\n</cert>\r\n<key>\r\n-----BEGIN PRIVATE KEY-----\r\nMIIEvwIBADANBgkqhkiG9w0BAQEFAASCBKkwggSlAgEAAoIBAQDb1NJja1kqkmiZ\r\nNehB5+U/G6q658cjVXPkGhTyHSPNNo6LzPkqdhIgZnhxVIcVi138wvRuDjdqg+Cd\r\nHnH6BbMoOxyqG+18ycxXdRMcX6ol7cvSKXuKzIWaGmlZbxFuNpdoUIDDAJdpXv/J\r\nhwY2rfoUFDGjRZXrAWj2LQEDgr5hqxSkJl8cfoHuxen+ZBGy3VZbMzZaM6bIm0ZK\r\nstkwKHm8sL+AW8m2/9QJTClCF2p1Nev/isi5iXN954QNZAA/OlKKEWXnntrDH9Sj\r\n9zfiXSWO1EIkmnqjKCeS1Ela+t9hABJQsY5ngQEStiFoa0sUhbcpVC915gdPF3aa\r\nY88+cc+9AgMBAAECggEBAJFSc3J9uIhIGRWPaWaIIihB5e+A4UgeaWpVQ5t6X/x9\r\nIGaSrfS/8OOyWdSxiEtZwlwhlOxcQY4MeCPlyHr74Z+q1BwwMiLYVFlMb8HGC/je\r\n5mqcOatb4MYqx5HztpYhSJ4Q+c3vSijCQF29AQKMqFE1uEqy6ZRdbkGvJohnmet9\r\nr5H1GzD9KTL2HxSuW76HDcYGtrConz98veZOkhFleES1S4ZYd8EyCb0G5+q+iy6s\r\naxzKkhSEXeLGBFg74Yhzvaht5JO6ZSMCq9URr1qt7qOxivBDXTI6z8DDyxyW4mx5\r\naYBU7ZPDtKg4l9bJAO+dXQgACz+4/jbwgft3L6q5o5ECgYEA73S3AUkZ7C1lkEAu\r\n87zcILIXopKt5Fe9V8p/wlKTZL8OLOZ61LunwM5wWWjbG5m8zLBY2NjNsISSw2Sn\r\nmwejzIC6enFkYRtNtzGwXeSWq8pGmyQUoY++2nBk0yWC6MCc9zoEBTvnZADDZ0Em\r\n03qrftwIFp//Ma7uzCLYjFCiobcCgYEA6wUBMWbOxJnWbFn7odH3lomfM32X9a7K\r\n/bpXTBf9Qk+8njVbAAiX2dj6jnxVBQ8YoVK09Q87/t9O/ZpLBwCsol/3tWWkYeSp\r\nHRfobHv1pSFGlmAXuEiRfoMn8LwiSgqPdWofKm8GjHppSMadjWnJgWxZMhqJ7yEN\r\ngLnoFaesiisCgYBf2y4jQpsw819T5o2lHrZUFFbnyqX34bO3QCXyqVG9o8nN6ZnE\r\nLTbTNRC+if4kR1/P5Mw8SlXU0s1ZkKKTqfRFOkbsGxZe1SpAKpD6lTZHoNqw4jms\r\nDzoMga+q4rpL6EctpLjVS4yueKvAWtFrGREr4HMQc44Z2nhXmZ9sVB82cwKBgQCG\r\nQFSfIMhKnEpVmM1acfPJ5ZGwuzTcHl5MtG57xFRi1eO8SGRUT5RW2FDApht3CVmb\r\nhgBi4LH39R5NVh83v9Xd54476/UMCq/kM60Mk38ONkT5T6kdFy8tosRlC0NXIlMy\r\n0k09UzDdfGu6K+MCTgTSzs7hBTH4DNyGxSvjeuXgAwKBgQClaBLmTs3FaWhfLvOs\r\nzzIeiAEzv4eagUims92ym7D0NwgG24gDvaF1+k/aKF4nevuSG+3UeAZHHO/NP0/7\r\npWYYtEdLKqnRL+CcPlVX8OmEAGon5mZAQNMhVWULZXDxnC8IJZ3kmO11MQbKM6ZK\r\n836xsEByT26VtmIqF7b3fcMPMg==\r\n-----END PRIVATE KEY-----\r\n</key>\r\n<tls-auth>\r\n#\r\n# 2048 bit OpenVPN static key\r\n#\r\n-----BEGIN OpenVPN Static key V1-----\r\nf783bbffb7842aaef57c1804691e6682\r\naeebca61555db03aa398db5993c10254\r\n32976641ef2ed5c5e3e97a49dca29440\r\nf583f95034dd28ca1b0de2975493971a\r\nc9eb447e58f737abc8ab1f575f3cc094\r\nc06c55e0840d811b610014998145460c\r\ncb76588cec6fbf5f53c616a5ab0a7265\r\n8014d1d6f487e1b92e3cd621a318041d\r\n8280558b0c6f203cc29e9d7050be040b\r\n5a33347144fe840a73b895f967108895\r\n69119137bc6d320ef50a1d472a245ea2\r\nfc507f926fbacd932cbfc74c13136ddc\r\n48a644cce0c0ad17670e2020e58ede30\r\n7b8dbfcade3efbad75c2af3977a57de8\r\na031644718d76de9cc7f9a5169deed3f\r\n63484a84cc4a62f513444a997f9f0242\r\n-----END OpenVPN Static key V1-----\r\n</tls-auth>\r\n', 0, 1, 'Quebec (Disney+)', 1, 1648013780, 1648131486),
(80, 'Germany', 'DE', '54.37.204.111', 'client\r\ndev tun\r\nproto udp\r\nremote 54.37.204.111 1194\r\nresolv-retry infinite\r\nnobind\r\nuser nobody\r\ngroup nogroup\r\npersist-key\r\npersist-tun\r\nmute-replay-warnings\r\nremote-cert-tls server\r\ncipher AES-256-CBC\r\nauth SHA256\r\nverb 4\r\nkey-direction 1\r\n\r\n<ca>\r\n-----BEGIN CERTIFICATE-----\r\nMIIDSzCCAjOgAwIBAgIULJ/P+2LAMxTSQIUOKma17+uWen4wDQYJKoZIhvcNAQEL\r\nBQAwFjEUMBIGA1UEAwwLRWFzeS1SU0EgQ0EwHhcNMjAwNzA3MTQ0OTMyWhcNMzAw\r\nNzA1MTQ0OTMyWjAWMRQwEgYDVQQDDAtFYXN5LVJTQSBDQTCCASIwDQYJKoZIhvcN\r\nAQEBBQADggEPADCCAQoCggEBALTDnabqBE7oYcE3mLBC91hhDtugCZQr+WIS/sV8\r\nujHmE9hSxs150b0VubNTA6B59Fcifj9R8hzRgi0EA1X8JKj+qF3+kOnsR4q+7Is/\r\nUcd3rV4UHrUFFEKMP+Ox5roiDrV3ZEHMY3JVZ0EJdNhpD1xpiEeAUoDrpI4EP/+r\r\n5a9e3e+ZpU24C0DKa2dDQpcwX5ZeM8GJXw+nzUo4JBCoultxcF/cCBwShSZr7u7z\r\nskvQSSkE4c2G1mbwKYF3xi61i9rIcGKjPufuHMS+hVZYwduyx9xSvXIu9MDReyQX\r\n9nEwh55MpKvE1gwYvevJNzsUnvG48vutrW/POxIr1DW3SmMCAwEAAaOBkDCBjTAd\r\nBgNVHQ4EFgQUehvU3gUNR3VDRrDVZDU+RbcGTtQwUQYDVR0jBEowSIAUehvU3gUN\r\nR3VDRrDVZDU+RbcGTtShGqQYMBYxFDASBgNVBAMMC0Vhc3ktUlNBIENBghQsn8/7\r\nYsAzFNJAhQ4qZrXv65Z6fjAMBgNVHRMEBTADAQH/MAsGA1UdDwQEAwIBBjANBgkq\r\nhkiG9w0BAQsFAAOCAQEAQcs0HubtqZIazSBK9mMqYnCmJ/P16iTXbro+te/T2Mfu\r\nqM1rFaumsibvvu9FhE7kdIG9F4mjB5K3JXtWc6CZqBcLooM6kzOxTeu0Rx4wNVdd\r\nBRjASWqZHhG3vNCI5gXUu2cI1EE6PjLyxuSYbNFZ6JIn0XxjQfvr7JrLBpMGjRgo\r\nrGjUT+jQ4KnegGBWNYtnDv7or660/gmhcvyhK4iTMqPGbEDEI4Qx1ZUwQjFjC18F\r\nlYl0FMXoVz/LB3U1weG8W5pe4E5xE2K+H8Ez943Szme8Bf6DEcZ9K2j+e258rBpc\r\nfYqDAkdRwpevMvXc/YD/7wMqw4pMgxu4dPJV7AOcsQ==\r\n-----END CERTIFICATE-----\r\n</ca>\r\n<cert>\r\nCertificate:\r\n    Data:\r\n        Version: 3 (0x2)\r\n        Serial Number:\r\n            62:73:e0:a9:06:aa:f6:f3:83:13:16:37:64:3c:d4:7e\r\n        Signature Algorithm: sha256WithRSAEncryption\r\n        Issuer: CN=Easy-RSA CA\r\n        Validity\r\n            Not Before: Jul  8 08:16:59 2020 GMT\r\n            Not After : Jul  6 08:16:59 2030 GMT\r\n        Subject: CN=client-de0\r\n        Subject Public Key Info:\r\n            Public Key Algorithm: rsaEncryption\r\n                RSA Public-Key: (2048 bit)\r\n                Modulus:\r\n                    00:db:d4:d2:63:6b:59:2a:92:68:99:35:e8:41:e7:\r\n                    e5:3f:1b:aa:ba:e7:c7:23:55:73:e4:1a:14:f2:1d:\r\n                    23:cd:36:8e:8b:cc:f9:2a:76:12:20:66:78:71:54:\r\n                    87:15:8b:5d:fc:c2:f4:6e:0e:37:6a:83:e0:9d:1e:\r\n                    71:fa:05:b3:28:3b:1c:aa:1b:ed:7c:c9:cc:57:75:\r\n                    13:1c:5f:aa:25:ed:cb:d2:29:7b:8a:cc:85:9a:1a:\r\n                    69:59:6f:11:6e:36:97:68:50:80:c3:00:97:69:5e:\r\n                    ff:c9:87:06:36:ad:fa:14:14:31:a3:45:95:eb:01:\r\n                    68:f6:2d:01:03:82:be:61:ab:14:a4:26:5f:1c:7e:\r\n                    81:ee:c5:e9:fe:64:11:b2:dd:56:5b:33:36:5a:33:\r\n                    a6:c8:9b:46:4a:b2:d9:30:28:79:bc:b0:bf:80:5b:\r\n                    c9:b6:ff:d4:09:4c:29:42:17:6a:75:35:eb:ff:8a:\r\n                    c8:b9:89:73:7d:e7:84:0d:64:00:3f:3a:52:8a:11:\r\n                    65:e7:9e:da:c3:1f:d4:a3:f7:37:e2:5d:25:8e:d4:\r\n                    42:24:9a:7a:a3:28:27:92:d4:49:5a:fa:df:61:00:\r\n                    12:50:b1:8e:67:81:01:12:b6:21:68:6b:4b:14:85:\r\n                    b7:29:54:2f:75:e6:07:4f:17:76:9a:63:cf:3e:71:\r\n                    cf:bd\r\n                Exponent: 65537 (0x10001)\r\n        X509v3 extensions:\r\n            X509v3 Basic Constraints: \r\n                CA:FALSE\r\n            X509v3 Subject Key Identifier: \r\n                69:9A:79:AD:CF:44:C8:04:B3:48:7F:67:1E:2E:A7:C8:C4:CA:D1:8F\r\n            X509v3 Authority Key Identifier: \r\n                keyid:7A:1B:D4:DE:05:0D:47:75:43:46:B0:D5:64:35:3E:45:B7:06:4E:D4\r\n                DirName:/CN=Easy-RSA CA\r\n                serial:2C:9F:CF:FB:62:C0:33:14:D2:40:85:0E:2A:66:B5:EF:EB:96:7A:7E\r\n\r\n            X509v3 Extended Key Usage: \r\n                TLS Web Client Authentication\r\n            X509v3 Key Usage: \r\n                Digital Signature\r\n    Signature Algorithm: sha256WithRSAEncryption\r\n         82:69:48:07:65:89:15:f3:89:49:8a:d3:19:fb:84:f6:6a:f7:\r\n         89:67:8d:bf:ae:6f:4a:83:0d:5d:82:df:79:be:86:68:e8:9a:\r\n         55:0c:0c:dd:c8:e5:fb:f9:4f:e1:61:3a:a3:05:97:0f:2a:f2:\r\n         a3:a5:7d:5b:c8:27:8a:9c:79:b8:dd:c7:56:05:6d:06:20:b4:\r\n         ca:f3:5c:c8:5c:df:e0:18:1b:34:6a:bf:a0:d8:50:e6:ad:d3:\r\n         4f:a0:17:3f:ef:cd:8a:a9:9b:97:a3:2c:75:0f:e5:c3:b4:b6:\r\n         b6:1e:72:f5:f6:2d:5f:0d:cf:1a:bc:f7:c4:c5:18:c3:db:89:\r\n         4e:38:89:7f:d2:f7:08:c2:59:76:3e:4a:25:75:7c:96:13:c8:\r\n         dd:56:bf:e0:e2:47:c3:30:93:41:7a:31:0d:c3:93:16:6d:e0:\r\n         55:d9:43:cf:2b:a0:18:3c:d4:4d:72:f8:df:dc:7b:49:83:e2:\r\n         0b:70:f3:02:7f:ea:a6:e9:6b:78:3e:a1:05:08:4d:ad:44:9d:\r\n         a5:cd:0a:de:6e:77:24:ab:73:66:38:cc:2b:da:d8:dc:b7:b8:\r\n         a1:15:d8:85:86:c7:6b:72:d5:09:e3:1d:41:e4:1a:79:9a:23:\r\n         a5:81:59:7b:8d:5e:8e:37:4d:04:f2:eb:7b:44:78:89:bc:02:\r\n         54:69:de:d7\r\n-----BEGIN CERTIFICATE-----\r\nMIIDWDCCAkCgAwIBAgIQYnPgqQaq9vODExY3ZDzUfjANBgkqhkiG9w0BAQsFADAW\r\nMRQwEgYDVQQDDAtFYXN5LVJTQSBDQTAeFw0yMDA3MDgwODE2NTlaFw0zMDA3MDYw\r\nODE2NTlaMBUxEzARBgNVBAMMCmNsaWVudC1kZTAwggEiMA0GCSqGSIb3DQEBAQUA\r\nA4IBDwAwggEKAoIBAQDb1NJja1kqkmiZNehB5+U/G6q658cjVXPkGhTyHSPNNo6L\r\nzPkqdhIgZnhxVIcVi138wvRuDjdqg+CdHnH6BbMoOxyqG+18ycxXdRMcX6ol7cvS\r\nKXuKzIWaGmlZbxFuNpdoUIDDAJdpXv/JhwY2rfoUFDGjRZXrAWj2LQEDgr5hqxSk\r\nJl8cfoHuxen+ZBGy3VZbMzZaM6bIm0ZKstkwKHm8sL+AW8m2/9QJTClCF2p1Nev/\r\nisi5iXN954QNZAA/OlKKEWXnntrDH9Sj9zfiXSWO1EIkmnqjKCeS1Ela+t9hABJQ\r\nsY5ngQEStiFoa0sUhbcpVC915gdPF3aaY88+cc+9AgMBAAGjgaIwgZ8wCQYDVR0T\r\nBAIwADAdBgNVHQ4EFgQUaZp5rc9EyASzSH9nHi6nyMTK0Y8wUQYDVR0jBEowSIAU\r\nehvU3gUNR3VDRrDVZDU+RbcGTtShGqQYMBYxFDASBgNVBAMMC0Vhc3ktUlNBIENB\r\nghQsn8/7YsAzFNJAhQ4qZrXv65Z6fjATBgNVHSUEDDAKBggrBgEFBQcDAjALBgNV\r\nHQ8EBAMCB4AwDQYJKoZIhvcNAQELBQADggEBAIJpSAdliRXziUmK0xn7hPZq94ln\r\njb+ub0qDDV2C33m+hmjomlUMDN3I5fv5T+FhOqMFlw8q8qOlfVvIJ4qcebjdx1YF\r\nbQYgtMrzXMhc3+AYGzRqv6DYUOat00+gFz/vzYqpm5ejLHUP5cO0trYecvX2LV8N\r\nzxq898TFGMPbiU44iX/S9wjCWXY+SiV1fJYTyN1Wv+DiR8Mwk0F6MQ3DkxZt4FXZ\r\nQ88roBg81E1y+N/ce0mD4gtw8wJ/6qbpa3g+oQUITa1EnaXNCt5udySrc2Y4zCva\r\n2Ny3uKEV2IWGx2ty1QnjHUHkGnmaI6WBWXuNXo43TQTy63tEeIm8AlRp3tc=\r\n-----END CERTIFICATE-----\r\n</cert>\r\n<key>\r\n-----BEGIN PRIVATE KEY-----\r\nMIIEvwIBADANBgkqhkiG9w0BAQEFAASCBKkwggSlAgEAAoIBAQDb1NJja1kqkmiZ\r\nNehB5+U/G6q658cjVXPkGhTyHSPNNo6LzPkqdhIgZnhxVIcVi138wvRuDjdqg+Cd\r\nHnH6BbMoOxyqG+18ycxXdRMcX6ol7cvSKXuKzIWaGmlZbxFuNpdoUIDDAJdpXv/J\r\nhwY2rfoUFDGjRZXrAWj2LQEDgr5hqxSkJl8cfoHuxen+ZBGy3VZbMzZaM6bIm0ZK\r\nstkwKHm8sL+AW8m2/9QJTClCF2p1Nev/isi5iXN954QNZAA/OlKKEWXnntrDH9Sj\r\n9zfiXSWO1EIkmnqjKCeS1Ela+t9hABJQsY5ngQEStiFoa0sUhbcpVC915gdPF3aa\r\nY88+cc+9AgMBAAECggEBAJFSc3J9uIhIGRWPaWaIIihB5e+A4UgeaWpVQ5t6X/x9\r\nIGaSrfS/8OOyWdSxiEtZwlwhlOxcQY4MeCPlyHr74Z+q1BwwMiLYVFlMb8HGC/je\r\n5mqcOatb4MYqx5HztpYhSJ4Q+c3vSijCQF29AQKMqFE1uEqy6ZRdbkGvJohnmet9\r\nr5H1GzD9KTL2HxSuW76HDcYGtrConz98veZOkhFleES1S4ZYd8EyCb0G5+q+iy6s\r\naxzKkhSEXeLGBFg74Yhzvaht5JO6ZSMCq9URr1qt7qOxivBDXTI6z8DDyxyW4mx5\r\naYBU7ZPDtKg4l9bJAO+dXQgACz+4/jbwgft3L6q5o5ECgYEA73S3AUkZ7C1lkEAu\r\n87zcILIXopKt5Fe9V8p/wlKTZL8OLOZ61LunwM5wWWjbG5m8zLBY2NjNsISSw2Sn\r\nmwejzIC6enFkYRtNtzGwXeSWq8pGmyQUoY++2nBk0yWC6MCc9zoEBTvnZADDZ0Em\r\n03qrftwIFp//Ma7uzCLYjFCiobcCgYEA6wUBMWbOxJnWbFn7odH3lomfM32X9a7K\r\n/bpXTBf9Qk+8njVbAAiX2dj6jnxVBQ8YoVK09Q87/t9O/ZpLBwCsol/3tWWkYeSp\r\nHRfobHv1pSFGlmAXuEiRfoMn8LwiSgqPdWofKm8GjHppSMadjWnJgWxZMhqJ7yEN\r\ngLnoFaesiisCgYBf2y4jQpsw819T5o2lHrZUFFbnyqX34bO3QCXyqVG9o8nN6ZnE\r\nLTbTNRC+if4kR1/P5Mw8SlXU0s1ZkKKTqfRFOkbsGxZe1SpAKpD6lTZHoNqw4jms\r\nDzoMga+q4rpL6EctpLjVS4yueKvAWtFrGREr4HMQc44Z2nhXmZ9sVB82cwKBgQCG\r\nQFSfIMhKnEpVmM1acfPJ5ZGwuzTcHl5MtG57xFRi1eO8SGRUT5RW2FDApht3CVmb\r\nhgBi4LH39R5NVh83v9Xd54476/UMCq/kM60Mk38ONkT5T6kdFy8tosRlC0NXIlMy\r\n0k09UzDdfGu6K+MCTgTSzs7hBTH4DNyGxSvjeuXgAwKBgQClaBLmTs3FaWhfLvOs\r\nzzIeiAEzv4eagUims92ym7D0NwgG24gDvaF1+k/aKF4nevuSG+3UeAZHHO/NP0/7\r\npWYYtEdLKqnRL+CcPlVX8OmEAGon5mZAQNMhVWULZXDxnC8IJZ3kmO11MQbKM6ZK\r\n836xsEByT26VtmIqF7b3fcMPMg==\r\n-----END PRIVATE KEY-----\r\n</key>\r\n<tls-auth>\r\n#\r\n# 2048 bit OpenVPN static key\r\n#\r\n-----BEGIN OpenVPN Static key V1-----\r\nf783bbffb7842aaef57c1804691e6682\r\naeebca61555db03aa398db5993c10254\r\n32976641ef2ed5c5e3e97a49dca29440\r\nf583f95034dd28ca1b0de2975493971a\r\nc9eb447e58f737abc8ab1f575f3cc094\r\nc06c55e0840d811b610014998145460c\r\ncb76588cec6fbf5f53c616a5ab0a7265\r\n8014d1d6f487e1b92e3cd621a318041d\r\n8280558b0c6f203cc29e9d7050be040b\r\n5a33347144fe840a73b895f967108895\r\n69119137bc6d320ef50a1d472a245ea2\r\nfc507f926fbacd932cbfc74c13136ddc\r\n48a644cce0c0ad17670e2020e58ede30\r\n7b8dbfcade3efbad75c2af3977a57de8\r\na031644718d76de9cc7f9a5169deed3f\r\n63484a84cc4a62f513444a997f9f0242\r\n-----END OpenVPN Static key V1-----\r\n</tls-auth>\r\n', 1, 0, 'Frankfurt', 1, 1648013779, 1648130037),
(81, 'Singapore', 'SG', '51.79.161.151', 'client\r\ndev tun\r\nproto udp\r\nremote 51.79.161.151 1194\r\nresolv-retry infinite\r\nnobind\r\nuser nobody\r\ngroup nogroup\r\npersist-key\r\npersist-tun\r\nmute-replay-warnings\r\nremote-cert-tls server\r\ncipher AES-256-CBC\r\nauth SHA256\r\nverb 4\r\nkey-direction 1\r\n\r\n<ca>\r\n-----BEGIN CERTIFICATE-----\r\nMIIDSzCCAjOgAwIBAgIULJ/P+2LAMxTSQIUOKma17+uWen4wDQYJKoZIhvcNAQEL\r\nBQAwFjEUMBIGA1UEAwwLRWFzeS1SU0EgQ0EwHhcNMjAwNzA3MTQ0OTMyWhcNMzAw\r\nNzA1MTQ0OTMyWjAWMRQwEgYDVQQDDAtFYXN5LVJTQSBDQTCCASIwDQYJKoZIhvcN\r\nAQEBBQADggEPADCCAQoCggEBALTDnabqBE7oYcE3mLBC91hhDtugCZQr+WIS/sV8\r\nujHmE9hSxs150b0VubNTA6B59Fcifj9R8hzRgi0EA1X8JKj+qF3+kOnsR4q+7Is/\r\nUcd3rV4UHrUFFEKMP+Ox5roiDrV3ZEHMY3JVZ0EJdNhpD1xpiEeAUoDrpI4EP/+r\r\n5a9e3e+ZpU24C0DKa2dDQpcwX5ZeM8GJXw+nzUo4JBCoultxcF/cCBwShSZr7u7z\r\nskvQSSkE4c2G1mbwKYF3xi61i9rIcGKjPufuHMS+hVZYwduyx9xSvXIu9MDReyQX\r\n9nEwh55MpKvE1gwYvevJNzsUnvG48vutrW/POxIr1DW3SmMCAwEAAaOBkDCBjTAd\r\nBgNVHQ4EFgQUehvU3gUNR3VDRrDVZDU+RbcGTtQwUQYDVR0jBEowSIAUehvU3gUN\r\nR3VDRrDVZDU+RbcGTtShGqQYMBYxFDASBgNVBAMMC0Vhc3ktUlNBIENBghQsn8/7\r\nYsAzFNJAhQ4qZrXv65Z6fjAMBgNVHRMEBTADAQH/MAsGA1UdDwQEAwIBBjANBgkq\r\nhkiG9w0BAQsFAAOCAQEAQcs0HubtqZIazSBK9mMqYnCmJ/P16iTXbro+te/T2Mfu\r\nqM1rFaumsibvvu9FhE7kdIG9F4mjB5K3JXtWc6CZqBcLooM6kzOxTeu0Rx4wNVdd\r\nBRjASWqZHhG3vNCI5gXUu2cI1EE6PjLyxuSYbNFZ6JIn0XxjQfvr7JrLBpMGjRgo\r\nrGjUT+jQ4KnegGBWNYtnDv7or660/gmhcvyhK4iTMqPGbEDEI4Qx1ZUwQjFjC18F\r\nlYl0FMXoVz/LB3U1weG8W5pe4E5xE2K+H8Ez943Szme8Bf6DEcZ9K2j+e258rBpc\r\nfYqDAkdRwpevMvXc/YD/7wMqw4pMgxu4dPJV7AOcsQ==\r\n-----END CERTIFICATE-----\r\n</ca>\r\n<cert>\r\nCertificate:\r\n    Data:\r\n        Version: 3 (0x2)\r\n        Serial Number:\r\n            62:73:e0:a9:06:aa:f6:f3:83:13:16:37:64:3c:d4:7e\r\n        Signature Algorithm: sha256WithRSAEncryption\r\n        Issuer: CN=Easy-RSA CA\r\n        Validity\r\n            Not Before: Jul  8 08:16:59 2020 GMT\r\n            Not After : Jul  6 08:16:59 2030 GMT\r\n        Subject: CN=client-de0\r\n        Subject Public Key Info:\r\n            Public Key Algorithm: rsaEncryption\r\n                RSA Public-Key: (2048 bit)\r\n                Modulus:\r\n                    00:db:d4:d2:63:6b:59:2a:92:68:99:35:e8:41:e7:\r\n                    e5:3f:1b:aa:ba:e7:c7:23:55:73:e4:1a:14:f2:1d:\r\n                    23:cd:36:8e:8b:cc:f9:2a:76:12:20:66:78:71:54:\r\n                    87:15:8b:5d:fc:c2:f4:6e:0e:37:6a:83:e0:9d:1e:\r\n                    71:fa:05:b3:28:3b:1c:aa:1b:ed:7c:c9:cc:57:75:\r\n                    13:1c:5f:aa:25:ed:cb:d2:29:7b:8a:cc:85:9a:1a:\r\n                    69:59:6f:11:6e:36:97:68:50:80:c3:00:97:69:5e:\r\n                    ff:c9:87:06:36:ad:fa:14:14:31:a3:45:95:eb:01:\r\n                    68:f6:2d:01:03:82:be:61:ab:14:a4:26:5f:1c:7e:\r\n                    81:ee:c5:e9:fe:64:11:b2:dd:56:5b:33:36:5a:33:\r\n                    a6:c8:9b:46:4a:b2:d9:30:28:79:bc:b0:bf:80:5b:\r\n                    c9:b6:ff:d4:09:4c:29:42:17:6a:75:35:eb:ff:8a:\r\n                    c8:b9:89:73:7d:e7:84:0d:64:00:3f:3a:52:8a:11:\r\n                    65:e7:9e:da:c3:1f:d4:a3:f7:37:e2:5d:25:8e:d4:\r\n                    42:24:9a:7a:a3:28:27:92:d4:49:5a:fa:df:61:00:\r\n                    12:50:b1:8e:67:81:01:12:b6:21:68:6b:4b:14:85:\r\n                    b7:29:54:2f:75:e6:07:4f:17:76:9a:63:cf:3e:71:\r\n                    cf:bd\r\n                Exponent: 65537 (0x10001)\r\n        X509v3 extensions:\r\n            X509v3 Basic Constraints: \r\n                CA:FALSE\r\n            X509v3 Subject Key Identifier: \r\n                69:9A:79:AD:CF:44:C8:04:B3:48:7F:67:1E:2E:A7:C8:C4:CA:D1:8F\r\n            X509v3 Authority Key Identifier: \r\n                keyid:7A:1B:D4:DE:05:0D:47:75:43:46:B0:D5:64:35:3E:45:B7:06:4E:D4\r\n                DirName:/CN=Easy-RSA CA\r\n                serial:2C:9F:CF:FB:62:C0:33:14:D2:40:85:0E:2A:66:B5:EF:EB:96:7A:7E\r\n\r\n            X509v3 Extended Key Usage: \r\n                TLS Web Client Authentication\r\n            X509v3 Key Usage: \r\n                Digital Signature\r\n    Signature Algorithm: sha256WithRSAEncryption\r\n         82:69:48:07:65:89:15:f3:89:49:8a:d3:19:fb:84:f6:6a:f7:\r\n         89:67:8d:bf:ae:6f:4a:83:0d:5d:82:df:79:be:86:68:e8:9a:\r\n         55:0c:0c:dd:c8:e5:fb:f9:4f:e1:61:3a:a3:05:97:0f:2a:f2:\r\n         a3:a5:7d:5b:c8:27:8a:9c:79:b8:dd:c7:56:05:6d:06:20:b4:\r\n         ca:f3:5c:c8:5c:df:e0:18:1b:34:6a:bf:a0:d8:50:e6:ad:d3:\r\n         4f:a0:17:3f:ef:cd:8a:a9:9b:97:a3:2c:75:0f:e5:c3:b4:b6:\r\n         b6:1e:72:f5:f6:2d:5f:0d:cf:1a:bc:f7:c4:c5:18:c3:db:89:\r\n         4e:38:89:7f:d2:f7:08:c2:59:76:3e:4a:25:75:7c:96:13:c8:\r\n         dd:56:bf:e0:e2:47:c3:30:93:41:7a:31:0d:c3:93:16:6d:e0:\r\n         55:d9:43:cf:2b:a0:18:3c:d4:4d:72:f8:df:dc:7b:49:83:e2:\r\n         0b:70:f3:02:7f:ea:a6:e9:6b:78:3e:a1:05:08:4d:ad:44:9d:\r\n         a5:cd:0a:de:6e:77:24:ab:73:66:38:cc:2b:da:d8:dc:b7:b8:\r\n         a1:15:d8:85:86:c7:6b:72:d5:09:e3:1d:41:e4:1a:79:9a:23:\r\n         a5:81:59:7b:8d:5e:8e:37:4d:04:f2:eb:7b:44:78:89:bc:02:\r\n         54:69:de:d7\r\n-----BEGIN CERTIFICATE-----\r\nMIIDWDCCAkCgAwIBAgIQYnPgqQaq9vODExY3ZDzUfjANBgkqhkiG9w0BAQsFADAW\r\nMRQwEgYDVQQDDAtFYXN5LVJTQSBDQTAeFw0yMDA3MDgwODE2NTlaFw0zMDA3MDYw\r\nODE2NTlaMBUxEzARBgNVBAMMCmNsaWVudC1kZTAwggEiMA0GCSqGSIb3DQEBAQUA\r\nA4IBDwAwggEKAoIBAQDb1NJja1kqkmiZNehB5+U/G6q658cjVXPkGhTyHSPNNo6L\r\nzPkqdhIgZnhxVIcVi138wvRuDjdqg+CdHnH6BbMoOxyqG+18ycxXdRMcX6ol7cvS\r\nKXuKzIWaGmlZbxFuNpdoUIDDAJdpXv/JhwY2rfoUFDGjRZXrAWj2LQEDgr5hqxSk\r\nJl8cfoHuxen+ZBGy3VZbMzZaM6bIm0ZKstkwKHm8sL+AW8m2/9QJTClCF2p1Nev/\r\nisi5iXN954QNZAA/OlKKEWXnntrDH9Sj9zfiXSWO1EIkmnqjKCeS1Ela+t9hABJQ\r\nsY5ngQEStiFoa0sUhbcpVC915gdPF3aaY88+cc+9AgMBAAGjgaIwgZ8wCQYDVR0T\r\nBAIwADAdBgNVHQ4EFgQUaZp5rc9EyASzSH9nHi6nyMTK0Y8wUQYDVR0jBEowSIAU\r\nehvU3gUNR3VDRrDVZDU+RbcGTtShGqQYMBYxFDASBgNVBAMMC0Vhc3ktUlNBIENB\r\nghQsn8/7YsAzFNJAhQ4qZrXv65Z6fjATBgNVHSUEDDAKBggrBgEFBQcDAjALBgNV\r\nHQ8EBAMCB4AwDQYJKoZIhvcNAQELBQADggEBAIJpSAdliRXziUmK0xn7hPZq94ln\r\njb+ub0qDDV2C33m+hmjomlUMDN3I5fv5T+FhOqMFlw8q8qOlfVvIJ4qcebjdx1YF\r\nbQYgtMrzXMhc3+AYGzRqv6DYUOat00+gFz/vzYqpm5ejLHUP5cO0trYecvX2LV8N\r\nzxq898TFGMPbiU44iX/S9wjCWXY+SiV1fJYTyN1Wv+DiR8Mwk0F6MQ3DkxZt4FXZ\r\nQ88roBg81E1y+N/ce0mD4gtw8wJ/6qbpa3g+oQUITa1EnaXNCt5udySrc2Y4zCva\r\n2Ny3uKEV2IWGx2ty1QnjHUHkGnmaI6WBWXuNXo43TQTy63tEeIm8AlRp3tc=\r\n-----END CERTIFICATE-----\r\n</cert>\r\n<key>\r\n-----BEGIN PRIVATE KEY-----\r\nMIIEvwIBADANBgkqhkiG9w0BAQEFAASCBKkwggSlAgEAAoIBAQDb1NJja1kqkmiZ\r\nNehB5+U/G6q658cjVXPkGhTyHSPNNo6LzPkqdhIgZnhxVIcVi138wvRuDjdqg+Cd\r\nHnH6BbMoOxyqG+18ycxXdRMcX6ol7cvSKXuKzIWaGmlZbxFuNpdoUIDDAJdpXv/J\r\nhwY2rfoUFDGjRZXrAWj2LQEDgr5hqxSkJl8cfoHuxen+ZBGy3VZbMzZaM6bIm0ZK\r\nstkwKHm8sL+AW8m2/9QJTClCF2p1Nev/isi5iXN954QNZAA/OlKKEWXnntrDH9Sj\r\n9zfiXSWO1EIkmnqjKCeS1Ela+t9hABJQsY5ngQEStiFoa0sUhbcpVC915gdPF3aa\r\nY88+cc+9AgMBAAECggEBAJFSc3J9uIhIGRWPaWaIIihB5e+A4UgeaWpVQ5t6X/x9\r\nIGaSrfS/8OOyWdSxiEtZwlwhlOxcQY4MeCPlyHr74Z+q1BwwMiLYVFlMb8HGC/je\r\n5mqcOatb4MYqx5HztpYhSJ4Q+c3vSijCQF29AQKMqFE1uEqy6ZRdbkGvJohnmet9\r\nr5H1GzD9KTL2HxSuW76HDcYGtrConz98veZOkhFleES1S4ZYd8EyCb0G5+q+iy6s\r\naxzKkhSEXeLGBFg74Yhzvaht5JO6ZSMCq9URr1qt7qOxivBDXTI6z8DDyxyW4mx5\r\naYBU7ZPDtKg4l9bJAO+dXQgACz+4/jbwgft3L6q5o5ECgYEA73S3AUkZ7C1lkEAu\r\n87zcILIXopKt5Fe9V8p/wlKTZL8OLOZ61LunwM5wWWjbG5m8zLBY2NjNsISSw2Sn\r\nmwejzIC6enFkYRtNtzGwXeSWq8pGmyQUoY++2nBk0yWC6MCc9zoEBTvnZADDZ0Em\r\n03qrftwIFp//Ma7uzCLYjFCiobcCgYEA6wUBMWbOxJnWbFn7odH3lomfM32X9a7K\r\n/bpXTBf9Qk+8njVbAAiX2dj6jnxVBQ8YoVK09Q87/t9O/ZpLBwCsol/3tWWkYeSp\r\nHRfobHv1pSFGlmAXuEiRfoMn8LwiSgqPdWofKm8GjHppSMadjWnJgWxZMhqJ7yEN\r\ngLnoFaesiisCgYBf2y4jQpsw819T5o2lHrZUFFbnyqX34bO3QCXyqVG9o8nN6ZnE\r\nLTbTNRC+if4kR1/P5Mw8SlXU0s1ZkKKTqfRFOkbsGxZe1SpAKpD6lTZHoNqw4jms\r\nDzoMga+q4rpL6EctpLjVS4yueKvAWtFrGREr4HMQc44Z2nhXmZ9sVB82cwKBgQCG\r\nQFSfIMhKnEpVmM1acfPJ5ZGwuzTcHl5MtG57xFRi1eO8SGRUT5RW2FDApht3CVmb\r\nhgBi4LH39R5NVh83v9Xd54476/UMCq/kM60Mk38ONkT5T6kdFy8tosRlC0NXIlMy\r\n0k09UzDdfGu6K+MCTgTSzs7hBTH4DNyGxSvjeuXgAwKBgQClaBLmTs3FaWhfLvOs\r\nzzIeiAEzv4eagUims92ym7D0NwgG24gDvaF1+k/aKF4nevuSG+3UeAZHHO/NP0/7\r\npWYYtEdLKqnRL+CcPlVX8OmEAGon5mZAQNMhVWULZXDxnC8IJZ3kmO11MQbKM6ZK\r\n836xsEByT26VtmIqF7b3fcMPMg==\r\n-----END PRIVATE KEY-----\r\n</key>\r\n<tls-auth>\r\n#\r\n# 2048 bit OpenVPN static key\r\n#\r\n-----BEGIN OpenVPN Static key V1-----\r\nf783bbffb7842aaef57c1804691e6682\r\naeebca61555db03aa398db5993c10254\r\n32976641ef2ed5c5e3e97a49dca29440\r\nf583f95034dd28ca1b0de2975493971a\r\nc9eb447e58f737abc8ab1f575f3cc094\r\nc06c55e0840d811b610014998145460c\r\ncb76588cec6fbf5f53c616a5ab0a7265\r\n8014d1d6f487e1b92e3cd621a318041d\r\n8280558b0c6f203cc29e9d7050be040b\r\n5a33347144fe840a73b895f967108895\r\n69119137bc6d320ef50a1d472a245ea2\r\nfc507f926fbacd932cbfc74c13136ddc\r\n48a644cce0c0ad17670e2020e58ede30\r\n7b8dbfcade3efbad75c2af3977a57de8\r\na031644718d76de9cc7f9a5169deed3f\r\n63484a84cc4a62f513444a997f9f0242\r\n-----END OpenVPN Static key V1-----\r\n</tls-auth>\r\n', 1, 0, 'Fast Gaming', 1, 1648013779, 1648129467),
(82, 'Australia', 'AU', '139.99.170.23', 'client\r\ndev tun\r\nproto udp\r\nremote 139.99.170.23 1194\r\nresolv-retry infinite\r\nnobind\r\nuser nobody\r\ngroup nogroup\r\npersist-key\r\npersist-tun\r\nmute-replay-warnings\r\nremote-cert-tls server\r\ncipher AES-256-CBC\r\nauth SHA256\r\nverb 4\r\nkey-direction 1\r\n\r\n<ca>\r\n-----BEGIN CERTIFICATE-----\r\nMIIDSzCCAjOgAwIBAgIULJ/P+2LAMxTSQIUOKma17+uWen4wDQYJKoZIhvcNAQEL\r\nBQAwFjEUMBIGA1UEAwwLRWFzeS1SU0EgQ0EwHhcNMjAwNzA3MTQ0OTMyWhcNMzAw\r\nNzA1MTQ0OTMyWjAWMRQwEgYDVQQDDAtFYXN5LVJTQSBDQTCCASIwDQYJKoZIhvcN\r\nAQEBBQADggEPADCCAQoCggEBALTDnabqBE7oYcE3mLBC91hhDtugCZQr+WIS/sV8\r\nujHmE9hSxs150b0VubNTA6B59Fcifj9R8hzRgi0EA1X8JKj+qF3+kOnsR4q+7Is/\r\nUcd3rV4UHrUFFEKMP+Ox5roiDrV3ZEHMY3JVZ0EJdNhpD1xpiEeAUoDrpI4EP/+r\r\n5a9e3e+ZpU24C0DKa2dDQpcwX5ZeM8GJXw+nzUo4JBCoultxcF/cCBwShSZr7u7z\r\nskvQSSkE4c2G1mbwKYF3xi61i9rIcGKjPufuHMS+hVZYwduyx9xSvXIu9MDReyQX\r\n9nEwh55MpKvE1gwYvevJNzsUnvG48vutrW/POxIr1DW3SmMCAwEAAaOBkDCBjTAd\r\nBgNVHQ4EFgQUehvU3gUNR3VDRrDVZDU+RbcGTtQwUQYDVR0jBEowSIAUehvU3gUN\r\nR3VDRrDVZDU+RbcGTtShGqQYMBYxFDASBgNVBAMMC0Vhc3ktUlNBIENBghQsn8/7\r\nYsAzFNJAhQ4qZrXv65Z6fjAMBgNVHRMEBTADAQH/MAsGA1UdDwQEAwIBBjANBgkq\r\nhkiG9w0BAQsFAAOCAQEAQcs0HubtqZIazSBK9mMqYnCmJ/P16iTXbro+te/T2Mfu\r\nqM1rFaumsibvvu9FhE7kdIG9F4mjB5K3JXtWc6CZqBcLooM6kzOxTeu0Rx4wNVdd\r\nBRjASWqZHhG3vNCI5gXUu2cI1EE6PjLyxuSYbNFZ6JIn0XxjQfvr7JrLBpMGjRgo\r\nrGjUT+jQ4KnegGBWNYtnDv7or660/gmhcvyhK4iTMqPGbEDEI4Qx1ZUwQjFjC18F\r\nlYl0FMXoVz/LB3U1weG8W5pe4E5xE2K+H8Ez943Szme8Bf6DEcZ9K2j+e258rBpc\r\nfYqDAkdRwpevMvXc/YD/7wMqw4pMgxu4dPJV7AOcsQ==\r\n-----END CERTIFICATE-----\r\n</ca>\r\n<cert>\r\nCertificate:\r\n    Data:\r\n        Version: 3 (0x2)\r\n        Serial Number:\r\n            62:73:e0:a9:06:aa:f6:f3:83:13:16:37:64:3c:d4:7e\r\n        Signature Algorithm: sha256WithRSAEncryption\r\n        Issuer: CN=Easy-RSA CA\r\n        Validity\r\n            Not Before: Jul  8 08:16:59 2020 GMT\r\n            Not After : Jul  6 08:16:59 2030 GMT\r\n        Subject: CN=client-de0\r\n        Subject Public Key Info:\r\n            Public Key Algorithm: rsaEncryption\r\n                RSA Public-Key: (2048 bit)\r\n                Modulus:\r\n                    00:db:d4:d2:63:6b:59:2a:92:68:99:35:e8:41:e7:\r\n                    e5:3f:1b:aa:ba:e7:c7:23:55:73:e4:1a:14:f2:1d:\r\n                    23:cd:36:8e:8b:cc:f9:2a:76:12:20:66:78:71:54:\r\n                    87:15:8b:5d:fc:c2:f4:6e:0e:37:6a:83:e0:9d:1e:\r\n                    71:fa:05:b3:28:3b:1c:aa:1b:ed:7c:c9:cc:57:75:\r\n                    13:1c:5f:aa:25:ed:cb:d2:29:7b:8a:cc:85:9a:1a:\r\n                    69:59:6f:11:6e:36:97:68:50:80:c3:00:97:69:5e:\r\n                    ff:c9:87:06:36:ad:fa:14:14:31:a3:45:95:eb:01:\r\n                    68:f6:2d:01:03:82:be:61:ab:14:a4:26:5f:1c:7e:\r\n                    81:ee:c5:e9:fe:64:11:b2:dd:56:5b:33:36:5a:33:\r\n                    a6:c8:9b:46:4a:b2:d9:30:28:79:bc:b0:bf:80:5b:\r\n                    c9:b6:ff:d4:09:4c:29:42:17:6a:75:35:eb:ff:8a:\r\n                    c8:b9:89:73:7d:e7:84:0d:64:00:3f:3a:52:8a:11:\r\n                    65:e7:9e:da:c3:1f:d4:a3:f7:37:e2:5d:25:8e:d4:\r\n                    42:24:9a:7a:a3:28:27:92:d4:49:5a:fa:df:61:00:\r\n                    12:50:b1:8e:67:81:01:12:b6:21:68:6b:4b:14:85:\r\n                    b7:29:54:2f:75:e6:07:4f:17:76:9a:63:cf:3e:71:\r\n                    cf:bd\r\n                Exponent: 65537 (0x10001)\r\n        X509v3 extensions:\r\n            X509v3 Basic Constraints: \r\n                CA:FALSE\r\n            X509v3 Subject Key Identifier: \r\n                69:9A:79:AD:CF:44:C8:04:B3:48:7F:67:1E:2E:A7:C8:C4:CA:D1:8F\r\n            X509v3 Authority Key Identifier: \r\n                keyid:7A:1B:D4:DE:05:0D:47:75:43:46:B0:D5:64:35:3E:45:B7:06:4E:D4\r\n                DirName:/CN=Easy-RSA CA\r\n                serial:2C:9F:CF:FB:62:C0:33:14:D2:40:85:0E:2A:66:B5:EF:EB:96:7A:7E\r\n\r\n            X509v3 Extended Key Usage: \r\n                TLS Web Client Authentication\r\n            X509v3 Key Usage: \r\n                Digital Signature\r\n    Signature Algorithm: sha256WithRSAEncryption\r\n         82:69:48:07:65:89:15:f3:89:49:8a:d3:19:fb:84:f6:6a:f7:\r\n         89:67:8d:bf:ae:6f:4a:83:0d:5d:82:df:79:be:86:68:e8:9a:\r\n         55:0c:0c:dd:c8:e5:fb:f9:4f:e1:61:3a:a3:05:97:0f:2a:f2:\r\n         a3:a5:7d:5b:c8:27:8a:9c:79:b8:dd:c7:56:05:6d:06:20:b4:\r\n         ca:f3:5c:c8:5c:df:e0:18:1b:34:6a:bf:a0:d8:50:e6:ad:d3:\r\n         4f:a0:17:3f:ef:cd:8a:a9:9b:97:a3:2c:75:0f:e5:c3:b4:b6:\r\n         b6:1e:72:f5:f6:2d:5f:0d:cf:1a:bc:f7:c4:c5:18:c3:db:89:\r\n         4e:38:89:7f:d2:f7:08:c2:59:76:3e:4a:25:75:7c:96:13:c8:\r\n         dd:56:bf:e0:e2:47:c3:30:93:41:7a:31:0d:c3:93:16:6d:e0:\r\n         55:d9:43:cf:2b:a0:18:3c:d4:4d:72:f8:df:dc:7b:49:83:e2:\r\n         0b:70:f3:02:7f:ea:a6:e9:6b:78:3e:a1:05:08:4d:ad:44:9d:\r\n         a5:cd:0a:de:6e:77:24:ab:73:66:38:cc:2b:da:d8:dc:b7:b8:\r\n         a1:15:d8:85:86:c7:6b:72:d5:09:e3:1d:41:e4:1a:79:9a:23:\r\n         a5:81:59:7b:8d:5e:8e:37:4d:04:f2:eb:7b:44:78:89:bc:02:\r\n         54:69:de:d7\r\n-----BEGIN CERTIFICATE-----\r\nMIIDWDCCAkCgAwIBAgIQYnPgqQaq9vODExY3ZDzUfjANBgkqhkiG9w0BAQsFADAW\r\nMRQwEgYDVQQDDAtFYXN5LVJTQSBDQTAeFw0yMDA3MDgwODE2NTlaFw0zMDA3MDYw\r\nODE2NTlaMBUxEzARBgNVBAMMCmNsaWVudC1kZTAwggEiMA0GCSqGSIb3DQEBAQUA\r\nA4IBDwAwggEKAoIBAQDb1NJja1kqkmiZNehB5+U/G6q658cjVXPkGhTyHSPNNo6L\r\nzPkqdhIgZnhxVIcVi138wvRuDjdqg+CdHnH6BbMoOxyqG+18ycxXdRMcX6ol7cvS\r\nKXuKzIWaGmlZbxFuNpdoUIDDAJdpXv/JhwY2rfoUFDGjRZXrAWj2LQEDgr5hqxSk\r\nJl8cfoHuxen+ZBGy3VZbMzZaM6bIm0ZKstkwKHm8sL+AW8m2/9QJTClCF2p1Nev/\r\nisi5iXN954QNZAA/OlKKEWXnntrDH9Sj9zfiXSWO1EIkmnqjKCeS1Ela+t9hABJQ\r\nsY5ngQEStiFoa0sUhbcpVC915gdPF3aaY88+cc+9AgMBAAGjgaIwgZ8wCQYDVR0T\r\nBAIwADAdBgNVHQ4EFgQUaZp5rc9EyASzSH9nHi6nyMTK0Y8wUQYDVR0jBEowSIAU\r\nehvU3gUNR3VDRrDVZDU+RbcGTtShGqQYMBYxFDASBgNVBAMMC0Vhc3ktUlNBIENB\r\nghQsn8/7YsAzFNJAhQ4qZrXv65Z6fjATBgNVHSUEDDAKBggrBgEFBQcDAjALBgNV\r\nHQ8EBAMCB4AwDQYJKoZIhvcNAQELBQADggEBAIJpSAdliRXziUmK0xn7hPZq94ln\r\njb+ub0qDDV2C33m+hmjomlUMDN3I5fv5T+FhOqMFlw8q8qOlfVvIJ4qcebjdx1YF\r\nbQYgtMrzXMhc3+AYGzRqv6DYUOat00+gFz/vzYqpm5ejLHUP5cO0trYecvX2LV8N\r\nzxq898TFGMPbiU44iX/S9wjCWXY+SiV1fJYTyN1Wv+DiR8Mwk0F6MQ3DkxZt4FXZ\r\nQ88roBg81E1y+N/ce0mD4gtw8wJ/6qbpa3g+oQUITa1EnaXNCt5udySrc2Y4zCva\r\n2Ny3uKEV2IWGx2ty1QnjHUHkGnmaI6WBWXuNXo43TQTy63tEeIm8AlRp3tc=\r\n-----END CERTIFICATE-----\r\n</cert>\r\n<key>\r\n-----BEGIN PRIVATE KEY-----\r\nMIIEvwIBADANBgkqhkiG9w0BAQEFAASCBKkwggSlAgEAAoIBAQDb1NJja1kqkmiZ\r\nNehB5+U/G6q658cjVXPkGhTyHSPNNo6LzPkqdhIgZnhxVIcVi138wvRuDjdqg+Cd\r\nHnH6BbMoOxyqG+18ycxXdRMcX6ol7cvSKXuKzIWaGmlZbxFuNpdoUIDDAJdpXv/J\r\nhwY2rfoUFDGjRZXrAWj2LQEDgr5hqxSkJl8cfoHuxen+ZBGy3VZbMzZaM6bIm0ZK\r\nstkwKHm8sL+AW8m2/9QJTClCF2p1Nev/isi5iXN954QNZAA/OlKKEWXnntrDH9Sj\r\n9zfiXSWO1EIkmnqjKCeS1Ela+t9hABJQsY5ngQEStiFoa0sUhbcpVC915gdPF3aa\r\nY88+cc+9AgMBAAECggEBAJFSc3J9uIhIGRWPaWaIIihB5e+A4UgeaWpVQ5t6X/x9\r\nIGaSrfS/8OOyWdSxiEtZwlwhlOxcQY4MeCPlyHr74Z+q1BwwMiLYVFlMb8HGC/je\r\n5mqcOatb4MYqx5HztpYhSJ4Q+c3vSijCQF29AQKMqFE1uEqy6ZRdbkGvJohnmet9\r\nr5H1GzD9KTL2HxSuW76HDcYGtrConz98veZOkhFleES1S4ZYd8EyCb0G5+q+iy6s\r\naxzKkhSEXeLGBFg74Yhzvaht5JO6ZSMCq9URr1qt7qOxivBDXTI6z8DDyxyW4mx5\r\naYBU7ZPDtKg4l9bJAO+dXQgACz+4/jbwgft3L6q5o5ECgYEA73S3AUkZ7C1lkEAu\r\n87zcILIXopKt5Fe9V8p/wlKTZL8OLOZ61LunwM5wWWjbG5m8zLBY2NjNsISSw2Sn\r\nmwejzIC6enFkYRtNtzGwXeSWq8pGmyQUoY++2nBk0yWC6MCc9zoEBTvnZADDZ0Em\r\n03qrftwIFp//Ma7uzCLYjFCiobcCgYEA6wUBMWbOxJnWbFn7odH3lomfM32X9a7K\r\n/bpXTBf9Qk+8njVbAAiX2dj6jnxVBQ8YoVK09Q87/t9O/ZpLBwCsol/3tWWkYeSp\r\nHRfobHv1pSFGlmAXuEiRfoMn8LwiSgqPdWofKm8GjHppSMadjWnJgWxZMhqJ7yEN\r\ngLnoFaesiisCgYBf2y4jQpsw819T5o2lHrZUFFbnyqX34bO3QCXyqVG9o8nN6ZnE\r\nLTbTNRC+if4kR1/P5Mw8SlXU0s1ZkKKTqfRFOkbsGxZe1SpAKpD6lTZHoNqw4jms\r\nDzoMga+q4rpL6EctpLjVS4yueKvAWtFrGREr4HMQc44Z2nhXmZ9sVB82cwKBgQCG\r\nQFSfIMhKnEpVmM1acfPJ5ZGwuzTcHl5MtG57xFRi1eO8SGRUT5RW2FDApht3CVmb\r\nhgBi4LH39R5NVh83v9Xd54476/UMCq/kM60Mk38ONkT5T6kdFy8tosRlC0NXIlMy\r\n0k09UzDdfGu6K+MCTgTSzs7hBTH4DNyGxSvjeuXgAwKBgQClaBLmTs3FaWhfLvOs\r\nzzIeiAEzv4eagUims92ym7D0NwgG24gDvaF1+k/aKF4nevuSG+3UeAZHHO/NP0/7\r\npWYYtEdLKqnRL+CcPlVX8OmEAGon5mZAQNMhVWULZXDxnC8IJZ3kmO11MQbKM6ZK\r\n836xsEByT26VtmIqF7b3fcMPMg==\r\n-----END PRIVATE KEY-----\r\n</key>\r\n<tls-auth>\r\n#\r\n# 2048 bit OpenVPN static key\r\n#\r\n-----BEGIN OpenVPN Static key V1-----\r\nf783bbffb7842aaef57c1804691e6682\r\naeebca61555db03aa398db5993c10254\r\n32976641ef2ed5c5e3e97a49dca29440\r\nf583f95034dd28ca1b0de2975493971a\r\nc9eb447e58f737abc8ab1f575f3cc094\r\nc06c55e0840d811b610014998145460c\r\ncb76588cec6fbf5f53c616a5ab0a7265\r\n8014d1d6f487e1b92e3cd621a318041d\r\n8280558b0c6f203cc29e9d7050be040b\r\n5a33347144fe840a73b895f967108895\r\n69119137bc6d320ef50a1d472a245ea2\r\nfc507f926fbacd932cbfc74c13136ddc\r\n48a644cce0c0ad17670e2020e58ede30\r\n7b8dbfcade3efbad75c2af3977a57de8\r\na031644718d76de9cc7f9a5169deed3f\r\n63484a84cc4a62f513444a997f9f0242\r\n-----END OpenVPN Static key V1-----\r\n</tls-auth>\r\n', 1, 0, 'Sydney', 1, 1648013779, 1648129828),
(84, 'United Kingdom', 'GB', '51.75.170.106', 'client\r\ndev tun\r\nproto udp\r\nremote 51.75.170.106 1194\r\nresolv-retry infinite\r\nnobind\r\nuser nobody\r\ngroup nogroup\r\npersist-key\r\npersist-tun\r\nmute-replay-warnings\r\nremote-cert-tls server\r\ncipher AES-256-CBC\r\nauth SHA256\r\nverb 4\r\nkey-direction 1\r\n\r\n<ca>\r\n-----BEGIN CERTIFICATE-----\r\nMIIDSzCCAjOgAwIBAgIULJ/P+2LAMxTSQIUOKma17+uWen4wDQYJKoZIhvcNAQEL\r\nBQAwFjEUMBIGA1UEAwwLRWFzeS1SU0EgQ0EwHhcNMjAwNzA3MTQ0OTMyWhcNMzAw\r\nNzA1MTQ0OTMyWjAWMRQwEgYDVQQDDAtFYXN5LVJTQSBDQTCCASIwDQYJKoZIhvcN\r\nAQEBBQADggEPADCCAQoCggEBALTDnabqBE7oYcE3mLBC91hhDtugCZQr+WIS/sV8\r\nujHmE9hSxs150b0VubNTA6B59Fcifj9R8hzRgi0EA1X8JKj+qF3+kOnsR4q+7Is/\r\nUcd3rV4UHrUFFEKMP+Ox5roiDrV3ZEHMY3JVZ0EJdNhpD1xpiEeAUoDrpI4EP/+r\r\n5a9e3e+ZpU24C0DKa2dDQpcwX5ZeM8GJXw+nzUo4JBCoultxcF/cCBwShSZr7u7z\r\nskvQSSkE4c2G1mbwKYF3xi61i9rIcGKjPufuHMS+hVZYwduyx9xSvXIu9MDReyQX\r\n9nEwh55MpKvE1gwYvevJNzsUnvG48vutrW/POxIr1DW3SmMCAwEAAaOBkDCBjTAd\r\nBgNVHQ4EFgQUehvU3gUNR3VDRrDVZDU+RbcGTtQwUQYDVR0jBEowSIAUehvU3gUN\r\nR3VDRrDVZDU+RbcGTtShGqQYMBYxFDASBgNVBAMMC0Vhc3ktUlNBIENBghQsn8/7\r\nYsAzFNJAhQ4qZrXv65Z6fjAMBgNVHRMEBTADAQH/MAsGA1UdDwQEAwIBBjANBgkq\r\nhkiG9w0BAQsFAAOCAQEAQcs0HubtqZIazSBK9mMqYnCmJ/P16iTXbro+te/T2Mfu\r\nqM1rFaumsibvvu9FhE7kdIG9F4mjB5K3JXtWc6CZqBcLooM6kzOxTeu0Rx4wNVdd\r\nBRjASWqZHhG3vNCI5gXUu2cI1EE6PjLyxuSYbNFZ6JIn0XxjQfvr7JrLBpMGjRgo\r\nrGjUT+jQ4KnegGBWNYtnDv7or660/gmhcvyhK4iTMqPGbEDEI4Qx1ZUwQjFjC18F\r\nlYl0FMXoVz/LB3U1weG8W5pe4E5xE2K+H8Ez943Szme8Bf6DEcZ9K2j+e258rBpc\r\nfYqDAkdRwpevMvXc/YD/7wMqw4pMgxu4dPJV7AOcsQ==\r\n-----END CERTIFICATE-----\r\n</ca>\r\n<cert>\r\nCertificate:\r\n    Data:\r\n        Version: 3 (0x2)\r\n        Serial Number:\r\n            62:73:e0:a9:06:aa:f6:f3:83:13:16:37:64:3c:d4:7e\r\n        Signature Algorithm: sha256WithRSAEncryption\r\n        Issuer: CN=Easy-RSA CA\r\n        Validity\r\n            Not Before: Jul  8 08:16:59 2020 GMT\r\n            Not After : Jul  6 08:16:59 2030 GMT\r\n        Subject: CN=client-de0\r\n        Subject Public Key Info:\r\n            Public Key Algorithm: rsaEncryption\r\n                RSA Public-Key: (2048 bit)\r\n                Modulus:\r\n                    00:db:d4:d2:63:6b:59:2a:92:68:99:35:e8:41:e7:\r\n                    e5:3f:1b:aa:ba:e7:c7:23:55:73:e4:1a:14:f2:1d:\r\n                    23:cd:36:8e:8b:cc:f9:2a:76:12:20:66:78:71:54:\r\n                    87:15:8b:5d:fc:c2:f4:6e:0e:37:6a:83:e0:9d:1e:\r\n                    71:fa:05:b3:28:3b:1c:aa:1b:ed:7c:c9:cc:57:75:\r\n                    13:1c:5f:aa:25:ed:cb:d2:29:7b:8a:cc:85:9a:1a:\r\n                    69:59:6f:11:6e:36:97:68:50:80:c3:00:97:69:5e:\r\n                    ff:c9:87:06:36:ad:fa:14:14:31:a3:45:95:eb:01:\r\n                    68:f6:2d:01:03:82:be:61:ab:14:a4:26:5f:1c:7e:\r\n                    81:ee:c5:e9:fe:64:11:b2:dd:56:5b:33:36:5a:33:\r\n                    a6:c8:9b:46:4a:b2:d9:30:28:79:bc:b0:bf:80:5b:\r\n                    c9:b6:ff:d4:09:4c:29:42:17:6a:75:35:eb:ff:8a:\r\n                    c8:b9:89:73:7d:e7:84:0d:64:00:3f:3a:52:8a:11:\r\n                    65:e7:9e:da:c3:1f:d4:a3:f7:37:e2:5d:25:8e:d4:\r\n                    42:24:9a:7a:a3:28:27:92:d4:49:5a:fa:df:61:00:\r\n                    12:50:b1:8e:67:81:01:12:b6:21:68:6b:4b:14:85:\r\n                    b7:29:54:2f:75:e6:07:4f:17:76:9a:63:cf:3e:71:\r\n                    cf:bd\r\n                Exponent: 65537 (0x10001)\r\n        X509v3 extensions:\r\n            X509v3 Basic Constraints: \r\n                CA:FALSE\r\n            X509v3 Subject Key Identifier: \r\n                69:9A:79:AD:CF:44:C8:04:B3:48:7F:67:1E:2E:A7:C8:C4:CA:D1:8F\r\n            X509v3 Authority Key Identifier: \r\n                keyid:7A:1B:D4:DE:05:0D:47:75:43:46:B0:D5:64:35:3E:45:B7:06:4E:D4\r\n                DirName:/CN=Easy-RSA CA\r\n                serial:2C:9F:CF:FB:62:C0:33:14:D2:40:85:0E:2A:66:B5:EF:EB:96:7A:7E\r\n\r\n            X509v3 Extended Key Usage: \r\n                TLS Web Client Authentication\r\n            X509v3 Key Usage: \r\n                Digital Signature\r\n    Signature Algorithm: sha256WithRSAEncryption\r\n         82:69:48:07:65:89:15:f3:89:49:8a:d3:19:fb:84:f6:6a:f7:\r\n         89:67:8d:bf:ae:6f:4a:83:0d:5d:82:df:79:be:86:68:e8:9a:\r\n         55:0c:0c:dd:c8:e5:fb:f9:4f:e1:61:3a:a3:05:97:0f:2a:f2:\r\n         a3:a5:7d:5b:c8:27:8a:9c:79:b8:dd:c7:56:05:6d:06:20:b4:\r\n         ca:f3:5c:c8:5c:df:e0:18:1b:34:6a:bf:a0:d8:50:e6:ad:d3:\r\n         4f:a0:17:3f:ef:cd:8a:a9:9b:97:a3:2c:75:0f:e5:c3:b4:b6:\r\n         b6:1e:72:f5:f6:2d:5f:0d:cf:1a:bc:f7:c4:c5:18:c3:db:89:\r\n         4e:38:89:7f:d2:f7:08:c2:59:76:3e:4a:25:75:7c:96:13:c8:\r\n         dd:56:bf:e0:e2:47:c3:30:93:41:7a:31:0d:c3:93:16:6d:e0:\r\n         55:d9:43:cf:2b:a0:18:3c:d4:4d:72:f8:df:dc:7b:49:83:e2:\r\n         0b:70:f3:02:7f:ea:a6:e9:6b:78:3e:a1:05:08:4d:ad:44:9d:\r\n         a5:cd:0a:de:6e:77:24:ab:73:66:38:cc:2b:da:d8:dc:b7:b8:\r\n         a1:15:d8:85:86:c7:6b:72:d5:09:e3:1d:41:e4:1a:79:9a:23:\r\n         a5:81:59:7b:8d:5e:8e:37:4d:04:f2:eb:7b:44:78:89:bc:02:\r\n         54:69:de:d7\r\n-----BEGIN CERTIFICATE-----\r\nMIIDWDCCAkCgAwIBAgIQYnPgqQaq9vODExY3ZDzUfjANBgkqhkiG9w0BAQsFADAW\r\nMRQwEgYDVQQDDAtFYXN5LVJTQSBDQTAeFw0yMDA3MDgwODE2NTlaFw0zMDA3MDYw\r\nODE2NTlaMBUxEzARBgNVBAMMCmNsaWVudC1kZTAwggEiMA0GCSqGSIb3DQEBAQUA\r\nA4IBDwAwggEKAoIBAQDb1NJja1kqkmiZNehB5+U/G6q658cjVXPkGhTyHSPNNo6L\r\nzPkqdhIgZnhxVIcVi138wvRuDjdqg+CdHnH6BbMoOxyqG+18ycxXdRMcX6ol7cvS\r\nKXuKzIWaGmlZbxFuNpdoUIDDAJdpXv/JhwY2rfoUFDGjRZXrAWj2LQEDgr5hqxSk\r\nJl8cfoHuxen+ZBGy3VZbMzZaM6bIm0ZKstkwKHm8sL+AW8m2/9QJTClCF2p1Nev/\r\nisi5iXN954QNZAA/OlKKEWXnntrDH9Sj9zfiXSWO1EIkmnqjKCeS1Ela+t9hABJQ\r\nsY5ngQEStiFoa0sUhbcpVC915gdPF3aaY88+cc+9AgMBAAGjgaIwgZ8wCQYDVR0T\r\nBAIwADAdBgNVHQ4EFgQUaZp5rc9EyASzSH9nHi6nyMTK0Y8wUQYDVR0jBEowSIAU\r\nehvU3gUNR3VDRrDVZDU+RbcGTtShGqQYMBYxFDASBgNVBAMMC0Vhc3ktUlNBIENB\r\nghQsn8/7YsAzFNJAhQ4qZrXv65Z6fjATBgNVHSUEDDAKBggrBgEFBQcDAjALBgNV\r\nHQ8EBAMCB4AwDQYJKoZIhvcNAQELBQADggEBAIJpSAdliRXziUmK0xn7hPZq94ln\r\njb+ub0qDDV2C33m+hmjomlUMDN3I5fv5T+FhOqMFlw8q8qOlfVvIJ4qcebjdx1YF\r\nbQYgtMrzXMhc3+AYGzRqv6DYUOat00+gFz/vzYqpm5ejLHUP5cO0trYecvX2LV8N\r\nzxq898TFGMPbiU44iX/S9wjCWXY+SiV1fJYTyN1Wv+DiR8Mwk0F6MQ3DkxZt4FXZ\r\nQ88roBg81E1y+N/ce0mD4gtw8wJ/6qbpa3g+oQUITa1EnaXNCt5udySrc2Y4zCva\r\n2Ny3uKEV2IWGx2ty1QnjHUHkGnmaI6WBWXuNXo43TQTy63tEeIm8AlRp3tc=\r\n-----END CERTIFICATE-----\r\n</cert>\r\n<key>\r\n-----BEGIN PRIVATE KEY-----\r\nMIIEvwIBADANBgkqhkiG9w0BAQEFAASCBKkwggSlAgEAAoIBAQDb1NJja1kqkmiZ\r\nNehB5+U/G6q658cjVXPkGhTyHSPNNo6LzPkqdhIgZnhxVIcVi138wvRuDjdqg+Cd\r\nHnH6BbMoOxyqG+18ycxXdRMcX6ol7cvSKXuKzIWaGmlZbxFuNpdoUIDDAJdpXv/J\r\nhwY2rfoUFDGjRZXrAWj2LQEDgr5hqxSkJl8cfoHuxen+ZBGy3VZbMzZaM6bIm0ZK\r\nstkwKHm8sL+AW8m2/9QJTClCF2p1Nev/isi5iXN954QNZAA/OlKKEWXnntrDH9Sj\r\n9zfiXSWO1EIkmnqjKCeS1Ela+t9hABJQsY5ngQEStiFoa0sUhbcpVC915gdPF3aa\r\nY88+cc+9AgMBAAECggEBAJFSc3J9uIhIGRWPaWaIIihB5e+A4UgeaWpVQ5t6X/x9\r\nIGaSrfS/8OOyWdSxiEtZwlwhlOxcQY4MeCPlyHr74Z+q1BwwMiLYVFlMb8HGC/je\r\n5mqcOatb4MYqx5HztpYhSJ4Q+c3vSijCQF29AQKMqFE1uEqy6ZRdbkGvJohnmet9\r\nr5H1GzD9KTL2HxSuW76HDcYGtrConz98veZOkhFleES1S4ZYd8EyCb0G5+q+iy6s\r\naxzKkhSEXeLGBFg74Yhzvaht5JO6ZSMCq9URr1qt7qOxivBDXTI6z8DDyxyW4mx5\r\naYBU7ZPDtKg4l9bJAO+dXQgACz+4/jbwgft3L6q5o5ECgYEA73S3AUkZ7C1lkEAu\r\n87zcILIXopKt5Fe9V8p/wlKTZL8OLOZ61LunwM5wWWjbG5m8zLBY2NjNsISSw2Sn\r\nmwejzIC6enFkYRtNtzGwXeSWq8pGmyQUoY++2nBk0yWC6MCc9zoEBTvnZADDZ0Em\r\n03qrftwIFp//Ma7uzCLYjFCiobcCgYEA6wUBMWbOxJnWbFn7odH3lomfM32X9a7K\r\n/bpXTBf9Qk+8njVbAAiX2dj6jnxVBQ8YoVK09Q87/t9O/ZpLBwCsol/3tWWkYeSp\r\nHRfobHv1pSFGlmAXuEiRfoMn8LwiSgqPdWofKm8GjHppSMadjWnJgWxZMhqJ7yEN\r\ngLnoFaesiisCgYBf2y4jQpsw819T5o2lHrZUFFbnyqX34bO3QCXyqVG9o8nN6ZnE\r\nLTbTNRC+if4kR1/P5Mw8SlXU0s1ZkKKTqfRFOkbsGxZe1SpAKpD6lTZHoNqw4jms\r\nDzoMga+q4rpL6EctpLjVS4yueKvAWtFrGREr4HMQc44Z2nhXmZ9sVB82cwKBgQCG\r\nQFSfIMhKnEpVmM1acfPJ5ZGwuzTcHl5MtG57xFRi1eO8SGRUT5RW2FDApht3CVmb\r\nhgBi4LH39R5NVh83v9Xd54476/UMCq/kM60Mk38ONkT5T6kdFy8tosRlC0NXIlMy\r\n0k09UzDdfGu6K+MCTgTSzs7hBTH4DNyGxSvjeuXgAwKBgQClaBLmTs3FaWhfLvOs\r\nzzIeiAEzv4eagUims92ym7D0NwgG24gDvaF1+k/aKF4nevuSG+3UeAZHHO/NP0/7\r\npWYYtEdLKqnRL+CcPlVX8OmEAGon5mZAQNMhVWULZXDxnC8IJZ3kmO11MQbKM6ZK\r\n836xsEByT26VtmIqF7b3fcMPMg==\r\n-----END PRIVATE KEY-----\r\n</key>\r\n<tls-auth>\r\n#\r\n# 2048 bit OpenVPN static key\r\n#\r\n-----BEGIN OpenVPN Static key V1-----\r\nf783bbffb7842aaef57c1804691e6682\r\naeebca61555db03aa398db5993c10254\r\n32976641ef2ed5c5e3e97a49dca29440\r\nf583f95034dd28ca1b0de2975493971a\r\nc9eb447e58f737abc8ab1f575f3cc094\r\nc06c55e0840d811b610014998145460c\r\ncb76588cec6fbf5f53c616a5ab0a7265\r\n8014d1d6f487e1b92e3cd621a318041d\r\n8280558b0c6f203cc29e9d7050be040b\r\n5a33347144fe840a73b895f967108895\r\n69119137bc6d320ef50a1d472a245ea2\r\nfc507f926fbacd932cbfc74c13136ddc\r\n48a644cce0c0ad17670e2020e58ede30\r\n7b8dbfcade3efbad75c2af3977a57de8\r\na031644718d76de9cc7f9a5169deed3f\r\n63484a84cc4a62f513444a997f9f0242\r\n-----END OpenVPN Static key V1-----\r\n</tls-auth>\r\n', 1, 0, 'London', 1, 1648013779, 1648118681);
INSERT INTO `open_get_server` (`id`, `country`, `country_code`, `ip_address`, `ovpn`, `premium`, `recommend`, `state`, `is_active`, `created_at`, `updated_at`) VALUES
(86, 'JAPAN', 'JP', '121.109.181.61', 'client\r\ndev tun\r\nproto udp\r\nremote vpn827573169.opengw.net 1568\r\n\r\n;http-proxy-retry\r\n;http-proxy [proxy server] [proxy port]\r\ncipher AES-128-CBC\r\nauth SHA1\r\nresolv-retry infinite\r\nnobind\r\npersist-key\r\npersist-tun\r\nclient\r\nverb 3\r\n<ca>\r\n-----BEGIN CERTIFICATE-----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\r\njjxDah2nGN59PRbxYvnKkKj9\r\n-----END CERTIFICATE-----\r\n\r\n</ca>\r\n\r\n<cert>\r\n-----BEGIN CERTIFICATE-----\r\nMIICxjCCAa4CAQAwDQYJKoZIhvcNAQEFBQAwKTEaMBgGA1UEAxMRVlBOR2F0ZUNs\r\naWVudENlcnQxCzAJBgNVBAYTAkpQMB4XDTEzMDIxMTAzNDk0OVoXDTM3MDExOTAz\r\nMTQwN1owKTEaMBgGA1UEAxMRVlBOR2F0ZUNsaWVudENlcnQxCzAJBgNVBAYTAkpQ\r\nMIIBIjANBgkqhkiG9w0BAQEFAAOCAQ8AMIIBCgKCAQEA5h2lgQQYUjwoKYJbzVZA\r\n5VcIGd5otPc/qZRMt0KItCFA0s9RwReNVa9fDRFLRBhcITOlv3FBcW3E8h1Us7RD\r\n4W8GmJe8zapJnLsD39OSMRCzZJnczW4OCH1PZRZWKqDtjlNca9AF8a65jTmlDxCQ\r\nCjntLIWk5OLLVkFt9/tScc1GDtci55ofhaNAYMPiH7V8+1g66pGHXAoWK6AQVH67\r\nXCKJnGB5nlQ+HsMYPV/O49Ld91ZN/2tHkcaLLyNtywxVPRSsRh480jju0fcCsv6h\r\np/0yXnTB//mWutBGpdUlIbwiITbAmrsbYnjigRvnPqX1RNJUbi9Fp6C2c/HIFJGD\r\nywIDAQABMA0GCSqGSIb3DQEBBQUAA4IBAQChO5hgcw/4oWfoEFLu9kBa1B//kxH8\r\nhQkChVNn8BRC7Y0URQitPl3DKEed9URBDdg2KOAz77bb6ENPiliD+a38UJHIRMqe\r\nUBHhllOHIzvDhHFbaovALBQceeBzdkQxsKQESKmQmR832950UCovoyRB61UyAV7h\r\n+mZhYPGRKXKSJI6s0Egg/Cri+Cwk4bjJfrb5hVse11yh4D9MHhwSfCOH+0z4hPUT\r\nFku7dGavURO5SVxMn/sL6En5D+oSeXkadHpDs+Airym2YHh15h0+jPSOoR6yiVp/\r\n6zZeZkrN43kuS73KpKDFjfFPh8t4r1gOIjttkNcQqBccusnplQ7HJpsk\r\n-----END CERTIFICATE-----\r\n\r\n</cert>\r\n\r\n<key>\r\n-----BEGIN RSA PRIVATE KEY-----\r\nMIIEpAIBAAKCAQEA5h2lgQQYUjwoKYJbzVZA5VcIGd5otPc/qZRMt0KItCFA0s9R\r\nwReNVa9fDRFLRBhcITOlv3FBcW3E8h1Us7RD4W8GmJe8zapJnLsD39OSMRCzZJnc\r\nzW4OCH1PZRZWKqDtjlNca9AF8a65jTmlDxCQCjntLIWk5OLLVkFt9/tScc1GDtci\r\n55ofhaNAYMPiH7V8+1g66pGHXAoWK6AQVH67XCKJnGB5nlQ+HsMYPV/O49Ld91ZN\r\n/2tHkcaLLyNtywxVPRSsRh480jju0fcCsv6hp/0yXnTB//mWutBGpdUlIbwiITbA\r\nmrsbYnjigRvnPqX1RNJUbi9Fp6C2c/HIFJGDywIDAQABAoIBAERV7X5AvxA8uRiK\r\nk8SIpsD0dX1pJOMIwakUVyvc4EfN0DhKRNb4rYoSiEGTLyzLpyBc/A28Dlkm5eOY\r\nfjzXfYkGtYi/Ftxkg3O9vcrMQ4+6i+uGHaIL2rL+s4MrfO8v1xv6+Wky33EEGCou\r\nQiwVGRFQXnRoQ62NBCFbUNLhmXwdj1akZzLU4p5R4zA3QhdxwEIatVLt0+7owLQ3\r\nlP8sfXhppPOXjTqMD4QkYwzPAa8/zF7acn4kryrUP7Q6PAfd0zEVqNy9ZCZ9ffho\r\nzXedFj486IFoc5gnTp2N6jsnVj4LCGIhlVHlYGozKKFqJcQVGsHCqq1oz2zjW6LS\r\noRYIHgECgYEA8zZrkCwNYSXJuODJ3m/hOLVxcxgJuwXoiErWd0E42vPanjjVMhnt\r\nKY5l8qGMJ6FhK9LYx2qCrf/E0XtUAZ2wVq3ORTyGnsMWre9tLYs55X+ZN10Tc75z\r\n4hacbU0hqKN1HiDmsMRY3/2NaZHoy7MKnwJJBaG48l9CCTlVwMHocIECgYEA8jby\r\ndGjxTH+6XHWNizb5SRbZxAnyEeJeRwTMh0gGzwGPpH/sZYGzyu0SySXWCnZh3Rgq\r\n5uLlNxtrXrljZlyi2nQdQgsq2YrWUs0+zgU+22uQsZpSAftmhVrtvet6MjVjbByY\r\nDADciEVUdJYIXk+qnFUJyeroLIkTj7WYKZ6RjksCgYBoCFIwRDeg42oK89RFmnOr\r\nLymNAq4+2oMhsWlVb4ejWIWeAk9nc+GXUfrXszRhS01mUnU5r5ygUvRcarV/T3U7\r\nTnMZ+I7Y4DgWRIDd51znhxIBtYV5j/C/t85HjqOkH+8b6RTkbchaX3mau7fpUfds\r\nFq0nhIq42fhEO8srfYYwgQKBgQCyhi1N/8taRwpk+3/IDEzQwjbfdzUkWWSDk9Xs\r\nH/pkuRHWfTMP3flWqEYgW/LW40peW2HDq5imdV8+AgZxe/XMbaji9Lgwf1RY005n\r\nKxaZQz7yqHupWlLGF68DPHxkZVVSagDnV/sztWX6SFsCqFVnxIXifXGC4cW5Nm9g\r\nva8q4QKBgQCEhLVeUfdwKvkZ94g/GFz731Z2hrdVhgMZaU/u6t0V95+YezPNCQZB\r\nwmE9Mmlbq1emDeROivjCfoGhR3kZXW1pTKlLh6ZMUQUOpptdXva8XxfoqQwa3enA\r\nM7muBbF0XN7VO80iJPv+PmIZdEIAkpwKfi201YB+BafCIuGxIF50Vg==\r\n-----END RSA PRIVATE KEY-----\r\n\r\n</key>\r\n', 1, 0, 'Tokyo', 1, 1648117894, 1648124189),
(87, 'Korea', 'KR', '121.109.181.61', 'client\r\ndev tun\r\nproto udp\r\nremote vpn741739129.opengw.net 1833\r\n;http-proxy-retry\r\n;http-proxy [proxy server] [proxy port]\r\ncipher AES-128-CBC\r\nauth SHA1\r\nresolv-retry infinite\r\nnobind\r\npersist-key\r\npersist-tun\r\nclient\r\nverb 3\r\n\r\n<ca>\r\n-----BEGIN CERTIFICATE-----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\r\njjxDah2nGN59PRbxYvnKkKj9\r\n-----END CERTIFICATE-----\r\n\r\n</ca>\r\n\r\n<cert>\r\n-----BEGIN CERTIFICATE-----\r\nMIICxjCCAa4CAQAwDQYJKoZIhvcNAQEFBQAwKTEaMBgGA1UEAxMRVlBOR2F0ZUNs\r\naWVudENlcnQxCzAJBgNVBAYTAkpQMB4XDTEzMDIxMTAzNDk0OVoXDTM3MDExOTAz\r\nMTQwN1owKTEaMBgGA1UEAxMRVlBOR2F0ZUNsaWVudENlcnQxCzAJBgNVBAYTAkpQ\r\nMIIBIjANBgkqhkiG9w0BAQEFAAOCAQ8AMIIBCgKCAQEA5h2lgQQYUjwoKYJbzVZA\r\n5VcIGd5otPc/qZRMt0KItCFA0s9RwReNVa9fDRFLRBhcITOlv3FBcW3E8h1Us7RD\r\n4W8GmJe8zapJnLsD39OSMRCzZJnczW4OCH1PZRZWKqDtjlNca9AF8a65jTmlDxCQ\r\nCjntLIWk5OLLVkFt9/tScc1GDtci55ofhaNAYMPiH7V8+1g66pGHXAoWK6AQVH67\r\nXCKJnGB5nlQ+HsMYPV/O49Ld91ZN/2tHkcaLLyNtywxVPRSsRh480jju0fcCsv6h\r\np/0yXnTB//mWutBGpdUlIbwiITbAmrsbYnjigRvnPqX1RNJUbi9Fp6C2c/HIFJGD\r\nywIDAQABMA0GCSqGSIb3DQEBBQUAA4IBAQChO5hgcw/4oWfoEFLu9kBa1B//kxH8\r\nhQkChVNn8BRC7Y0URQitPl3DKEed9URBDdg2KOAz77bb6ENPiliD+a38UJHIRMqe\r\nUBHhllOHIzvDhHFbaovALBQceeBzdkQxsKQESKmQmR832950UCovoyRB61UyAV7h\r\n+mZhYPGRKXKSJI6s0Egg/Cri+Cwk4bjJfrb5hVse11yh4D9MHhwSfCOH+0z4hPUT\r\nFku7dGavURO5SVxMn/sL6En5D+oSeXkadHpDs+Airym2YHh15h0+jPSOoR6yiVp/\r\n6zZeZkrN43kuS73KpKDFjfFPh8t4r1gOIjttkNcQqBccusnplQ7HJpsk\r\n-----END CERTIFICATE-----\r\n\r\n</cert>\r\n\r\n<key>\r\n-----BEGIN RSA PRIVATE KEY-----\r\nMIIEpAIBAAKCAQEA5h2lgQQYUjwoKYJbzVZA5VcIGd5otPc/qZRMt0KItCFA0s9R\r\nwReNVa9fDRFLRBhcITOlv3FBcW3E8h1Us7RD4W8GmJe8zapJnLsD39OSMRCzZJnc\r\nzW4OCH1PZRZWKqDtjlNca9AF8a65jTmlDxCQCjntLIWk5OLLVkFt9/tScc1GDtci\r\n55ofhaNAYMPiH7V8+1g66pGHXAoWK6AQVH67XCKJnGB5nlQ+HsMYPV/O49Ld91ZN\r\n/2tHkcaLLyNtywxVPRSsRh480jju0fcCsv6hp/0yXnTB//mWutBGpdUlIbwiITbA\r\nmrsbYnjigRvnPqX1RNJUbi9Fp6C2c/HIFJGDywIDAQABAoIBAERV7X5AvxA8uRiK\r\nk8SIpsD0dX1pJOMIwakUVyvc4EfN0DhKRNb4rYoSiEGTLyzLpyBc/A28Dlkm5eOY\r\nfjzXfYkGtYi/Ftxkg3O9vcrMQ4+6i+uGHaIL2rL+s4MrfO8v1xv6+Wky33EEGCou\r\nQiwVGRFQXnRoQ62NBCFbUNLhmXwdj1akZzLU4p5R4zA3QhdxwEIatVLt0+7owLQ3\r\nlP8sfXhppPOXjTqMD4QkYwzPAa8/zF7acn4kryrUP7Q6PAfd0zEVqNy9ZCZ9ffho\r\nzXedFj486IFoc5gnTp2N6jsnVj4LCGIhlVHlYGozKKFqJcQVGsHCqq1oz2zjW6LS\r\noRYIHgECgYEA8zZrkCwNYSXJuODJ3m/hOLVxcxgJuwXoiErWd0E42vPanjjVMhnt\r\nKY5l8qGMJ6FhK9LYx2qCrf/E0XtUAZ2wVq3ORTyGnsMWre9tLYs55X+ZN10Tc75z\r\n4hacbU0hqKN1HiDmsMRY3/2NaZHoy7MKnwJJBaG48l9CCTlVwMHocIECgYEA8jby\r\ndGjxTH+6XHWNizb5SRbZxAnyEeJeRwTMh0gGzwGPpH/sZYGzyu0SySXWCnZh3Rgq\r\n5uLlNxtrXrljZlyi2nQdQgsq2YrWUs0+zgU+22uQsZpSAftmhVrtvet6MjVjbByY\r\nDADciEVUdJYIXk+qnFUJyeroLIkTj7WYKZ6RjksCgYBoCFIwRDeg42oK89RFmnOr\r\nLymNAq4+2oMhsWlVb4ejWIWeAk9nc+GXUfrXszRhS01mUnU5r5ygUvRcarV/T3U7\r\nTnMZ+I7Y4DgWRIDd51znhxIBtYV5j/C/t85HjqOkH+8b6RTkbchaX3mau7fpUfds\r\nFq0nhIq42fhEO8srfYYwgQKBgQCyhi1N/8taRwpk+3/IDEzQwjbfdzUkWWSDk9Xs\r\nH/pkuRHWfTMP3flWqEYgW/LW40peW2HDq5imdV8+AgZxe/XMbaji9Lgwf1RY005n\r\nKxaZQz7yqHupWlLGF68DPHxkZVVSagDnV/sztWX6SFsCqFVnxIXifXGC4cW5Nm9g\r\nva8q4QKBgQCEhLVeUfdwKvkZ94g/GFz731Z2hrdVhgMZaU/u6t0V95+YezPNCQZB\r\nwmE9Mmlbq1emDeROivjCfoGhR3kZXW1pTKlLh6ZMUQUOpptdXva8XxfoqQwa3enA\r\nM7muBbF0XN7VO80iJPv+PmIZdEIAkpwKfi201YB+BafCIuGxIF50Vg==\r\n-----END RSA PRIVATE KEY-----\r\n\r\n</key>', 1, 0, 'Seoul', 1, 1648119505, 1648129220),
(90, 'Taiwan', 'TW', '123.240.56.200', 'client\r\ndev tun\r\nproto tcp\r\nremote 123.240.56.200 1670\r\n;http-proxy-retry\r\n;http-proxy [proxy server] [proxy port]\r\ncipher AES-128-CBC\r\nauth SHA1\r\nresolv-retry infinite\r\nnobind\r\npersist-key\r\npersist-tun\r\nclient\r\nverb 3\r\n\r\n<ca>\r\n-----BEGIN CERTIFICATE-----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\r\njjxDah2nGN59PRbxYvnKkKj9\r\n-----END CERTIFICATE-----\r\n\r\n</ca>\r\n\r\n<cert>\r\n-----BEGIN CERTIFICATE-----\r\nMIICxjCCAa4CAQAwDQYJKoZIhvcNAQEFBQAwKTEaMBgGA1UEAxMRVlBOR2F0ZUNs\r\naWVudENlcnQxCzAJBgNVBAYTAkpQMB4XDTEzMDIxMTAzNDk0OVoXDTM3MDExOTAz\r\nMTQwN1owKTEaMBgGA1UEAxMRVlBOR2F0ZUNsaWVudENlcnQxCzAJBgNVBAYTAkpQ\r\nMIIBIjANBgkqhkiG9w0BAQEFAAOCAQ8AMIIBCgKCAQEA5h2lgQQYUjwoKYJbzVZA\r\n5VcIGd5otPc/qZRMt0KItCFA0s9RwReNVa9fDRFLRBhcITOlv3FBcW3E8h1Us7RD\r\n4W8GmJe8zapJnLsD39OSMRCzZJnczW4OCH1PZRZWKqDtjlNca9AF8a65jTmlDxCQ\r\nCjntLIWk5OLLVkFt9/tScc1GDtci55ofhaNAYMPiH7V8+1g66pGHXAoWK6AQVH67\r\nXCKJnGB5nlQ+HsMYPV/O49Ld91ZN/2tHkcaLLyNtywxVPRSsRh480jju0fcCsv6h\r\np/0yXnTB//mWutBGpdUlIbwiITbAmrsbYnjigRvnPqX1RNJUbi9Fp6C2c/HIFJGD\r\nywIDAQABMA0GCSqGSIb3DQEBBQUAA4IBAQChO5hgcw/4oWfoEFLu9kBa1B//kxH8\r\nhQkChVNn8BRC7Y0URQitPl3DKEed9URBDdg2KOAz77bb6ENPiliD+a38UJHIRMqe\r\nUBHhllOHIzvDhHFbaovALBQceeBzdkQxsKQESKmQmR832950UCovoyRB61UyAV7h\r\n+mZhYPGRKXKSJI6s0Egg/Cri+Cwk4bjJfrb5hVse11yh4D9MHhwSfCOH+0z4hPUT\r\nFku7dGavURO5SVxMn/sL6En5D+oSeXkadHpDs+Airym2YHh15h0+jPSOoR6yiVp/\r\n6zZeZkrN43kuS73KpKDFjfFPh8t4r1gOIjttkNcQqBccusnplQ7HJpsk\r\n-----END CERTIFICATE-----\r\n\r\n</cert>\r\n\r\n<key>\r\n-----BEGIN RSA PRIVATE KEY-----\r\nMIIEpAIBAAKCAQEA5h2lgQQYUjwoKYJbzVZA5VcIGd5otPc/qZRMt0KItCFA0s9R\r\nwReNVa9fDRFLRBhcITOlv3FBcW3E8h1Us7RD4W8GmJe8zapJnLsD39OSMRCzZJnc\r\nzW4OCH1PZRZWKqDtjlNca9AF8a65jTmlDxCQCjntLIWk5OLLVkFt9/tScc1GDtci\r\n55ofhaNAYMPiH7V8+1g66pGHXAoWK6AQVH67XCKJnGB5nlQ+HsMYPV/O49Ld91ZN\r\n/2tHkcaLLyNtywxVPRSsRh480jju0fcCsv6hp/0yXnTB//mWutBGpdUlIbwiITbA\r\nmrsbYnjigRvnPqX1RNJUbi9Fp6C2c/HIFJGDywIDAQABAoIBAERV7X5AvxA8uRiK\r\nk8SIpsD0dX1pJOMIwakUVyvc4EfN0DhKRNb4rYoSiEGTLyzLpyBc/A28Dlkm5eOY\r\nfjzXfYkGtYi/Ftxkg3O9vcrMQ4+6i+uGHaIL2rL+s4MrfO8v1xv6+Wky33EEGCou\r\nQiwVGRFQXnRoQ62NBCFbUNLhmXwdj1akZzLU4p5R4zA3QhdxwEIatVLt0+7owLQ3\r\nlP8sfXhppPOXjTqMD4QkYwzPAa8/zF7acn4kryrUP7Q6PAfd0zEVqNy9ZCZ9ffho\r\nzXedFj486IFoc5gnTp2N6jsnVj4LCGIhlVHlYGozKKFqJcQVGsHCqq1oz2zjW6LS\r\noRYIHgECgYEA8zZrkCwNYSXJuODJ3m/hOLVxcxgJuwXoiErWd0E42vPanjjVMhnt\r\nKY5l8qGMJ6FhK9LYx2qCrf/E0XtUAZ2wVq3ORTyGnsMWre9tLYs55X+ZN10Tc75z\r\n4hacbU0hqKN1HiDmsMRY3/2NaZHoy7MKnwJJBaG48l9CCTlVwMHocIECgYEA8jby\r\ndGjxTH+6XHWNizb5SRbZxAnyEeJeRwTMh0gGzwGPpH/sZYGzyu0SySXWCnZh3Rgq\r\n5uLlNxtrXrljZlyi2nQdQgsq2YrWUs0+zgU+22uQsZpSAftmhVrtvet6MjVjbByY\r\nDADciEVUdJYIXk+qnFUJyeroLIkTj7WYKZ6RjksCgYBoCFIwRDeg42oK89RFmnOr\r\nLymNAq4+2oMhsWlVb4ejWIWeAk9nc+GXUfrXszRhS01mUnU5r5ygUvRcarV/T3U7\r\nTnMZ+I7Y4DgWRIDd51znhxIBtYV5j/C/t85HjqOkH+8b6RTkbchaX3mau7fpUfds\r\nFq0nhIq42fhEO8srfYYwgQKBgQCyhi1N/8taRwpk+3/IDEzQwjbfdzUkWWSDk9Xs\r\nH/pkuRHWfTMP3flWqEYgW/LW40peW2HDq5imdV8+AgZxe/XMbaji9Lgwf1RY005n\r\nKxaZQz7yqHupWlLGF68DPHxkZVVSagDnV/sztWX6SFsCqFVnxIXifXGC4cW5Nm9g\r\nva8q4QKBgQCEhLVeUfdwKvkZ94g/GFz731Z2hrdVhgMZaU/u6t0V95+YezPNCQZB\r\nwmE9Mmlbq1emDeROivjCfoGhR3kZXW1pTKlLh6ZMUQUOpptdXva8XxfoqQwa3enA\r\nM7muBbF0XN7VO80iJPv+PmIZdEIAkpwKfi201YB+BafCIuGxIF50Vg==\r\n-----END RSA PRIVATE KEY-----\r\n\r\n</key>\r\n', 1, 0, 'Taipei', 1, 1648120217, 1648126279);

ALTER TABLE `open_get_server` ADD PRIMARY KEY (`id`);

ALTER TABLE `open_get_server` MODIFY `id` int NOT NULL AUTO_INCREMENT, AUTO_INCREMENT=91;

-- 29/03-2022

-- Created VPN server table 
CREATE TABLE `vpn_server` (
  `country_id` int(11) NOT NULL,
  `country` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `country_code` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `ip_address` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `premium` tinyint(1) NOT NULL DEFAULT '0',
  `recommend` tinyint(1) NOT NULL DEFAULT '0',
  `flag` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `is_active` tinyint(1) NOT NULL DEFAULT '1',
  `created_at` bigint(20) NOT NULL,
  `updated_at` bigint(20) NOT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

INSERT INTO `vpn_server` (`country_id`, `country`, `country_code`, `ip_address`, `premium`, `recommend`, `flag`, `is_active`, `created_at`, `updated_at`) VALUES
(79, 'Optimal Location', 'CA', '51.222.111.55', 0, 1, '', 1, 1648013780, 1648535330),
(80, 'Germany', 'DE', '54.37.204.111', 0, 0, '', 1, 1648013779, 1648130037),
(81, 'Singapore', 'SG', '51.79.161.151', 0, 0, '', 1, 1648013779, 1648135053),
(82, 'Australia', 'AU', '139.99.170.23', 1, 0, '', 1, 1648013779, 1648129828),
(84, 'United Kingdom', 'GB', '51.75.170.106', 0, 0, '', 1, 1648013779, 1648118681),
(86, 'Optimal Server', 'JP', '218.41.224.181', 0, 0, '', 0, 1648117894, 1648535364),
(87, 'Korea', 'KR', '121.109.181.61', 1, 0, '', 1, 1648119505, 1648531736),
(90, 'Taiwan', 'TW', '123.240.56.200', 1, 0, '', 1, 1648120217, 1648126279);

ALTER TABLE `vpn_server`
  ADD PRIMARY KEY (`country_id`);

ALTER TABLE `vpn_server`
  MODIFY `country_id` int(11) NOT NULL AUTO_INCREMENT, AUTO_INCREMENT=91;

-- Created Sub VPN Server Table 

CREATE TABLE `vpn_sub_server` (
  `id` int(11) NOT NULL,
  `vpn_server_id` int(11) NOT NULL,
  `recommend` tinyint(1) NOT NULL DEFAULT '0',
  `is_active` tinyint(1) NOT NULL DEFAULT '1',
  `ovpn` text COLLATE utf8mb4_unicode_ci NOT NULL,
  `created_at` bigint(20) NOT NULL,
  `updated_at` bigint(20) NOT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

ALTER TABLE `vpn_sub_server`
  ADD PRIMARY KEY (`id`);
ALTER TABLE `vpn_sub_server`
  MODIFY `id` int(11) NOT NULL AUTO_INCREMENT;

  
ALTER TABLE `vpn_server` DROP `ip_address`;
RENAME TABLE `1134-vpn-blue`.`vpn_server` TO `1134-vpn-blue`.`countries`;
RENAME TABLE `1134-vpn-blue`.`vpn_sub_server` TO `1134-vpn-blue`.`vpn_servers`;
ALTER TABLE `vpn_servers` CHANGE `id` `server_id` INT(11) NOT NULL AUTO_INCREMENT, CHANGE `vpn_server_id` `country_id` INT(11) NOT NULL;
ALTER TABLE `vpn_servers` ADD CONSTRAINT `fk1_vpn_servers` FOREIGN KEY (`country_id`) REFERENCES `countries`(`country_id`) ON DELETE CASCADE ON UPDATE CASCADE;
ALTER TABLE `vpn_servers` ADD `ip_address` VARCHAR(255) NOT NULL DEFAULT '' AFTER `country_id`;


-- 12/04/2022
ALTER TABLE user_devices MODIFY COLUMN device_type ENUM('I','A','M','H','Other');

ALTER TABLE user_devices MODIFY COLUMN device_type ENUM('I','A','M','H','AMZ','Other');


-- 14/04/2022
ALTER TABLE `user_devices` ADD INDEX(`is_expired_from_sdk`);
ALTER TABLE `user_devices` ADD INDEX(`wholesaler_user`);

-- 18/04/2022
ALTER TABLE `subscription_analytics`
ADD `users` INT NOT NULL DEFAULT '0' AFTER `year`,
ADD `new_users` INT NOT NULL DEFAULT '0' AFTER `users`,
ADD `guest_users` INT NOT NULL DEFAULT '0' AFTER `new_users`,
ADD `new_guest_users` INT NOT NULL DEFAULT '0' AFTER `guest_users`;

-- 20/04/2022
UPDATE `user_devices` SET wholesaler_user = concat(device_unique_id,"@",wholesaler_user) WHERE `wholesaler_user` LIKE '@vpw.vpnproxymaster.app' and device_type = 'I';
UPDATE `user_devices` SET wholesaler_user = NULL WHERE `wholesaler_user` LIKE '@vpw.vpnproxymaster.app' and device_type = 'A';

-- 21/04/2022
SELECT webhook_subscription.webhook_subscription_id, webhook_subscription.`original_transaction_id`
FROM `webhook_subscriptions` AS webhook_subscription
JOIN (
  SELECT max(webhook_subscription_id) AS max_webhook_subscription_id
  FROM `webhook_subscriptions`
  GROUP BY `original_transaction_id`
) AS max_webhook_subscription ON max_webhook_subscription.max_webhook_subscription_id = webhook_subscription.webhook_subscription_id;

SELECT usubscription.user_subscription_id, user_id, user_device_id
FROM `user_subscriptions` AS usubscription
JOIN ( SELECT max(user_subscription_id) AS max_user_subscription_id
  FROM `user_subscriptions`
  GROUP BY user_id, user_device_id
) AS max_usubscription ON max_usubscription.max_user_subscription_id = usubscription.user_subscription_id;

ALTER TABLE `webhook_subscriptions` ADD `is_latest` BOOLEAN NOT NULL DEFAULT FALSE AFTER `created_at`;

UPDATE `webhook_subscriptions` AS webhook_subscription
JOIN (
  SELECT max(webhook_subscription_id) AS max_webhook_subscription_id, `original_transaction_id` 
	FROM `webhook_subscriptions`
	GROUP BY `original_transaction_id`
) AS max_webhook_subscription ON max_webhook_subscription.max_webhook_subscription_id = webhook_subscription.webhook_subscription_id
SET webhook_subscription.is_latest = TRUE WHERE webhook_subscription.webhook_subscription_id = max_webhook_subscription.max_webhook_subscription_id;

ALTER TABLE `webhook_subscriptions` CHANGE `is_latest` `is_latest_webhook` TINYINT(1) NOT NULL DEFAULT '0';

ALTER TABLE `user_subscriptions` ADD `is_latest_webhook_subscription` BOOLEAN NOT NULL DEFAULT FALSE AFTER `updated_at`;

UPDATE `user_subscriptions` AS usubscription
JOIN ( 
  SELECT max(user_subscription_id) AS max_user_subscription_id
  FROM `user_subscriptions`
  GROUP BY user_id, user_device_id
) AS max_usubscription ON max_usubscription.max_user_subscription_id = usubscription.user_subscription_id
SET usubscription.is_latest_webhook_subscription = TRUE WHERE usubscription.user_subscription_id = max_usubscription.max_user_subscription_id;

-- 27/04/2022
ALTER TABLE `user_devices` CHANGE `device_type` `device_type` ENUM('I','A','M','H','AMZ','Other') CHARACTER SET latin1 COLLATE latin1_swedish_ci NULL DEFAULT NULL;

-- 22/06/2022
ALTER TABLE `vpn_servers` ADD INDEX(`ip_address`);
ALTER TABLE `vpn_servers` ADD `ping_count` INT NOT NULL DEFAULT '0' AFTER `updated_at`;
ALTER TABLE `vpn_servers` CHANGE `ovpn` `ovpn` LONGTEXT CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL;

-- 30/06/2022
ALTER TABLE `vpn_servers` ADD `ping_count` INT NOT NULL DEFAULT '0' AFTER `updated_at`;

CREATE TABLE `last_update` (
  `id` INT NOT NULL AUTO_INCREMENT,
  `module` VARCHAR(255) NOT NULL,
  `last_update` BIGINT NOT NULL,
  PRIMARY KEY  (`id`)
) ENGINE = InnoDB;
INSERT INTO `last_update` (`id`, `module`, `last_update`) VALUES (NULL, 'countries', '0'), (NULL, 'vpn-servers', '0');
ALTER TABLE `last_update` ADD INDEX(`module`);
ALTER TABLE `last_update` CHANGE `last_update` `updated_at` BIGINT NOT NULL;
UPDATE `last_update` SET `module` = 'vpn_servers' WHERE `last_update`.`id` = 2;

-- 05/07/2022
SELECT ip_address, SUBSTRING_INDEX(SUBSTRING_INDEX(ovpn,' ',4),' ',-1) FROM `vpn_servers` WHERE ip_address != SUBSTRING_INDEX(SUBSTRING_INDEX(ovpn,' ',4),' ',-1) and SUBSTRING_INDEX(SUBSTRING_INDEX(ovpn,' ',4),'.',-1) != 'net';

UPDATE vpn_servers set ip_address = SUBSTRING_INDEX(SUBSTRING_INDEX(ovpn,' ',4),' ',-1), updated_at = UNIX_TIMESTAMP() WHERE ip_address != SUBSTRING_INDEX(SUBSTRING_INDEX(ovpn,' ',4),' ',-1) and SUBSTRING_INDEX(SUBSTRING_INDEX(ovpn,' ',4),'.',-1) != 'net';

SELECT country.country, vpn_server.* FROM `vpn_servers` AS vpn_server join countries as country on country.country_id = vpn_server.country_id WHERE country.is_active = 1 and vpn_server.is_active = 1 order by country.country;

-- 12/07/2022
ALTER TABLE `vpn_servers` CHANGE `ovpn` `ovpn` LONGTEXT CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL;
ALTER TABLE `countries` ADD INDEX(`country_code`);
ALTER TABLE `vpn_servers` ADD INDEX(`ip_address`);

/* UPDATE countries AS cnt 
SET cnt.updated_at = UNIX_TIMESTAMP(),
cnt.is_active = IF(NEW.is_active = 1 OR (SELECT count(vpn.server_id) FROM `vpn_servers` AS vpn WHERE vpn.is_active = 1 and vpn.country_id = NEW.country_id > 0), 1, 0) 
WHERE cnt.country_id = NEW.country_id; */

DROP TRIGGER IF EXISTS `active_inactive_vpn_server_country_after_insert`;
CREATE DEFINER=`root`@`localhost` TRIGGER `active_inactive_vpn_server_country_after_insert` AFTER INSERT ON `vpn_servers` FOR EACH ROW 
UPDATE countries AS cnt 
SET cnt.updated_at = UNIX_TIMESTAMP(), cnt.is_active = IF(NEW.is_active = 1 OR (SELECT count(vpn.server_id) FROM `vpn_servers` AS vpn WHERE vpn.is_active = 1 and vpn.country_id = NEW.country_id > 0), 1, 0) 
WHERE cnt.country_id = NEW.country_id;

DROP TRIGGER IF EXISTS `active_inactive_vpn_server_country_after_update`;
CREATE DEFINER=`root`@`localhost` TRIGGER `active_inactive_vpn_server_country_after_update` AFTER UPDATE ON `vpn_servers` FOR EACH ROW 
UPDATE countries AS cnt 
SET cnt.updated_at = UNIX_TIMESTAMP(), cnt.is_active = IF(NEW.is_active = 1 OR (SELECT count(vpn.server_id) FROM `vpn_servers` AS vpn WHERE vpn.is_active = 1 and vpn.country_id = NEW.country_id > 0), 1, 0) 
WHERE cnt.country_id = NEW.country_id;

CREATE TABLE `1134-vpn-blue`.`temp_servers` (
  `server_id` int NOT NULL,
  `country_id` int NOT NULL,
  `ip_address` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `recommend` tinyint(1) NOT NULL DEFAULT '0',
  `is_active` tinyint(1) NOT NULL DEFAULT '1',
  `ovpn` longtext CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `created_at` bigint NOT NULL,
  `updated_at` bigint NOT NULL,
  `ping_count` int NOT NULL DEFAULT '0'
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
ALTER TABLE `1134-vpn-blue`.`temp_servers` ADD PRIMARY KEY (`server_id`), ADD KEY `fk1_temp_servers` (`country_id`), ADD KEY `ip_address` (`ip_address`);
ALTER TABLE `1134-vpn-blue`.`temp_servers` MODIFY `server_id` int NOT NULL AUTO_INCREMENT;
ALTER TABLE `temp_servers` ADD CONSTRAINT `fk1_temp_servers` FOREIGN KEY (`country_id`) REFERENCES `countries`(`country_id`) ON DELETE CASCADE ON UPDATE CASCADE;

/* SELECT country_id, (SELECT country_code FROM countries c WHERE c.country_id = vs.country_id) AS country_code, (10 - COUNT(country_id)) remcount
FROM vpn_servers AS vs
GROUP BY country_id
HAVING remcount > 0 */

-- 14/07/2022
SELECT cnt.country_id, count(vpn.country_id), (10 - count(vpn.country_id)) as remcount
FROM countries AS cnt
LEFT JOIN vpn_servers AS vpn ON vpn.country_id = cnt.country_id AND vpn.is_active = TRUE
GROUP by cnt.country_id
HAVING remcount > 0;

-- 15/07/2022
ALTER TABLE `users` ADD `is_deleted` BOOLEAN NOT NULL DEFAULT FALSE AFTER `is_profile_completed`;

-- 23/08/2022
ALTER TABLE webhook_subscriptions ADD is_premium_subscription BOOL DEFAULT FALSE NOT NULL;
ALTER TABLE webhook_subscriptions CHANGE is_premium_subscription is_premium_subscription BOOL DEFAULT FALSE NOT NULL AFTER product_id;
UPDATE webhook_subscriptions SET is_premium_subscription = TRUE
WHERE product_id  in ('com.optimal.vpn.streamingmonth','com.optimal.vpn.streamingyear','com.vpn.super.unlimited.proxy.open.free.streamingyearly','com.vpn.super.unlimited.proxy.open.free.streamingmonthly');

-- 24/08/2022
ALTER TABLE `user_subscriptions` ADD INDEX(`is_latest_webhook_subscription`);
ALTER TABLE `webhook_subscriptions` ADD INDEX(`is_latest_webhook`);

-- 01/12/2022
ALTER TABLE `user_subscriptions` CHANGE `updated_at` `updated_at` BIGINT(20) NOT NULL;

-- 21/12/2022
CREATE TABLE `vpn_wholesalers` (
  `id` INT NOT NULL AUTO_INCREMENT ,
  `email` VARCHAR(255) NOT NULL,
  `password` VARCHAR(255) NOT NULL,
  `status` VARCHAR(255) NOT NULL,
  `result` VARCHAR(255) NOT NULL,
  `code` INT NOT NULL DEFAULT '200',
  `message` VARCHAR(255) NULL DEFAULT NULL,
  `response` JSON NOT NULL,
  `created_at` TIMESTAMP NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `updated_at` TIMESTAMP on update CURRENT_TIMESTAMP NOT NULL DEFAULT CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`)
) ENGINE = InnoDB;
ALTER TABLE `vpn_wholesalers` CHANGE `code` `code` INT NULL DEFAULT '200';

-- 09/03/2023
ALTER TABLE `users` ADD INDEX(`is_deleted`);
ALTER TABLE `users` ADD INDEX(`created_at`);
ALTER TABLE `user_devices` ADD INDEX(`created_at`);
ALTER TABLE `user_devices` ADD INDEX(`updated_at`);

-- 13/03/2023
ALTER TABLE `webhook_subscriptions` ADD `is_expired` BOOLEAN NOT NULL DEFAULT FALSE AFTER `expires_date_ms`;
ALTER TABLE `webhook_subscriptions` ADD INDEX(`is_expired`);
CREATE EVENT `set_is_expired_flag_if_expired` ON SCHEDULE EVERY 1 MINUTE STARTS '2023-03-13 14:12:20.000000' ON COMPLETION NOT PRESERVE ENABLE DO UPDATE webhook_subscriptions set is_expired = 1 WHERE expires_date_ms <= (UNIX_TIMESTAMP()*1000) AND is_expired = 0;

-- 16/03/2023
ALTER TABLE `webhook_subscriptions` ADD INDEX(`is_premium_subscription`);

-- 20/03/2023
DROP EVENT IF EXISTS `set_is_expired_flag_if_expired`;
CREATE DEFINER=`root`@`localhost` EVENT `set_is_expired_flag_if_expired` ON SCHEDULE EVERY 1 MINUTE 
STARTS '2023-03-13 14:12:20' ON COMPLETION NOT PRESERVE ENABLE 
DO 
UPDATE webhook_subscriptions set is_expired = 1, created_at=UNIX_TIMESTAMP() WHERE expires_date_ms <= (UNIX_TIMESTAMP()*1000) AND is_expired = 0

CREATE TABLE `subscription_stats` (
  `stat_id` INT NOT NULL AUTO_INCREMENT,
  `store` ENUM('apple','android') NOT NULL,
  `paid_subscribers` INT NOT NULL,
  `trial_subscribers` INT NOT NULL,
  `expired_subscribers` INT NOT NULL,
  `created_date` TIMESTAMP NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `updated_date` TIMESTAMP on update CURRENT_TIMESTAMP NOT NULL DEFAULT CURRENT_TIMESTAMP,
  PRIMARY KEY (`stat_id`)
) ENGINE = InnoDB;
ALTER TABLE `subscription_stats` ADD `stat_date` DATE NOT NULL AFTER `store`;

-- 21/03/2023
ALTER TABLE `subscription_stats` ADD INDEX(`store`);
ALTER TABLE `subscription_stats` ADD INDEX(`stat_date`);

