#!/bin/bash
BASEDIR=$(dirname "$0")
source $BASEDIR"/"config.sh

CURL_TYPE="curl -kis"
# ##############################################################################################################
# CPU Full Utilization Alert
# ##############################################################################################################
if [[ ${CPU_USAGE} -ge ${CPU_USAGE_LIMIT} ]]; then
    CPU_USAGE_INFO="/tmp/CPU_USAGE.out"
    echo "+------------------------------------------------------------------+" >> $CPU_USAGE_INFO
    echo "Top 20 processes which consuming high CPU" >> $CPU_USAGE_INFO
    echo "+------------------------------------------------------------------+" >> $CPU_USAGE_INFO
    echo "$(top -bn1 | head -20)" >> $CPU_USAGE_INFO
    echo "" >> $CPU_USAGE_INFO
    echo "+------------------------------------------------------------------+" >> $CPU_USAGE_INFO
    echo "Top 10 Processes which consuming high CPU using the ps command" >> $CPU_USAGE_INFO
    echo "+------------------------------------------------------------------+" >> $CPU_USAGE_INFO
    echo "$(ps -eo pcpu,pid,user,args | sort -k 1 -r | head -10)" >> $CPU_USAGE_INFO

    echo `$CURL_TYPE $API_URL -F hostname="$HOSTNAME" -F action="$MAX_CPU_USAGE_ALERT" -F cpu_usage="$CPU_USAGE" -F file=@"$CPU_USAGE_INFO"`
    rm "$CPU_USAGE_INFO"
else
    echo `$CURL_TYPE $API_URL -F hostname="$HOSTNAME" -F action="$NORMAL_CPU_USAGE_ALERT" -F cpu_usage="$CPU_USAGE"`
fi
# ##############################################################################################################

# ##############################################################################################################
# Critical Storage Capacity Alert 
# ##############################################################################################################
if [[ ${HDD_USED_PER} -ge ${HDD_USAGE_LIMIT} ]]; then
    HDD_USAGE_INFO="/tmp/HDD_USAGE.out"
    echo "+------------------------------------------------------------------+" >> $HDD_USAGE_INFO
    echo "Top directories which consuming highest storage" >> $HDD_USAGE_INFO
    echo "+------------------------------------------------------------------+" >> $HDD_USAGE_INFO
    echo "$(sudo du -x -h --threshold=1G / | sort -h)" >> $HDD_USAGE_INFO
    echo "" >> $HDD_USAGE_INFO

    echo `$CURL_TYPE $API_URL -F hostname="$HOSTNAME" -F action="$MAX_HDD_USAGE_ALERT" -F hdd_used_per="$HDD_USED_PER" -F hdd_total="$HDD_TOTAL" -F hdd_avail="$HDD_AVAIL" -F hdd_used="$HDD_USED" -F file=@"$HDD_USAGE_INFO"`
    rm "$HDD_USAGE_INFO"
else
    echo `$CURL_TYPE $API_URL -F hostname="$HOSTNAME" -F action="$NORMAL_HDD_USAGE_ALERT" -F hdd_used_per="$HDD_USED_PER" -F hdd_total="$HDD_TOTAL" -F hdd_avail="$HDD_AVAIL" -F hdd_used="$HDD_USED"`
fi
# ##############################################################################################################

# ##############################################################################################################
# Critical Memory Capacity Alert
# ##############################################################################################################
if [[ ${MEM_AVAIL} -le ${MEM_MIN_LEVEL} ]]; then
    MEM_USAGE_INFO="/tmp/MEM_USAGE.out"
    echo "+------------------------------------------------------------------+" >> $MEM_USAGE_INFO
    echo "Top processes which consuming sytem memory" >> $MEM_USAGE_INFO
    echo "+------------------------------------------------------------------+" >> $MEM_USAGE_INFO
    echo "$(ps -eo pid,ppid,cmd,%mem,%cpu --sort=-%mem | head)" >> $MEM_USAGE_INFO
    echo "" >> $MEM_USAGE_INFO

    echo `$CURL_TYPE $API_URL -F hostname="$HOSTNAME" -F action="$MAX_MEM_USAGE_ALERT" -F mem_usage="$MEM_USAGE" -F mem_total="$MEM_TOTAL" -F mem_avail="$MEM_AVAIL" -F file=@"$MEM_USAGE_INFO"`
    rm "$MEM_USAGE_INFO"
else
    echo `$CURL_TYPE $API_URL -F hostname="$HOSTNAME" -F action="$NORMAL_MEM_USAGE_ALERT" -F mem_usage="$MEM_USAGE" -F mem_total="$MEM_TOTAL" -F mem_avail="$MEM_AVAIL"`
fi
# ##############################################################################################################
exit 0
