-- Device exist with Wholesaler in DB, but no mapping found
SELECT device.*, from_unixtime(device.created_at), from_unixtime(device.updated_at) 
FROM `user_devices` AS device 
LEFT JOIN user_subscriptions AS usub ON usub.user_device_id = device.user_device_id AND usub.is_latest_webhook_subscription = 1 
WHERE wholesaler_user IS NOT NULL AND is_expired_from_sdk = 0 AND device_type = 'I' AND usub.user_device_id IS NULL 
ORDER BY `device`.`user_device_id` DESC;

-- Check for the duplication receipts
SELECT max(receipt_created_at), COUNT(*) AS `Rows`, `transaction_id` FROM `subscription_receipts` GROUP BY `transaction_id` HAVING `Rows` > 1;

-- Check for the duplicate user subscription binding
SELECT max(user_subscription_id) AS latest_user_subscription_id, COUNT(*) AS `repeated`, `original_transaction_id`, user_id, user_device_id
FROM `user_subscriptions`
GROUP BY `original_transaction_id`, user_id, user_device_id
HAVING `repeated` > 1;

-- Check for the old/repeated user subscription binding
SELECT old_data.user_subscription_id, old_data.original_transaction_id, old_data.user_id, old_data.user_device_id
FROM user_subscriptions AS old_data
JOIN (
    SELECT max(user_subscription_id) AS latest_user_subscription_id, COUNT(*) AS `repeated`, `original_transaction_id`, user_id, user_device_id
	FROM `user_subscriptions`
    WHERE is_latest_webhook_subscription = 1
	GROUP BY `original_transaction_id`, user_id, user_device_id
    HAVING `repeated` > 1
) AS latest_data ON latest_data.original_transaction_id = old_data.original_transaction_id
AND latest_data.user_id = old_data.user_id
AND latest_data.user_device_id = old_data.user_device_id
AND latest_data.latest_user_subscription_id != old_data.user_subscription_id;

-- Delete data from above query
DELETE old_data
FROM user_subscriptions AS old_data
JOIN (
    SELECT max(user_subscription_id) AS latest_user_subscription_id, COUNT(*) AS `repeated`, `original_transaction_id`, user_id, user_device_id
    FROM `user_subscriptions`
    GROUP BY `original_transaction_id`, user_id, user_device_id
    HAVING `repeated` > 1
) AS latest_data ON latest_data.original_transaction_id = old_data.original_transaction_id
AND latest_data.user_id = old_data.user_id
AND latest_data.user_device_id = old_data.user_device_id
AND latest_data.latest_user_subscription_id != old_data.user_subscription_id;

-- 
-- 20/03/2023
-- 

-- Current
SELECT `web_subscription`.`webhook_subscription_id`, `web_subscription`.`notification_store`, `web_subscription`.`notification_type`, `web_subscription`.`environment`, `web_subscription`.`auto_renew_product_id`, `web_subscription`.`auto_renew_status`, `web_subscription`.`auto_renew_status_change_date_ms`, `web_subscription`.`password`, `web_subscription`.`bid`, `web_subscription`.`bvrs`, `web_subscription`.`in_app_ownership_type`, `web_subscription`.`purchase_date_ms`, `web_subscription`.`transaction_id`, `web_subscription`.`original_purchase_date_ms`, `web_subscription`.`original_transaction_id`, `web_subscription`.`quantity`, `web_subscription`.`expires_date_ms`, `web_subscription`.`product_id`, `web_subscription`.`is_trial_period`, `web_subscription`.`is_in_intro_offer_period`, `web_subscription`.`expiration_intent`, `web_subscription`.`cancellation_date_ms`, `web_subscription`.`price`, `web_subscription`.`is_expired`, `web_subscription`.`created_at`, `device`.`user_device_id`, `device`.`device_unique_id`, `device`.`wholesaler_user`, `device`.`is_expired_from_sdk`, `device`.`device_name`, `device`.`device_token`, `device`.`device_type`, `device`.`app_version`, `device`.`updated_at`
FROM `webhook_subscriptions` AS `web_subscription`
JOIN `user_subscriptions` AS `usubscription` ON `web_subscription`.`original_transaction_id` = `usubscription`.`original_transaction_id` AND `usubscription`.`is_latest_webhook_subscription` = 1
JOIN `user_devices` AS `device` ON `device`.`user_device_id` = `usubscription`.`user_device_id`
WHERE `web_subscription`.`is_latest_webhook` = 1
AND `web_subscription`.`is_premium_subscription` = 1
AND `device`.`is_expired_from_sdk` = 0
AND `web_subscription`.`is_expired` = 0
AND device.wholesaler_user IS NULL
ORDER BY `web_subscription`.`webhook_subscription_id` ASC
 LIMIT 1000;

-- Device
SELECT `web_subscription`.`webhook_subscription_id`, `web_subscription`.`notification_store`, `web_subscription`.`notification_type`, `web_subscription`.`environment`, `web_subscription`.`auto_renew_product_id`, `web_subscription`.`auto_renew_status`, `web_subscription`.`auto_renew_status_change_date_ms`, `web_subscription`.`password`, `web_subscription`.`bid`, `web_subscription`.`bvrs`, `web_subscription`.`in_app_ownership_type`, `web_subscription`.`purchase_date_ms`, `web_subscription`.`transaction_id`, `web_subscription`.`original_purchase_date_ms`, `web_subscription`.`original_transaction_id`, `web_subscription`.`quantity`, `web_subscription`.`expires_date_ms`, `web_subscription`.`product_id`, `web_subscription`.`is_trial_period`, `web_subscription`.`is_in_intro_offer_period`, `web_subscription`.`expiration_intent`, `web_subscription`.`cancellation_date_ms`, `web_subscription`.`price`, `web_subscription`.`is_expired`, `web_subscription`.`created_at`, `device`.`user_device_id`, `device`.`device_unique_id`, `device`.`wholesaler_user`, `device`.`is_expired_from_sdk`, `device`.`device_name`, `device`.`device_token`, `device`.`device_type`, `device`.`app_version`, `device`.`updated_at`
FROM `user_devices` AS `device`
JOIN `user_subscriptions` AS `usubscription` ON `device`.`user_device_id` = `usubscription`.`user_device_id` AND `usubscription`.`is_latest_webhook_subscription` = 1
JOIN `webhook_subscriptions` AS `web_subscription` ON `web_subscription`.`original_transaction_id` = `usubscription`.`original_transaction_id`
WHERE `web_subscription`.`is_latest_webhook` = 1
AND `device`.`is_expired_from_sdk` = 0
AND `web_subscription`.`is_premium_subscription` = 1
AND `web_subscription`.`is_expired` = 0
AND device.wholesaler_user IS NULL
AND `web_subscription`.`notification_store` = 'android'
ORDER BY `web_subscription`.`webhook_subscription_id` ASC
 LIMIT 1000;

-- Update Device
UPDATE `user_devices` AS `device`
JOIN `user_subscriptions` AS `usubscription` ON `device`.`user_device_id` = `usubscription`.`user_device_id` AND `usubscription`.`is_latest_webhook_subscription` = 1
JOIN `webhook_subscriptions` AS `web_subscription` ON `web_subscription`.`original_transaction_id` = `usubscription`.`original_transaction_id`
SET device.wholesaler_user = concat(web_subscription.original_transaction_id,"@vpw.vpnproxymaster.app")
WHERE `web_subscription`.`is_latest_webhook` = 1
AND `device`.`is_expired_from_sdk` = 0
AND `web_subscription`.`is_premium_subscription` = 1
AND `web_subscription`.`is_expired` = 0
AND device.wholesaler_user IS NULL
AND `web_subscription`.`notification_store` = 'android';

UPDATE `user_devices` AS `device`
JOIN `user_subscriptions` AS `usubscription` ON `device`.`user_device_id` = `usubscription`.`user_device_id` AND `usubscription`.`is_latest_webhook_subscription` = 1
JOIN `webhook_subscriptions` AS `web_subscription` ON `web_subscription`.`original_transaction_id` = `usubscription`.`original_transaction_id`
SET device.wholesaler_user = concat(device.device_unique_id,"@vpw.vpnproxymaster.app")
WHERE `web_subscription`.`is_latest_webhook` = 1
AND `device`.`is_expired_from_sdk` = 0
AND `web_subscription`.`is_premium_subscription` = 1
AND `web_subscription`.`is_expired` = 0
AND device.wholesaler_user IS NULL
AND `web_subscription`.`notification_store` = 'apple';
