"use strict";
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var __metadata = (this && this.__metadata) || function (k, v) {
    if (typeof Reflect === "object" && typeof Reflect.metadata === "function") return Reflect.metadata(k, v);
};
var __param = (this && this.__param) || function (paramIndex, decorator) {
    return function (target, key) { decorator(target, key, paramIndex); }
};
var ReportEvent_1;
Object.defineProperty(exports, "__esModule", { value: true });
exports.ReportEvent = void 0;
const common_1 = require("@nestjs/common");
const event_emitter_1 = require("@nestjs/event-emitter");
const mongoose_1 = require("@nestjs/mongoose");
const mongoose_2 = require("mongoose");
const CronSyncService_service_1 = require("../AnalyticsReport/CronSyncService.service");
const CurrentStage_enum_1 = require("../enum/CurrentStage.enum");
const AnalyticsReport_schema_1 = require("../models/AnalyticsReport.schema");
const logger_service_1 = require("../utils/logger.service");
let ReportEvent = ReportEvent_1 = class ReportEvent {
    constructor(AppleAccountRepo, cronSyncService, loggerService) {
        this.AppleAccountRepo = AppleAccountRepo;
        this.cronSyncService = cronSyncService;
        this.loggerService = loggerService;
        this.logger = new common_1.Logger(ReportEvent_1.name);
    }
    async sentReport(fromDate, toDate, record) {
        try {
            const salesStatus = await this.cronSyncService.doSyncReportInBatch(fromDate, toDate, AnalyticsReport_schema_1.recordTypeEnum.SALES, record);
            console.log('salesStatus>>>>>>>>>', salesStatus);
            const downloadStatus = await this.cronSyncService.doSyncReportInBatch(fromDate, toDate, AnalyticsReport_schema_1.recordTypeEnum.DOWNLOAD, record);
            console.log('downloadStatus>>>>>>>', downloadStatus);
            await this.AppleAccountRepo.updateMany({}, { $set: { InitialSyncStatus: CurrentStage_enum_1.CurrentStage.COMPLETED } });
            this.loggerService.log(`Sync report processed successfully for record` + " " + `${record._id}`);
        }
        catch (error) {
            console.log(error, 'error');
        }
    }
};
exports.ReportEvent = ReportEvent;
__decorate([
    (0, event_emitter_1.OnEvent)('sync.Report', { async: true }),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [Object, Object, Object]),
    __metadata("design:returntype", Promise)
], ReportEvent.prototype, "sentReport", null);
exports.ReportEvent = ReportEvent = ReportEvent_1 = __decorate([
    (0, common_1.Injectable)(),
    __param(0, (0, mongoose_1.InjectModel)("AppleAccount")),
    __metadata("design:paramtypes", [mongoose_2.default.Model, CronSyncService_service_1.CronSyncService,
        logger_service_1.LoggerService])
], ReportEvent);
//# sourceMappingURL=sync.Report.event.js.map