import { Module } from "@nestjs/common";
import { AnalyticsReportController } from "./AnalyticsReport.controller";
import { MongooseModule } from "@nestjs/mongoose";
import { AnalyticsReportService } from "./AnalyticsReport.service";
import SCHEMASLIST from "src/models";
import { HttpModule } from "@nestjs/axios";
import { JwtModule } from "@nestjs/jwt";
import { CronSyncService } from "./CronSyncService.service";
import { MulterModule } from "@nestjs/platform-express";
import { EventEmitterModule } from "@nestjs/event-emitter";
import { ReportEvent } from "src/event/sync.Report.event";
import { LoggerService } from "src/utils/logger.service";
import * as https from 'https';
import * as http from 'http';

@Module({
  imports: [
    MongooseModule.forFeature([...SCHEMASLIST]),
    HttpModule.register({
      timeout: 60000, // 60 seconds timeout
      maxRedirects: 5,
      // Configure Keep-Alive and connection pooling
      httpAgent: new http.Agent({
        keepAlive: true,
        keepAliveMsecs: 30000, // 30 seconds
        maxSockets: 50, // Maximum number of sockets per host
        maxFreeSockets: 10, // Maximum number of idle sockets
        timeout: 60000, // Socket timeout
      }),
      httpsAgent: new https.Agent({
        keepAlive: true,
        keepAliveMsecs: 30000, // 30 seconds
        maxSockets: 50, // Maximum number of sockets per host
        maxFreeSockets: 10, // Maximum number of idle sockets
        timeout: 60000, // Socket timeout
        // Additional HTTPS settings for Apple API
        rejectUnauthorized: true,
        secureProtocol: 'TLSv1_2_method', // Use TLS 1.2
      }),
    }),
    EventEmitterModule.forRoot(),
    MulterModule.register({
      dest: './uploads', // Set the destination folder for file uploads
    }),
    JwtModule.register({
      global: true,
      privateKey: process.env.privateKey,
      signOptions: { expiresIn: '15m' },
    }),

  ],
  controllers: [AnalyticsReportController],
  providers: [AnalyticsReportService, CronSyncService, ReportEvent, LoggerService],
})
export class AnalyticsReportModule { }
