import { Prop, Schema, SchemaFactory } from "@nestjs/mongoose";
import mongoose from "mongoose";
import { AppleAccount } from "./AppleAccount.schema";

export enum recordTypeEnum {
  SALES = 'SALES',
  DOWNLOAD = 'DOWNLOAD'
}

@Schema()
export class AnalyticsReport {
  @Prop({ type: mongoose.Schema.Types.Date })
  EventDate: Date;

  @Prop({
    type: mongoose.Schema.Types.ObjectId,
    ref: 'AppleAccount',
  })
  AccountID: AppleAccount;

  @Prop()
  AppName: String;
  @Prop()
  AppAppleID: String;
  @Prop()
  SubscriptionName: String;
  @Prop()
  SubscriptionAppleID: String;
  @Prop()
  SubscriptionGroupID: String;
  @Prop()
  StandardSubscriptionDuration: String;
  @Prop()
  SubscriptionOfferName: String;
  @Prop()
  PromotionalOfferID: String;
  @Prop()
  SubscriptionOfferType: String;
  @Prop()
  SubscriptionOfferDuration: String;
  @Prop()
  MarketingOpt: String;
  @Prop()
  CustomerPrice: String;
  @Prop()
  CustomerCurrency: String;
  @Prop()
  DeveloperProceeds: String;
  @Prop()
  DeveloperProceedsInUsd: Number;
  @Prop()
  CustomerProceedsInUsd: Number
  @Prop()
  ProceedsCurrency: String;
  @Prop()
  PreservedPricing: String;
  @Prop()
  ProceedsReason: String;
  @Prop()
  Client: String;
  @Prop()
  Device: String;
  @Prop()
  Country: String;
  @Prop()
  SubscriberID: String;
  @Prop()
  SubscriberIDReset: String;
  @Prop()
  Refund: String;
  @Prop()
  PurchaseDate: String;
  @Prop()
  Units: Number;
  @Prop()
  type: recordTypeEnum

  @Prop()
  Provider: String;
  @Prop()
  ProviderCountry: String;
  @Prop()
  SKU: String;
  @Prop()
  Developer: String;
  @Prop()
  Title: String;
  @Prop()
  Version: String;
  @Prop()
  ProductTypeIdentifier: String;
  @Prop()
  BeginDate: String;
  @Prop()
  EndDate: String;
  @Prop()
  CountryCode: String;
  @Prop()
  CurrencyofProceeds: String;
  @Prop()
  AppleIdentifier: String;
  @Prop()
  PromoCode: String;
  @Prop()
  ParentIdentifier: String;
  @Prop()
  Subscription: String;
  @Prop()
  Period: String;
  @Prop()
  Category: String;
  @Prop()
  CMB: String;
  @Prop()
  SupportedPlatforms: String;
  @Prop()
  OrderType: String;
  @Prop()
  iconurl: string
}

export const AnalyticsReportSchema = SchemaFactory.createForClass(AnalyticsReport);
