import { Module } from "@nestjs/common";
import { AnalyticsReportController } from "./AnalyticsReport.controller";
import { MongooseModule } from "@nestjs/mongoose";
import { AnalyticsReportService } from "./AnalyticsReport.service";
import SCHEMASLIST from "src/models";
import { HttpModule } from "@nestjs/axios";
import { JwtModule } from "@nestjs/jwt";
import { CronSyncService } from "./CronSyncService.service";
import { MulterModule } from "@nestjs/platform-express";
import { EventEmitterModule } from "@nestjs/event-emitter";
import { ReportEvent } from "src/event/sync.Report.event";
import { LoggerService } from "src/utils/logger.service";

@Module({
  imports: [
    MongooseModule.forFeature([...SCHEMASLIST]),
    HttpModule,
    EventEmitterModule.forRoot(),
    MulterModule.register({
      dest: './uploads', // Set the destination folder for file uploads
    }),
    JwtModule.register({
      global: true,
      privateKey: process.env.privateKey,
      signOptions: { expiresIn: '15m' },
    }),

  ],
  controllers: [AnalyticsReportController],
  providers: [AnalyticsReportService, CronSyncService, ReportEvent, LoggerService],
})
export class AnalyticsReportModule { }
