"use strict";
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.AnalyticsReportModule = void 0;
const common_1 = require("@nestjs/common");
const AnalyticsReport_controller_1 = require("./AnalyticsReport.controller");
const mongoose_1 = require("@nestjs/mongoose");
const AnalyticsReport_service_1 = require("./AnalyticsReport.service");
const models_1 = require("../models");
const axios_1 = require("@nestjs/axios");
const jwt_1 = require("@nestjs/jwt");
const CronSyncService_service_1 = require("./CronSyncService.service");
const platform_express_1 = require("@nestjs/platform-express");
const event_emitter_1 = require("@nestjs/event-emitter");
const sync_Report_event_1 = require("../event/sync.Report.event");
const logger_service_1 = require("../utils/logger.service");
let AnalyticsReportModule = class AnalyticsReportModule {
};
exports.AnalyticsReportModule = AnalyticsReportModule;
exports.AnalyticsReportModule = AnalyticsReportModule = __decorate([
    (0, common_1.Module)({
        imports: [
            mongoose_1.MongooseModule.forFeature([...models_1.default]),
            axios_1.HttpModule,
            event_emitter_1.EventEmitterModule.forRoot(),
            platform_express_1.MulterModule.register({
                dest: './uploads',
            }),
            jwt_1.JwtModule.register({
                global: true,
                privateKey: process.env.privateKey,
                signOptions: { expiresIn: '15m' },
            }),
        ],
        controllers: [AnalyticsReport_controller_1.AnalyticsReportController],
        providers: [AnalyticsReport_service_1.AnalyticsReportService, CronSyncService_service_1.CronSyncService, sync_Report_event_1.ReportEvent, logger_service_1.LoggerService],
    })
], AnalyticsReportModule);
//# sourceMappingURL=AnalyticsReport.module.js.map