import { HttpService } from "@nestjs/axios";
import mongoose from "mongoose";
import { AnalyticsReport } from "src/models/AnalyticsReport.schema";
import { JwtService } from '@nestjs/jwt';
import { CurrencyValuation } from "src/models/CurrencyValuation.schema";
import { AppleAccount } from "src/models/AppleAccount.schema";
import { LoggerService } from "src/utils/logger.service";
export declare class AnalyticsReportService {
    private analyticsReportRepo;
    private CurrencyValuationRepo;
    private appleAccountRepo;
    private readonly httpService;
    private jwtService;
    private loggerService;
    CONST_REPORT_TYPES: {
        SALES: string;
        DOWNLOAD: string;
    };
    constructor(analyticsReportRepo: mongoose.Model<AnalyticsReport>, CurrencyValuationRepo: mongoose.Model<CurrencyValuation>, appleAccountRepo: mongoose.Model<AppleAccount>, httpService: HttpService, jwtService: JwtService, loggerService: LoggerService);
    private readonly logger;
    dohandleSyncDownloadReports(): Promise<any>;
    doGetVendorList(): Promise<{
        code: number;
        status: string;
        data?: undefined;
    } | {
        data: (mongoose.Document<unknown, {}, AppleAccount> & AppleAccount & {
            _id: mongoose.Types.ObjectId;
        })[];
        status: boolean;
        code?: undefined;
    }>;
    dohandleSyncSalesReports(): Promise<any>;
    doGetReportsUrl(type: any, gDate: any): string;
    axiosApiCall(baseUrl: any): Promise<{
        status: boolean;
        data: any;
        error?: undefined;
    } | {
        status: boolean;
        data: any[];
        error: any;
    }>;
    generateJWT: () => Promise<{
        access_token: string;
    }>;
    doHandleParsingCSV: () => Promise<unknown>;
    doSyncCurrency: (syncingDate?: any) => Promise<unknown>;
    doGetAnalyticsForDate: (from: any, to: any, type: any, AccountID: any) => Promise<{
        currentData: any[];
        currTotal: string;
        prevTotal: string;
        status: boolean;
    }>;
    analysticsData: (from: any, to: any, recordTypeEnum: any, AccountID: any) => Promise<{
        data: any[];
        downloadData: any[];
    }>;
    doSyncCurrencyInRange: (from?: string, to?: string) => boolean;
    doGetUSDBaseValue: (currency: any, amount: any) => Promise<{
        value: number;
        status: boolean;
    }>;
    doGetCurrentConvertedCurrencyValue: (from: any, to: any, amount: any) => Promise<unknown>;
    mergeAnalyticsData(from: any, to: any, AccountID: any): Promise<any[]>;
    doStoreICon(payload: any): Promise<{
        status: boolean;
        data: any;
    }>;
}
