import { MiddlewareConsumer, Module, NestModule } from "@nestjs/common";
import { AppController } from "./app.controller";
import { AppService } from "./app.service";
import { DatabaseModule } from "./database/database.module";
import { AnalyticsReportModule } from "./AnalyticsReport/AnalyticsReport.module";
import { LoggerMiddleware } from "./middleware/logger.middleware";
import { LoggerService } from "./utils/logger.service";


@Module({
  imports: [DatabaseModule, AnalyticsReportModule],
  controllers: [AppController],
  providers: [AppService, LoggerService],
})
export class AppModule implements NestModule {
  configure(consumer: MiddlewareConsumer) {
    consumer.apply(LoggerMiddleware).forRoutes("*");
  }
}
