"use strict";
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var __metadata = (this && this.__metadata) || function (k, v) {
    if (typeof Reflect === "object" && typeof Reflect.metadata === "function") return Reflect.metadata(k, v);
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.ISignUpDto = void 0;
const class_validator_1 = require("class-validator");
class ISignUpDto {
}
exports.ISignUpDto = ISignUpDto;
__decorate([
    (0, class_validator_1.IsString)(),
    __metadata("design:type", String)
], ISignUpDto.prototype, "firstName", void 0);
__decorate([
    (0, class_validator_1.IsString)(),
    __metadata("design:type", String)
], ISignUpDto.prototype, "lastName", void 0);
__decorate([
    (0, class_validator_1.IsString)(),
    __metadata("design:type", String)
], ISignUpDto.prototype, "businessName", void 0);
__decorate([
    (0, class_validator_1.IsEmail)({}, { message: "Please provide a valid email address" }),
    (0, class_validator_1.IsString)(),
    __metadata("design:type", String)
], ISignUpDto.prototype, "email", void 0);
__decorate([
    (0, class_validator_1.IsNotEmpty)({ message: "Please Enter a password" }),
    (0, class_validator_1.IsString)(),
    (0, class_validator_1.MinLength)(8, { message: "Password length must be at least 8 characters" }),
    (0, class_validator_1.MaxLength)(60, { message: "Password length cannot exceed 60 characters" }),
    __metadata("design:type", String)
], ISignUpDto.prototype, "password", void 0);
__decorate([
    (0, class_validator_1.IsNotEmpty)(),
    (0, class_validator_1.Matches)(/^\+91[1-9]\d{9}$/, {
        message: "Invalid Indian phone number format (e.g., +919876543210)",
    }),
    __metadata("design:type", String)
], ISignUpDto.prototype, "smsNumber", void 0);
__decorate([
    (0, class_validator_1.IsString)(),
    __metadata("design:type", String)
], ISignUpDto.prototype, "website", void 0);
__decorate([
    (0, class_validator_1.IsString)(),
    __metadata("design:type", String)
], ISignUpDto.prototype, "businessType", void 0);
__decorate([
    (0, class_validator_1.IsString)(),
    __metadata("design:type", String)
], ISignUpDto.prototype, "aboutMyBusiness", void 0);
__decorate([
    (0, class_validator_1.IsString)(),
    __metadata("design:type", String)
], ISignUpDto.prototype, "myPerfectClient", void 0);
__decorate([
    (0, class_validator_1.IsString)(),
    __metadata("design:type", String)
], ISignUpDto.prototype, "deviceId", void 0);
//# sourceMappingURL=create-User.dto.js.map