"use strict";
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.EmailService = void 0;
const common_1 = require("@nestjs/common");
const nodemailer = require("nodemailer");
const ejs = require("ejs");
let EmailService = class EmailService {
    async sendMail(receiver, subject, content) {
        return await new Promise((resolve, reject) => {
            const transporter = nodemailer.createTransport({
                host: process.env.SMTP_HOST,
                port: process.env.SMTP_PORT,
                auth: {
                    user: process.env.SMTP_MAIL,
                    pass: process.env.SMTP_PASS,
                },
            });
            ejs.renderFile("src/email/template/note.ejs", { receiver, content }, (err, data) => {
                if (err) {
                    console.log(err);
                }
                else {
                    let mailOptions = {
                        from: "ronak.s@upsquare.in",
                        to: receiver,
                        subject: subject,
                        html: data,
                    };
                    transporter.sendMail(mailOptions, (error, info) => {
                        if (error) {
                            reject({ status: false, error: error });
                        }
                        else {
                            resolve({ status: true, message: info.messageId });
                        }
                    });
                }
            });
        });
    }
};
exports.EmailService = EmailService;
exports.EmailService = EmailService = __decorate([
    (0, common_1.Injectable)()
], EmailService);
//# sourceMappingURL=email.service.js.map