import { Injectable, Logger, NestMiddleware } from '@nestjs/common';
import { Request, Response, NextFunction } from 'express';
import { LoggerService } from "../utils/logger.service";

@Injectable()
export class LoggerMiddleware implements NestMiddleware {
    private logger = new Logger(`HTTP`);

    constructor(private loggerService: LoggerService) { }

    use(req: Request, res: Response, next: NextFunction) {
        this.logger.log(`REQUEST: ${req.method} PATH: ${req.originalUrl} IP: ${req.ip}  STATUS: ${res.statusCode} `,);

        this.loggerService.logApiCall(`${req.method}` + `${req.originalUrl}`);
        next();
    }
}

