import { Prop, Schema, SchemaFactory } from "@nestjs/mongoose";
import mongoose from "mongoose";
import { CurrentStage } from "src/enum/CurrentStage.enum";

@Schema()
export class AppleAccount {
  @Prop()
  AccountName: String;

  @Prop()
  VendorID: String;

  @Prop()
  PrivateKey: String;

  @Prop()
  Issuer: String;

  @Prop()
  KeyId: String;

  @Prop({ enum: CurrentStage, default: CurrentStage.STARTED })
  InitialSyncStatus: string;

  @Prop()
  SyncDate: String;

}

export const AppleAccountSchema = SchemaFactory.createForClass(AppleAccount);
