import { HttpService } from "@nestjs/axios";
import mongoose from "mongoose";
import { JwtService } from '@nestjs/jwt';
import { CurrencyValuation } from "src/models/CurrencyValuation.schema";
import { AnalyticsReport } from "src/models/AnalyticsReport.schema";
import { AppleAccount } from "src/models/AppleAccount.schema";
import { EventEmitter2 } from "@nestjs/event-emitter";
import { AnalyticsReportService } from "./AnalyticsReport.service";
import { LoggerService } from "src/utils/logger.service";
export declare class CronSyncService {
    private CurrencyValuationRepo;
    private analyticsReportRepo;
    private AppleAccountRepo;
    private analyticsService;
    private eventEmitter;
    private readonly httpService;
    private jwtService;
    private readonly LoggerService;
    CONST_REPORT_TYPES: {
        SALES: string;
        DOWNLOAD: string;
    };
    APPLEDATEFORMAT: string;
    DATEFORMAT: string;
    constructor(CurrencyValuationRepo: mongoose.Model<CurrencyValuation>, analyticsReportRepo: mongoose.Model<AnalyticsReport>, AppleAccountRepo: mongoose.Model<AppleAccount>, analyticsService: AnalyticsReportService, eventEmitter: EventEmitter2, httpService: HttpService, jwtService: JwtService, LoggerService: LoggerService);
    private readonly logger;
    handleDailyAppleReportsSync(): Promise<void>;
    doSyncCountryWisevaluation(): Promise<unknown>;
    doSyncReportInBatch(from: any, to: any, type: any, applevendor?: any): Promise<{
        status: boolean;
        count: number;
        result: {
            status: boolean;
            count?: number;
            error?: any;
            data?: any[];
        }[];
    }>;
    doHandleSyncReportInBatchAfterCredsSync(vendorID: any): Promise<void>;
    doSyncAnalyticsReport(ReportTYPE: any, date: any, applevendor?: any): Promise<{
        status: boolean;
        count?: number;
        error?: any;
        data?: any[];
    }>;
    doSyncHealth(): Promise<{
        status: boolean;
        code: number;
        message: string;
    }>;
    doHandleAccountsSyncing(file: any): Promise<any>;
    doSyncReportBatch(from: any, to: any, type: any, applevendor?: any): Promise<any[]>;
    doFetchVendors: () => Promise<{
        data: (mongoose.Document<unknown, {}, AppleAccount> & AppleAccount & {
            _id: mongoose.Types.ObjectId;
        })[];
        status: boolean;
    }>;
    doHandleDataExtractionFromZIP(FILE: any, hitDate: any, ReportTYPE: any, appleVendor?: any): Promise<{
        status: boolean;
        count?: number;
        error?: any;
        data: any[];
    }>;
    doGenerateTokenAPI({ iss, privateKey, keyId }: {
        iss: any;
        privateKey: any;
        keyId: any;
    }): Promise<any>;
    doFetchReports(baseUrl: any, accountRecord?: any): Promise<{
        status: boolean;
        data: any;
        code: number;
        message: string;
    } | {
        status: boolean;
        data: any[];
        message: any;
        code: any;
        error: any;
    }>;
    generateJWT: ({ privateKey, iss, KeyId }: {
        privateKey: any;
        iss: any;
        KeyId: any;
    }) => Promise<{
        access_token: string;
    }>;
    doGetReportsUrl(type: any, gDate: any, appleVendor: any): string;
    convertCurrencyValue(from: string, to: string): Promise<{
        status: boolean;
        from: string;
        to: string;
        rate: any;
        value: any;
        date: any;
        message?: undefined;
        error?: undefined;
    } | {
        status: boolean;
        message: string;
        from?: undefined;
        to?: undefined;
        rate?: undefined;
        value?: undefined;
        date?: undefined;
        error?: undefined;
    } | {
        status: boolean;
        message: string;
        error: any;
        from?: undefined;
        to?: undefined;
        rate?: undefined;
        value?: undefined;
        date?: undefined;
    }>;
    enumerateDaysBetweenDates(startDate: any, endDate: any): any[];
    doGetUSDBaseValue: (Currency: any, amount: any) => Promise<{
        value: number;
        status: boolean;
    }>;
}
