"use strict";
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var __metadata = (this && this.__metadata) || function (k, v) {
    if (typeof Reflect === "object" && typeof Reflect.metadata === "function") return Reflect.metadata(k, v);
};
var __param = (this && this.__param) || function (paramIndex, decorator) {
    return function (target, key) { decorator(target, key, paramIndex); }
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.AnalyticsReportController = void 0;
const common_1 = require("@nestjs/common");
const platform_express_1 = require("@nestjs/platform-express");
const AnalyticsReport_service_1 = require("./AnalyticsReport.service");
const moment = require("moment");
const CronSyncService_service_1 = require("./CronSyncService.service");
const AnalyticsReport_schema_1 = require("../models/AnalyticsReport.schema");
let AnalyticsReportController = class AnalyticsReportController {
    constructor(analyticsService, CronSyncService) {
        this.analyticsService = analyticsService;
        this.CronSyncService = CronSyncService;
    }
    async SyncDownloadReports() {
        try {
            return this.CronSyncService.doSyncAnalyticsReport(AnalyticsReport_schema_1.recordTypeEnum.DOWNLOAD, null);
        }
        catch (error) {
            throw new common_1.HttpException(error, 400);
        }
    }
    async allVendor() {
        try {
            return this.analyticsService.doGetVendorList();
        }
        catch (error) {
            throw new common_1.HttpException(error, 400);
        }
    }
    async SyncSalesReports() {
        try {
            return this.CronSyncService.doSyncAnalyticsReport(AnalyticsReport_schema_1.recordTypeEnum.SALES, null);
        }
        catch (error) {
            throw new common_1.HttpException(error, 400);
        }
    }
    async Synchealth() {
        try {
            return this.CronSyncService.doSyncHealth();
        }
        catch (error) {
            throw new common_1.HttpException(error, 400);
        }
    }
    async SyncCredentials(file) {
        return await this.CronSyncService.doHandleAccountsSyncing(file);
    }
    async doFetchCredentials() {
        return await this.CronSyncService.doFetchVendors();
    }
    async SyncSalesReportsBatch({ type }, { from, to }) {
        try {
            const isDateValid = (date) => moment(date, "DD-MM-YYYY").isValid() && date?.length == 10;
            if (isDateValid(from) == false) {
                return {
                    status: false,
                    code: 422,
                    message: "From is not invalid format!"
                };
            }
            if (isDateValid(to) == false) {
                return {
                    status: false,
                    code: 422,
                    message: "To is not invalid format!"
                };
            }
            if (type !== AnalyticsReport_schema_1.recordTypeEnum.DOWNLOAD.toLowerCase() && type !== AnalyticsReport_schema_1.recordTypeEnum.SALES.toLowerCase()) {
                return {
                    status: false,
                    code: 422,
                    message: "Type is not valid!"
                };
            }
            return this.CronSyncService.doSyncReportInBatch(from, to, type.toUpperCase());
        }
        catch (error) {
            throw new common_1.HttpException(error, 400);
        }
    }
    async doGetJWTTOken() {
        try {
            return this.analyticsService.generateJWT();
        }
        catch (error) {
            throw new common_1.HttpException(error, 400);
        }
    }
    async country() {
        try {
            return this.analyticsService.doHandleParsingCSV();
        }
        catch (error) {
            throw new common_1.HttpException(error, 400);
        }
    }
    async SyncExchangeRate() {
        try {
            return await this.CronSyncService.doSyncCountryWisevaluation();
        }
        catch (error) {
            throw new common_1.HttpException(error, 400);
        }
    }
    async GetAnalytics(body) {
        try {
            let { type, from, to, AccountID } = body;
            if (!AccountID || AccountID.length === 0) {
                return {
                    status: false,
                    code: 422,
                    message: "AccountID is rquired!"
                };
            }
            const isDateValid = (date) => moment(date, "DD-MM-YYYY").isValid() && date?.length == 10;
            if (isDateValid(from) == false) {
                return {
                    status: false,
                    code: 422,
                    message: "From is not invalid format!"
                };
            }
            if (isDateValid(to) == false) {
                return {
                    status: false,
                    code: 422,
                    message: "To is not invalid format!"
                };
            }
            return await this.analyticsService.analysticsData(from, to, AnalyticsReport_schema_1.recordTypeEnum, AccountID);
        }
        catch (error) {
            console.log(error);
            throw new common_1.HttpException(error, 400);
        }
    }
    async mergeAnalyticsData(body) {
        try {
            let { from, to, AccountID } = body;
            return await this.analyticsService.mergeAnalyticsData(from, to, AccountID);
        }
        catch (error) {
            console.log(error, 'error');
        }
    }
    async storeIcon(id) {
        try {
            return await this.analyticsService.doStoreICon(id);
        }
        catch (error) {
            console.log(error, 'error');
        }
    }
};
exports.AnalyticsReportController = AnalyticsReportController;
__decorate([
    (0, common_1.Get)("/sync/download"),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", []),
    __metadata("design:returntype", Promise)
], AnalyticsReportController.prototype, "SyncDownloadReports", null);
__decorate([
    (0, common_1.Get)("/list"),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", []),
    __metadata("design:returntype", Promise)
], AnalyticsReportController.prototype, "allVendor", null);
__decorate([
    (0, common_1.Get)("/sync/sales"),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", []),
    __metadata("design:returntype", Promise)
], AnalyticsReportController.prototype, "SyncSalesReports", null);
__decorate([
    (0, common_1.Get)("/sync/healthcheal"),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", []),
    __metadata("design:returntype", Promise)
], AnalyticsReportController.prototype, "Synchealth", null);
__decorate([
    (0, common_1.Post)('sync/apps'),
    (0, common_1.UseInterceptors)((0, platform_express_1.FileInterceptor)('AppFile')),
    __param(0, (0, common_1.UploadedFile)(new common_1.ParseFilePipe({
        validators: [new common_1.FileTypeValidator({ fileType: '.csv' })],
        fileIsRequired: true,
    }))),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [Object]),
    __metadata("design:returntype", Promise)
], AnalyticsReportController.prototype, "SyncCredentials", null);
__decorate([
    (0, common_1.Get)('sync/apps'),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", []),
    __metadata("design:returntype", Promise)
], AnalyticsReportController.prototype, "doFetchCredentials", null);
__decorate([
    (0, common_1.Get)("/sync/b/:type"),
    __param(0, (0, common_1.Param)()),
    __param(1, (0, common_1.Query)()),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [Object, Object]),
    __metadata("design:returntype", Promise)
], AnalyticsReportController.prototype, "SyncSalesReportsBatch", null);
__decorate([
    (0, common_1.Get)("/token"),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", []),
    __metadata("design:returntype", Promise)
], AnalyticsReportController.prototype, "doGetJWTTOken", null);
__decorate([
    (0, common_1.Get)("/country"),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", []),
    __metadata("design:returntype", Promise)
], AnalyticsReportController.prototype, "country", null);
__decorate([
    (0, common_1.Get)("/sync/exchange-rate"),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", []),
    __metadata("design:returntype", Promise)
], AnalyticsReportController.prototype, "SyncExchangeRate", null);
__decorate([
    (0, common_1.Post)("/analytics"),
    __param(0, (0, common_1.Body)()),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [Object]),
    __metadata("design:returntype", Promise)
], AnalyticsReportController.prototype, "GetAnalytics", null);
__decorate([
    (0, common_1.Post)('/merge'),
    __param(0, (0, common_1.Body)()),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [Object]),
    __metadata("design:returntype", Promise)
], AnalyticsReportController.prototype, "mergeAnalyticsData", null);
__decorate([
    (0, common_1.Get)('/iconList/:id'),
    __param(0, (0, common_1.Param)('id')),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [String]),
    __metadata("design:returntype", Promise)
], AnalyticsReportController.prototype, "storeIcon", null);
exports.AnalyticsReportController = AnalyticsReportController = __decorate([
    (0, common_1.Controller)("asr"),
    __metadata("design:paramtypes", [AnalyticsReport_service_1.AnalyticsReportService,
        CronSyncService_service_1.CronSyncService])
], AnalyticsReportController);
//# sourceMappingURL=AnalyticsReport.controller.js.map