"use strict";
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.LoggerService = void 0;
const common_1 = require("@nestjs/common");
const fs = require("fs");
let LoggerService = class LoggerService {
    constructor() {
        this.logger = new common_1.Logger('LoggerService');
    }
    logApiCall(apiName) {
        const timestamp = this.formatDate(new Date());
        this.log(`${apiName} at ${timestamp}`);
    }
    log(apiName) {
        this.logger.log(apiName);
        const logData = `\n
                        ${apiName}\n \n
                        =================================\n`;
        fs.appendFile('./vendor-log.txt', `${logData}\n`, (err) => {
            if (err) {
                console.error('Error writing to log file:', err);
            }
        });
    }
    formatDate(date) {
        const year = date.getFullYear();
        const month = ('0' + (date.getMonth() + 1)).slice(-2);
        const day = ('0' + date.getDate()).slice(-2);
        const hours = ('0' + date.getHours()).slice(-2);
        const minutes = ('0' + date.getMinutes()).slice(-2);
        const seconds = ('0' + date.getSeconds()).slice(-2);
        return `${month}-${day}-${year} ${hours}:${minutes}:${seconds}`;
    }
};
exports.LoggerService = LoggerService;
exports.LoggerService = LoggerService = __decorate([
    (0, common_1.Injectable)()
], LoggerService);
//# sourceMappingURL=logger.service.js.map