/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.coref.fastneural;

import edu.stanford.nlp.coref.CorefAlgorithm;
import edu.stanford.nlp.coref.CorefProperties;
import edu.stanford.nlp.coref.CorefUtils;
import edu.stanford.nlp.coref.data.Dictionaries;
import edu.stanford.nlp.coref.data.Document;
import edu.stanford.nlp.coref.fastneural.FastNeuralCorefModel;
import edu.stanford.nlp.coref.fastneural.FastNeuralCorefProperties;
import edu.stanford.nlp.coref.statistical.Compressor;
import edu.stanford.nlp.coref.statistical.DocumentExamples;
import edu.stanford.nlp.coref.statistical.Example;
import edu.stanford.nlp.coref.statistical.FeatureExtractor;
import edu.stanford.nlp.coref.statistical.StatisticalCorefProperties;
import edu.stanford.nlp.io.IOUtils;
import edu.stanford.nlp.stats.ClassicCounter;
import edu.stanford.nlp.util.Pair;
import edu.stanford.nlp.util.RuntimeInterruptedException;
import edu.stanford.nlp.util.logging.Redwood;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.ejml.simple.SimpleMatrix;

public class FastNeuralCorefAlgorithm
implements CorefAlgorithm {
    private static Redwood.RedwoodChannels log = Redwood.channels(FastNeuralCorefAlgorithm.class);
    private final double greedyness;
    private final int maxMentionDistance;
    private final int maxMentionDistanceWithStringMatch;
    private final FeatureExtractor featureExtractor;
    private final FastNeuralCorefModel model;

    public FastNeuralCorefAlgorithm(Properties props, Dictionaries dictionaries) {
        this.greedyness = FastNeuralCorefProperties.greedyness(props);
        this.maxMentionDistance = CorefProperties.maxMentionDistance(props);
        this.maxMentionDistanceWithStringMatch = CorefProperties.maxMentionDistanceWithStringMatch(props);
        this.featureExtractor = new FeatureExtractor(props, dictionaries, null, StatisticalCorefProperties.wordCountsPath(props));
        this.model = (FastNeuralCorefModel)IOUtils.readObjectAnnouncingTimingFromURLOrClasspathOrFileSystem(log, "Loading coref model...", FastNeuralCorefProperties.modelPath(props));
    }

    @Override
    public void runCoref(Document document) {
        Map<Integer, List<Integer>> mentionToCandidateAntecedents = CorefUtils.heuristicFilter(CorefUtils.getSortedMentions(document), this.maxMentionDistance, this.maxMentionDistanceWithStringMatch);
        HashMap<Pair<Integer, Integer>, Boolean> mentionPairs = new HashMap<Pair<Integer, Integer>, Boolean>();
        for (Map.Entry<Integer, List<Integer>> e : mentionToCandidateAntecedents.entrySet()) {
            for (int m1 : e.getValue()) {
                mentionPairs.put(new Pair<Integer, Integer>(m1, e.getKey()), true);
            }
        }
        Compressor<String> compressor = new Compressor<String>();
        DocumentExamples examples = this.featureExtractor.extract(0, document, mentionPairs, compressor);
        ClassicCounter<Pair<Integer, Integer>> pairwiseScores = new ClassicCounter<Pair<Integer, Integer>>();
        HashMap<Integer, SimpleMatrix> antecedentCache = new HashMap<Integer, SimpleMatrix>();
        HashMap<Integer, SimpleMatrix> anaphorCache = new HashMap<Integer, SimpleMatrix>();
        for (Example example : examples.examples) {
            if (Thread.interrupted()) {
                throw new RuntimeInterruptedException();
            }
            pairwiseScores.incrementCount(new Pair<Integer, Integer>(example.mentionId1, example.mentionId2), this.model.score(document.predictedMentionsByID.get(example.mentionId1), document.predictedMentionsByID.get(example.mentionId2), compressor.uncompress(examples.mentionFeatures.get(example.mentionId1)), compressor.uncompress(examples.mentionFeatures.get(example.mentionId2)), compressor.uncompress(example.pairwiseFeatures), antecedentCache, anaphorCache));
        }
        Iterator<Object> iterator = mentionToCandidateAntecedents.keySet().iterator();
        while (iterator.hasNext()) {
            int n = (Integer)iterator.next();
            if (Thread.interrupted()) {
                throw new RuntimeInterruptedException();
            }
            pairwiseScores.incrementCount(new Pair<Integer, Integer>(-1, n), this.model.score(null, document.predictedMentionsByID.get(n), null, compressor.uncompress(examples.mentionFeatures.get(n)), null, antecedentCache, anaphorCache));
        }
        for (Map.Entry entry : mentionToCandidateAntecedents.entrySet()) {
            int antecedent = -1;
            int anaphor = (Integer)entry.getKey();
            double bestScore = pairwiseScores.getCount(new Pair<Integer, Integer>(-1, anaphor)) - 50.0 * (this.greedyness - 0.5);
            Iterator iterator2 = ((List)entry.getValue()).iterator();
            while (iterator2.hasNext()) {
                int ca = (Integer)iterator2.next();
                double score = pairwiseScores.getCount(new Pair<Integer, Integer>(ca, anaphor));
                if (!(score > bestScore)) continue;
                bestScore = score;
                antecedent = ca;
            }
            if (antecedent <= 0) continue;
            CorefUtils.mergeCoreferenceClusters(new Pair<Integer, Integer>(antecedent, anaphor), document);
        }
    }
}

