/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.ie.machinereading.domains.ace.reader;

import edu.stanford.nlp.ie.machinereading.domains.ace.reader.AceElement;
import edu.stanford.nlp.ie.machinereading.domains.ace.reader.AceToken;
import edu.stanford.nlp.ie.machinereading.domains.ace.reader.MatchException;
import edu.stanford.nlp.trees.Span;
import edu.stanford.nlp.util.logging.Redwood;
import java.util.Vector;

public class AceCharSeq {
    private static Redwood.RedwoodChannels log = Redwood.channels(AceCharSeq.class);
    private String mText;
    private Span mByteOffset;
    private Span mTokenOffset;

    public AceCharSeq(String text, int start, int end) {
        this.mText = text;
        this.mByteOffset = new Span(start, end);
        this.mTokenOffset = null;
    }

    public String toXml(String label, int offset) {
        StringBuilder builder = new StringBuilder();
        AceElement.appendOffset(builder, offset);
        builder.append('<').append(label).append(">\n");
        AceElement.appendOffset(builder, offset + 2);
        builder.append("<charseq START=\"").append(this.mByteOffset.start()).append("\" END=\"").append(this.mByteOffset.end()).append("\">");
        builder.append(this.mText).append("</charseq>");
        builder.append('\n');
        AceElement.appendOffset(builder, offset);
        builder.append("</").append(label).append('>');
        return builder.toString();
    }

    public String toXml(int offset) {
        StringBuilder builder = new StringBuilder();
        AceElement.appendOffset(builder, offset + 2);
        builder.append("<charseq START=\"").append(this.mByteOffset.start()).append("\" END=\"").append(this.mByteOffset.end()).append("\">");
        builder.append(this.mText).append("</charseq>");
        return builder.toString();
    }

    public String getText() {
        return this.mText;
    }

    public int getByteStart() {
        return this.mByteOffset.start();
    }

    public int getByteEnd() {
        return this.mByteOffset.end();
    }

    public Span getByteOffset() {
        return this.mByteOffset;
    }

    public int getTokenStart() {
        if (this.mTokenOffset == null) {
            return -1;
        }
        return this.mTokenOffset.start();
    }

    public int getTokenEnd() {
        if (this.mTokenOffset == null) {
            return -1;
        }
        return this.mTokenOffset.end();
    }

    public Span getTokenOffset() {
        return this.mTokenOffset;
    }

    public void match(Vector<AceToken> tokens) throws MatchException {
        int start = -1;
        int end = -1;
        for (int i = 0; i < tokens.size(); ++i) {
            if (tokens.get(i).getByteOffset().start() == this.mByteOffset.start()) {
                start = i;
            } else if (this.mByteOffset.start() > tokens.get(i).getByteOffset().start() && this.mByteOffset.start() < tokens.get(i).getByteOffset().end()) {
                start = i;
            }
            if (tokens.get(i).getByteOffset().end() == this.mByteOffset.end() + 1) {
                end = i;
                break;
            }
            if (this.mByteOffset.end() < tokens.get(i).getByteOffset().start() || this.mByteOffset.end() >= tokens.get(i).getByteOffset().end() - 1) continue;
            end = i;
            break;
        }
        if (start < 0 || end < 0) {
            throw new MatchException("Match failed!");
        }
        this.mTokenOffset = new Span(start, end);
    }

    public String toString() {
        return "AceCharSeq [mByteOffset=" + this.mByteOffset + ", mText=" + this.mText + ", mTokenOffset=" + this.mTokenOffset + ']';
    }
}

