/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.ie.machinereading.domains.ace.reader;

import edu.stanford.nlp.ie.machinereading.domains.ace.reader.AceElement;
import edu.stanford.nlp.ie.machinereading.domains.ace.reader.AceEntityMention;
import edu.stanford.nlp.ie.machinereading.domains.ace.reader.AceToken;
import java.util.ArrayList;
import java.util.List;

public class AceEntity
extends AceElement {
    private String mType;
    private String mSubtype;
    private String mClass;
    private List<AceEntityMention> mMentions;

    public AceEntity(String id, String type, String subtype, String cls) {
        super(id);
        this.mType = type;
        this.mSubtype = subtype;
        this.mClass = cls;
        this.mMentions = new ArrayList<AceEntityMention>();
    }

    public void addMention(AceEntityMention m) {
        this.mMentions.add(m);
        m.setParent(this);
    }

    public List<AceEntityMention> getMentions() {
        return this.mMentions;
    }

    public String getType() {
        return this.mType;
    }

    public void setType(String s) {
        this.mType = s;
    }

    public String getSubtype() {
        return this.mSubtype;
    }

    public void setSubtype(String s) {
        this.mSubtype = s;
    }

    public void setClass(String s) {
        this.mClass = s;
    }

    public String getClasss() {
        return this.mClass;
    }

    public String toXml(int offset) {
        StringBuilder buffer = new StringBuilder();
        AceEntity.appendOffset(buffer, offset);
        buffer.append("<entity ID=\"" + this.getId() + "\" TYPE =\"" + AceToken.OTHERS.get(this.mType) + "\" SUBTYPE=\"" + AceToken.OTHERS.get(this.mSubtype) + "\" CLASS=\"" + AceToken.OTHERS.get(this.mClass) + "\">\n");
        for (AceEntityMention m : this.mMentions) {
            buffer.append(m.toXml(offset + 2));
            buffer.append("\n");
        }
        AceEntity.appendOffset(buffer, offset);
        buffer.append("</entity>");
        return buffer.toString();
    }
}

