/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.ie.machinereading.structure;

import edu.stanford.nlp.ie.machinereading.structure.ExtractionObject;
import edu.stanford.nlp.ie.machinereading.structure.MachineReadingAnnotations;
import edu.stanford.nlp.ie.machinereading.structure.RelationMention;
import edu.stanford.nlp.ie.machinereading.structure.Span;
import edu.stanford.nlp.ling.CoreAnnotations;
import edu.stanford.nlp.ling.CoreLabel;
import edu.stanford.nlp.util.CoreMap;
import edu.stanford.nlp.util.IdentityHashSet;
import edu.stanford.nlp.util.logging.Redwood;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Set;

public class EventMention
extends RelationMention {
    private static Redwood.RedwoodChannels log = Redwood.channels(EventMention.class);
    private static final long serialVersionUID = 1L;
    private String eventModification;
    private final ExtractionObject anchor;
    private Set<ExtractionObject> parents;

    public EventMention(String objectId, CoreMap sentence, Span span, String type, String subtype, ExtractionObject anchor, List<ExtractionObject> args, List<String> argNames) {
        super(objectId, sentence, span, type, subtype, args, argNames);
        this.anchor = anchor;
        this.parents = new IdentityHashSet<ExtractionObject>();
        for (ExtractionObject arg : args) {
            if (!(arg instanceof EventMention)) continue;
            ((EventMention)arg).addParent(this);
        }
    }

    public void resetArguments() {
        this.args = new ArrayList();
        this.argNames = new ArrayList();
    }

    public void removeFromParents() {
        for (ExtractionObject parent : this.parents) {
            if (!(parent instanceof RelationMention)) continue;
            ((RelationMention)parent).removeArgument(this, false);
        }
        this.parents.clear();
    }

    public void removeParent(ExtractionObject p) {
        this.parents.remove(p);
    }

    public String getModification() {
        return this.eventModification;
    }

    public void setModification(String eventModification) {
        this.eventModification = eventModification;
    }

    public ExtractionObject getAnchor() {
        return this.anchor;
    }

    public Set<ExtractionObject> getParents() {
        return this.parents;
    }

    public ExtractionObject getSingleParent(CoreMap sentence) {
        if (this.getParents().size() > 1) {
            Set<ExtractionObject> parents = this.getParents();
            log.info("This event has multiple parents: " + this);
            int count = 1;
            for (ExtractionObject po : parents) {
                log.info("PARENT #" + count + ": " + po);
                ++count;
            }
            log.info("DOC " + (String)sentence.get(CoreAnnotations.DocIDAnnotation.class));
            log.info("SENTENCE:");
            for (CoreLabel t : (List)sentence.get(CoreAnnotations.TokensAnnotation.class)) {
                log.info(" " + t.word());
            }
            log.info("EVENTS IN SENTENCE:");
            count = 1;
            for (EventMention e : (List)sentence.get(MachineReadingAnnotations.EventMentionsAnnotation.class)) {
                log.info("EVENT #" + count + ": " + e);
                ++count;
            }
        }
        assert (this.getParents().size() <= 1);
        Iterator<ExtractionObject> iterator = this.getParents().iterator();
        if (iterator.hasNext()) {
            ExtractionObject p = iterator.next();
            return p;
        }
        return null;
    }

    public void addParent(EventMention p) {
        this.parents.add(p);
    }

    @Override
    public String toString() {
        return "EventMention [objectId=" + this.getObjectId() + ", type=" + this.type + ", subType=" + this.subType + ", start=" + this.getExtentTokenStart() + ", end=" + this.getExtentTokenEnd() + (this.anchor != null ? ", anchor=" + this.anchor : "") + (this.args != null ? ", args=" + this.args : "") + (this.argNames != null ? ", argNames=" + this.argNames : "") + "]";
    }

    public boolean contains(EventMention e) {
        if (this == e) {
            return true;
        }
        for (ExtractionObject a : this.getArgs()) {
            EventMention ea;
            if (!(a instanceof EventMention) || !(ea = (EventMention)a).contains(e)) continue;
            return true;
        }
        return false;
    }

    public void addArg(ExtractionObject a, String an, boolean discardSameArgDifferentName) {
        for (int i = 0; i < this.getArgs().size(); ++i) {
            ExtractionObject myArg = this.getArg(i);
            String myArgName = this.getArgNames().get(i);
            if (myArg != a) continue;
            if (myArgName.equals(an)) {
                return;
            }
            logger.info("Trying to add one argument: " + a + " with name " + an + " when this already exists with a different name: " + this + " in sentence: " + (String)this.getSentence().get(CoreAnnotations.TextAnnotation.class));
            if (!discardSameArgDifferentName) continue;
            return;
        }
        this.args.add(a);
        this.argNames.add(an);
        if (a instanceof EventMention) {
            ((EventMention)a).addParent(this);
        }
    }

    @Override
    public void setArgs(List<ExtractionObject> args) {
        this.args = args;
        for (ExtractionObject arg : args) {
            if (!(arg instanceof EventMention)) continue;
            ((EventMention)arg).addParent(this);
        }
    }

    public void addArgs(List<ExtractionObject> args, List<String> argNames, boolean discardSameArgDifferentName) {
        if (args == null) {
            return;
        }
        assert (args.size() == argNames.size());
        for (int i = 0; i < args.size(); ++i) {
            this.addArg(args.get(i), argNames.get(i), discardSameArgDifferentName);
        }
    }

    public void mergeEvent(EventMention e, boolean discardSameArgDifferentName) {
        String oldType = this.type;
        this.type = ExtractionObject.concatenateTypes(this.type, e.getType());
        if (!this.type.equals(oldType)) {
            logger.fine("Type changed from " + oldType + " to " + this.type + " during check 3 merge.");
        }
        for (int i = 0; i < e.getArgs().size(); ++i) {
            ExtractionObject a = e.getArg(i);
            String an = e.getArgNames().get(i);
            if (a instanceof EventMention && ((EventMention)a).contains(this)) {
                logger.info("Found event cycle during merge between e1 " + this + " and e2 " + e);
                continue;
            }
            if (a instanceof EventMention) {
                ((EventMention)a).removeParent(e);
            }
            this.addArg(a, an, discardSameArgDifferentName);
        }
        e.resetArguments();
        e.removeFromParents();
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof EventMention)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        EventMention that = (EventMention)o;
        if (this.anchor != null ? !this.anchor.equals(that.anchor) : that.anchor != null) {
            return false;
        }
        if (this.eventModification != null ? !this.eventModification.equals(that.eventModification) : that.eventModification != null) {
            return false;
        }
        return !(this.parents != null ? !this.parents.equals(that.parents) : that.parents != null);
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + (this.eventModification != null ? this.eventModification.hashCode() : 0);
        result = 31 * result + (this.anchor != null ? this.anchor.hashCode() : 0);
        return result;
    }
}

