/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.parser.lexparser;

import edu.stanford.nlp.ling.HasWord;
import edu.stanford.nlp.ling.Word;
import edu.stanford.nlp.parser.lexparser.AbstractCollinizer;
import edu.stanford.nlp.parser.lexparser.AbstractTreebankParserParams;
import edu.stanford.nlp.parser.lexparser.TreeCollinizer;
import edu.stanford.nlp.trees.HeadFinder;
import edu.stanford.nlp.trees.LeftHeadFinder;
import edu.stanford.nlp.trees.PennTreeReaderFactory;
import edu.stanford.nlp.trees.Tree;
import edu.stanford.nlp.trees.TreeNormalizer;
import edu.stanford.nlp.trees.TreeReaderFactory;
import edu.stanford.nlp.trees.international.italian.ItalianTreebankLanguagePack;
import edu.stanford.nlp.util.StringUtils;
import edu.stanford.nlp.util.logging.Redwood;
import java.util.ArrayList;
import java.util.List;

public class ItalianTreebankParserParams
extends AbstractTreebankParserParams {
    private static final Redwood.RedwoodChannels log = Redwood.channels(ItalianTreebankParserParams.class);
    private HeadFinder headFinder = new LeftHeadFinder();
    private TreeNormalizer normalizer = null;
    static final String[] EMPTY_SISTERS = new String[0];
    private static final long serialVersionUID = 9824524678L;

    public ItalianTreebankParserParams() {
        super(new ItalianTreebankLanguagePack());
    }

    @Override
    public HeadFinder headFinder() {
        return this.headFinder;
    }

    @Override
    public HeadFinder typedDependencyHeadFinder() {
        return this.headFinder;
    }

    @Override
    public AbstractCollinizer collinizer() {
        return new TreeCollinizer(this.tlp, true, false, 0);
    }

    @Override
    public AbstractCollinizer collinizerEvalb() {
        return this.collinizer();
    }

    @Override
    public String[] sisterSplitters() {
        return EMPTY_SISTERS;
    }

    @Override
    public Tree transformTree(Tree t, Tree root) {
        return t;
    }

    TreeNormalizer buildNormalizer() {
        return new ItalianSubcategoryStripper();
    }

    @Override
    public TreeReaderFactory treeReaderFactory() {
        if (this.normalizer == null) {
            this.normalizer = this.buildNormalizer();
        }
        return new PennTreeReaderFactory(this.normalizer);
    }

    @Override
    public void display() {
        String params = "Using ItalianTreebankParserParams";
        log.info(params);
    }

    @Override
    public List<? extends HasWord> defaultTestSentence() {
        String[] sent;
        ArrayList<Word> ret = new ArrayList<Word>();
        for (String str : sent = new String[]{"Questo", "\u00e8", "un", "test", "."}) {
            ret.add(new Word(str));
        }
        return ret;
    }

    public static class ItalianSubcategoryStripper
    extends TreeNormalizer {
        @Override
        public String normalizeNonterminal(String category) {
            List<String> pieces = StringUtils.split(category, "~");
            return pieces.get(0);
        }
    }
}

