/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.parser.lexparser;

import edu.stanford.nlp.parser.lexparser.AbstractCollinizer;
import edu.stanford.nlp.trees.Tree;
import edu.stanford.nlp.trees.TreeFactory;
import edu.stanford.nlp.trees.TreebankLanguagePack;
import edu.stanford.nlp.trees.Trees;
import java.util.ArrayList;
import java.util.Iterator;

public class TreeCollinizer
implements AbstractCollinizer {
    private final TreebankLanguagePack tlp;
    private final boolean deletePunct;
    private final boolean fixCollinsBaseNP;
    private final int whOption;

    public TreeCollinizer(TreebankLanguagePack tlp) {
        this(tlp, true, false);
    }

    public TreeCollinizer(TreebankLanguagePack tlp, boolean deletePunct, boolean fixCollinsBaseNP) {
        this(tlp, deletePunct, fixCollinsBaseNP, 0);
    }

    public TreeCollinizer(TreebankLanguagePack tlp, boolean deletePunct, boolean fixCollinsBaseNP, int whOption) {
        this.tlp = tlp;
        this.deletePunct = deletePunct;
        this.fixCollinsBaseNP = fixCollinsBaseNP;
        this.whOption = whOption;
    }

    public String toString() {
        return "TreeCollinizer(tlp: " + this.tlp.getClass() + ", deletePunct: " + this.deletePunct + ", fixCollinsBaseNP: " + this.fixCollinsBaseNP + ", whOption: " + this.whOption + ")";
    }

    @Override
    public Tree transformTree(Tree guess, Tree gold) {
        if (guess == null || gold == null) {
            return null;
        }
        if (guess.yield().size() != gold.yield().size()) {
            return null;
        }
        return this.transformTree(guess, Trees.preTerminals(gold).iterator());
    }

    private String simplifyCategory(String s) {
        s = this.tlp.basicCategory(s);
        if ((this.whOption & 1) != 0 && s.startsWith("WH")) {
            s = s.substring(2);
        }
        if ((this.whOption & 2) != 0) {
            s = s.replaceAll("^WP", "PRP");
            s = s.replaceAll("^WDT", "DT");
            s = s.replaceAll("^WRB", "RB");
        }
        if ((this.whOption & 4) != 0 && s.startsWith("WH")) {
            s = s.substring(2);
        }
        return s;
    }

    private Tree transformTree(Tree guess, Iterator<Tree> goldPreterminals) {
        Tree[] kids;
        if (guess == null) {
            return null;
        }
        TreeFactory tf = guess.treeFactory();
        String s = guess.value();
        if (this.tlp.isStartSymbol(s)) {
            return this.transformTree(guess.firstChild(), goldPreterminals);
        }
        if (guess.isLeaf()) {
            return tf.newLeaf(guess.label());
        }
        s = this.simplifyCategory(s);
        if (this.deletePunct && guess.isPreTerminal()) {
            Tree goldPT = goldPreterminals.next();
            String goldCategory = goldPT.value();
            if (this.tlp.isEvalBIgnoredPunctuationTag(goldCategory = this.simplifyCategory(goldCategory)) || this.tlp.isPunctuationWord(goldPT.firstChild().value())) {
                return null;
            }
        }
        if (this.fixCollinsBaseNP && s.equals("NP") && (kids = guess.children()).length == 1 && this.tlp.basicCategory(kids[0].value()).equals("NP")) {
            return this.transformTree(kids[0], goldPreterminals);
        }
        if (s.equals("PRT")) {
            s = "ADVP";
        }
        ArrayList<Tree> children = new ArrayList<Tree>();
        int numKids = guess.numChildren();
        for (int cNum = 0; cNum < numKids; ++cNum) {
            Tree child = guess.children()[cNum];
            Tree newChild = this.transformTree(child, goldPreterminals);
            if (newChild == null) continue;
            children.add(newChild);
        }
        if (children.isEmpty()) {
            return null;
        }
        Tree node = tf.newTreeNode(guess.label(), children);
        node.setValue(s);
        return node;
    }
}

