/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.parser.metrics;

import edu.stanford.nlp.ling.CoreLabel;
import edu.stanford.nlp.ling.SentenceUtils;
import edu.stanford.nlp.parser.common.ParserQuery;
import edu.stanford.nlp.parser.lexparser.Options;
import edu.stanford.nlp.parser.metrics.EvaluateTreebank;
import edu.stanford.nlp.parser.metrics.ExternalParserQuery;
import edu.stanford.nlp.pipeline.CoreNLPProtos;
import edu.stanford.nlp.pipeline.ProtobufAnnotationSerializer;
import edu.stanford.nlp.trees.Tree;
import edu.stanford.nlp.util.Pair;
import edu.stanford.nlp.util.ProcessProtobufRequest;
import edu.stanford.nlp.util.ScoredObject;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;

public class EvaluateExternalParser
extends ProcessProtobufRequest {
    final Options op = new Options();

    public EvaluateExternalParser(String ... args) {
        this.op.setOptions("-quietEvaluation");
        this.op.setOptions(args);
    }

    public static List<Tree> getGoldTrees(CoreNLPProtos.EvaluateParserRequest parses) {
        ArrayList<Tree> trees = new ArrayList<Tree>();
        for (CoreNLPProtos.EvaluateParserRequest.ParseResult parse : parses.getTreebankList()) {
            CoreNLPProtos.FlattenedParseTree gold = parse.getGold();
            trees.add(ProtobufAnnotationSerializer.fromProto(gold));
        }
        return trees;
    }

    public static List<List<Tree>> getResults(CoreNLPProtos.EvaluateParserRequest parses) {
        ArrayList<List<Tree>> results = new ArrayList<List<Tree>>();
        for (CoreNLPProtos.EvaluateParserRequest.ParseResult parse : parses.getTreebankList()) {
            List trees = parse.getPredictedList().stream().map(ProtobufAnnotationSerializer::fromProto).collect(Collectors.toList());
            results.add(trees);
        }
        return results;
    }

    public List<Pair<ParserQuery, Tree>> convertDataset(List<Tree> goldTrees, List<List<Tree>> results) {
        ArrayList<Pair<ParserQuery, Tree>> dataset = new ArrayList<Pair<ParserQuery, Tree>>();
        if (goldTrees.size() != results.size()) {
            throw new AssertionError((Object)"The lists should always be of the same length at this point");
        }
        for (int i = 0; i < goldTrees.size(); ++i) {
            Tree gold = goldTrees.get(i);
            List<CoreLabel> sentence = SentenceUtils.toCoreLabelList(gold.yieldWords());
            ArrayList<ScoredObject<Tree>> scoredResult = new ArrayList<ScoredObject<Tree>>();
            for (Tree tree : results.get(i)) {
                double score = tree.score();
                scoredResult.add(new ScoredObject<Tree>(tree, score));
            }
            ExternalParserQuery pq = new ExternalParserQuery(sentence, scoredResult);
            dataset.add(new Pair<ExternalParserQuery, Tree>(pq, gold));
        }
        return dataset;
    }

    public CoreNLPProtos.EvaluateParserResponse buildResponse(double f1, Double kbestF1) {
        CoreNLPProtos.EvaluateParserResponse.Builder responseBuilder = CoreNLPProtos.EvaluateParserResponse.newBuilder();
        responseBuilder.setF1(f1);
        if (kbestF1 != null) {
            responseBuilder.setKbestF1(kbestF1);
        }
        CoreNLPProtos.EvaluateParserResponse response = responseBuilder.build();
        return response;
    }

    public CoreNLPProtos.EvaluateParserResponse scoreDataset(List<Tree> goldTrees, List<List<Tree>> results) {
        List<Pair<ParserQuery, Tree>> treebank = this.convertDataset(goldTrees, results);
        EvaluateTreebank evaluator = new EvaluateTreebank(this.op, null, null, null, null, null);
        double f1 = evaluator.testOnTreebank(treebank);
        Double kbestF1 = null;
        if (evaluator.hasPCFGTopKF1()) {
            kbestF1 = evaluator.getPCFGTopKF1();
        }
        return this.buildResponse(f1, kbestF1);
    }

    public CoreNLPProtos.EvaluateParserResponse processRequest(CoreNLPProtos.EvaluateParserRequest parses) throws IOException {
        List<Tree> goldTrees = EvaluateExternalParser.getGoldTrees(parses);
        List<List<Tree>> results = EvaluateExternalParser.getResults(parses);
        return this.scoreDataset(goldTrees, results);
    }

    @Override
    public void processInputStream(InputStream in, OutputStream out2) throws IOException {
        CoreNLPProtos.EvaluateParserRequest request = CoreNLPProtos.EvaluateParserRequest.parseFrom(in);
        CoreNLPProtos.EvaluateParserResponse response = this.processRequest(request);
        response.writeTo(out2);
    }

    public static void main(String[] args) throws IOException {
        EvaluateExternalParser processor = new EvaluateExternalParser(ProcessProtobufRequest.leftoverArgs(args));
        ProcessProtobufRequest.process(processor, args);
    }
}

