/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.parser.shiftreduce;

import edu.stanford.nlp.parser.common.ParserConstraint;
import edu.stanford.nlp.parser.shiftreduce.ShiftReduceUtils;
import edu.stanford.nlp.parser.shiftreduce.State;
import edu.stanford.nlp.parser.shiftreduce.Transition;
import edu.stanford.nlp.parser.shiftreduce.UnaryTransition;
import edu.stanford.nlp.trees.Tree;
import edu.stanford.nlp.util.TreeShapedStack;
import java.util.Arrays;
import java.util.List;

public class CompoundUnaryTransition
implements Transition {
    public final String[] labels;
    public final boolean isRoot;
    private static final long serialVersionUID = 1L;

    public CompoundUnaryTransition(List<String> labels, boolean isRoot) {
        this.labels = new String[labels.size()];
        for (int i = 0; i < labels.size(); ++i) {
            this.labels[i] = labels.get(i);
        }
        this.isRoot = isRoot;
    }

    @Override
    public boolean isLegal(State state, List<ParserConstraint> constraints) {
        if (state.finished) {
            return false;
        }
        if (state.stack.size() == 0) {
            return false;
        }
        Tree top = state.stack.peek();
        if (top.children().length == 1 && !top.isPreTerminal()) {
            return false;
        }
        if (top.label().value().startsWith("@") && !this.labels[this.labels.length - 1].equals(top.label().value().substring(1))) {
            return false;
        }
        if (this.isRoot && (state.stack.size() > 1 || !state.endOfQueue())) {
            return false;
        }
        if (constraints == null) {
            return true;
        }
        for (ParserConstraint constraint : constraints) {
            if (ShiftReduceUtils.leftIndex(top) != constraint.start || ShiftReduceUtils.rightIndex(top) != constraint.end - 1 || constraint.state.matcher(top.value()).matches()) continue;
            boolean found = false;
            for (String label : this.labels) {
                if (!constraint.state.matcher(label).matches()) continue;
                found = true;
                break;
            }
            if (found) continue;
            return false;
        }
        return true;
    }

    @Override
    public State apply(State state) {
        return this.apply(state, 0.0);
    }

    @Override
    public State apply(State state, double scoreDelta) {
        Tree top = state.stack.peek();
        for (int i = this.labels.length - 1; i >= 0; --i) {
            top = UnaryTransition.addUnaryNode(top, this.labels[i]);
        }
        TreeShapedStack<Tree> stack = state.stack.pop();
        stack = stack.push(top);
        return new State(stack, state.transitions.push(this), state.separators, state.sentence, state.tokenPosition, state.score + scoreDelta, false);
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof CompoundUnaryTransition)) {
            return false;
        }
        Object[] otherLabels = ((CompoundUnaryTransition)o).labels;
        return Arrays.equals(this.labels, otherLabels);
    }

    public int hashCode() {
        return 0x1C1A3D7 ^ Arrays.hashCode(this.labels);
    }

    public String toString() {
        return "CompoundUnary" + (this.isRoot ? "*" : "") + "(" + Arrays.asList(this.labels).toString() + ")";
    }
}

