/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.parser.shiftreduce;

import edu.stanford.nlp.ling.CoreLabel;
import edu.stanford.nlp.parser.shiftreduce.BinaryTransition;
import edu.stanford.nlp.parser.shiftreduce.CompoundUnaryTransition;
import edu.stanford.nlp.parser.shiftreduce.FinalizeTransition;
import edu.stanford.nlp.parser.shiftreduce.IdleTransition;
import edu.stanford.nlp.parser.shiftreduce.ShiftTransition;
import edu.stanford.nlp.parser.shiftreduce.TrainingExample;
import edu.stanford.nlp.parser.shiftreduce.Transition;
import edu.stanford.nlp.parser.shiftreduce.UnaryTransition;
import edu.stanford.nlp.trees.Tree;
import edu.stanford.nlp.trees.TreeCoreAnnotations;
import edu.stanford.nlp.util.Generics;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;

public class CreateTransitionSequence {
    private CreateTransitionSequence() {
    }

    public static List<TrainingExample> createTransitionSequences(List<Tree> binarizedTrees, boolean compoundUnary, Set<String> rootStates, Set<String> rootOnlyStates) {
        ArrayList<TrainingExample> transitionLists = Generics.newArrayList();
        for (Tree tree : binarizedTrees) {
            List<Transition> transitions = CreateTransitionSequence.createTransitionSequence(tree, compoundUnary, rootStates, rootOnlyStates);
            transitionLists.add(new TrainingExample(tree, transitions, 0));
        }
        return transitionLists;
    }

    public static List<TrainingExample> createTransitionSequences(List<Tree> binarizedTrees) {
        return CreateTransitionSequence.createTransitionSequences(binarizedTrees, true, Collections.singleton("ROOT"), Collections.singleton("ROOT"));
    }

    public static List<Transition> createTransitionSequence(Tree tree) {
        return CreateTransitionSequence.createTransitionSequence(tree, true, Collections.singleton("ROOT"), Collections.singleton("ROOT"));
    }

    public static List<Transition> createTransitionSequence(Tree tree, boolean compoundUnary, Set<String> rootStates, Set<String> rootOnlyStates) {
        ArrayList<Transition> transitions = Generics.newArrayList();
        CreateTransitionSequence.createTransitionSequenceHelper(transitions, tree, compoundUnary, rootOnlyStates);
        transitions.add(new FinalizeTransition(rootStates));
        transitions.add(new IdleTransition());
        return transitions;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static void createTransitionSequenceHelper(List<Transition> transitions, Tree tree, boolean compoundUnary, Set<String> rootOnlyStates) {
        if (tree.isLeaf()) return;
        if (tree.isPreTerminal()) {
            transitions.add(new ShiftTransition());
            return;
        } else if (tree.children().length == 1) {
            boolean isRoot = rootOnlyStates.contains(tree.label().value());
            if (compoundUnary) {
                ArrayList<String> labels = Generics.newArrayList();
                while (tree.children().length == 1 && !tree.isPreTerminal()) {
                    labels.add(tree.label().value());
                    tree = tree.children()[0];
                }
                CreateTransitionSequence.createTransitionSequenceHelper(transitions, tree, compoundUnary, rootOnlyStates);
                transitions.add(new CompoundUnaryTransition(labels, isRoot));
                return;
            } else {
                CreateTransitionSequence.createTransitionSequenceHelper(transitions, tree.children()[0], compoundUnary, rootOnlyStates);
                transitions.add(new UnaryTransition(tree.label().value(), isRoot));
            }
            return;
        } else {
            if (tree.children().length != 2) throw new IllegalArgumentException("Expected a binarized tree");
            CreateTransitionSequence.createTransitionSequenceHelper(transitions, tree.children()[0], compoundUnary, rootOnlyStates);
            CreateTransitionSequence.createTransitionSequenceHelper(transitions, tree.children()[1], compoundUnary, rootOnlyStates);
            if (!(tree.label() instanceof CoreLabel && tree.children()[0].label() instanceof CoreLabel && tree.children()[1].label() instanceof CoreLabel)) {
                throw new IllegalArgumentException("Expected tree labels to be CoreLabel");
            }
            CoreLabel label = (CoreLabel)tree.label();
            CoreLabel leftLabel = (CoreLabel)tree.children()[0].label();
            CoreLabel rightLabel = (CoreLabel)tree.children()[1].label();
            CoreLabel head = (CoreLabel)label.get(TreeCoreAnnotations.HeadWordLabelAnnotation.class);
            CoreLabel leftHead = (CoreLabel)leftLabel.get(TreeCoreAnnotations.HeadWordLabelAnnotation.class);
            CoreLabel rightHead = (CoreLabel)rightLabel.get(TreeCoreAnnotations.HeadWordLabelAnnotation.class);
            if (head == null || leftHead == null || rightHead == null) {
                throw new IllegalArgumentException("Expected tree labels to have their heads assigned.  Failed at: " + tree);
            }
            boolean isRoot = rootOnlyStates.contains(tree.label().value());
            if (head == leftHead) {
                transitions.add(new BinaryTransition(tree.label().value(), BinaryTransition.Side.LEFT, isRoot));
                return;
            } else {
                if (head != rightHead) throw new IllegalArgumentException("Heads were incorrectly assigned: tree's head is not matched to either the right or left head");
                transitions.add(new BinaryTransition(tree.label().value(), BinaryTransition.Side.RIGHT, isRoot));
            }
        }
    }
}

