/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.parser.shiftreduce;

import edu.stanford.nlp.parser.shiftreduce.ShiftReduceParser;
import edu.stanford.nlp.parser.shiftreduce.State;
import edu.stanford.nlp.parser.shiftreduce.Transition;
import edu.stanford.nlp.trees.Tree;
import java.util.LinkedList;
import java.util.List;

public class TrainingExample {
    Tree binarizedTree;
    List<Transition> transitions;
    int numSkips;

    public TrainingExample(Tree binarizedTree, List<Transition> transitions, int numSkips) {
        this.binarizedTree = binarizedTree;
        this.transitions = transitions;
        this.numSkips = numSkips;
    }

    public List<Transition> trainTransitions() {
        LinkedList<Transition> t = new LinkedList<Transition>(this.transitions);
        for (int i = 0; i < this.numSkips; ++i) {
            t.remove(0);
        }
        return t;
    }

    public State initialStateFromGoldTagTree() {
        State state = ShiftReduceParser.initialStateFromTaggedSentence(this.binarizedTree.taggedYield());
        for (int i = 0; i < this.numSkips; ++i) {
            state = this.transitions.get(i).apply(state);
        }
        return state;
    }
}

