/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.parser.shiftreduce;

import edu.stanford.nlp.parser.common.ParserQuery;
import edu.stanford.nlp.parser.metrics.ParserQueryEval;
import edu.stanford.nlp.parser.shiftreduce.ShiftReduceParserQuery;
import edu.stanford.nlp.parser.shiftreduce.ShiftReduceUtils;
import edu.stanford.nlp.parser.shiftreduce.Transition;
import edu.stanford.nlp.stats.Counters;
import edu.stanford.nlp.stats.IntCounter;
import edu.stanford.nlp.trees.Tree;
import java.io.PrintWriter;
import java.util.List;

public class TransitionTypeEval
implements ParserQueryEval {
    private IntCounter<Class<? extends Transition>> transitionCounts = new IntCounter();

    @Override
    public void evaluate(ParserQuery query, Tree gold, PrintWriter pw) {
        if (!(query instanceof ShiftReduceParserQuery)) {
            throw new IllegalArgumentException("This evaluator only works for the ShiftReduceParser");
        }
        ShiftReduceParserQuery srquery = (ShiftReduceParserQuery)query;
        List<Transition> transitions = srquery.getBestTransitionSequence();
        for (Transition t : transitions) {
            this.transitionCounts.incrementCount(t.getClass());
        }
    }

    @Override
    public void display(boolean verbose, PrintWriter pw) {
        pw.println("Shift-Reduce transition type frequency");
        List<Class<? extends Transition>> sorted = Counters.toSortedList(this.transitionCounts);
        for (Class<? extends Transition> t : sorted) {
            String className = ShiftReduceUtils.transitionShortName(t);
            pw.println("  " + className + ": " + this.transitionCounts.getCount(t));
        }
    }
}

