/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.patterns;

import java.util.Arrays;

public class EditDistanceDamerauLevenshteinLike {
    private static final int threadLocalBufferSize = 64;
    private static final ThreadLocal<short[]> costLocal = new ThreadLocal<short[]>(){

        @Override
        protected short[] initialValue() {
            return new short[64];
        }
    };
    private static final ThreadLocal<short[]> back1Local = new ThreadLocal<short[]>(){

        @Override
        protected short[] initialValue() {
            return new short[64];
        }
    };
    private static final ThreadLocal<short[]> back2Local = new ThreadLocal<short[]>(){

        @Override
        protected short[] initialValue() {
            return new short[64];
        }
    };

    public static int editDistance(CharSequence s, CharSequence t, int threshold) {
        assert (s != null);
        assert (t != null);
        assert (threshold >= 0);
        assert (s.length() < Short.MAX_VALUE);
        assert (t.length() < Short.MAX_VALUE);
        if (s.length() + 1 > 64 || t.length() + 1 > 64) {
            return EditDistanceDamerauLevenshteinLike.editDistanceWithNewBuffers(s, t, (short)threshold);
        }
        short[] cost = costLocal.get();
        short[] back1 = back1Local.get();
        short[] back2 = back2Local.get();
        return EditDistanceDamerauLevenshteinLike.editDistanceWithBuffers(s, t, (short)threshold, back2, back1, cost);
    }

    static int editDistanceWithNewBuffers(CharSequence s, CharSequence t, short threshold) {
        int slen = s.length();
        short[] back1 = new short[slen + 1];
        short[] back2 = new short[slen + 1];
        short[] cost = new short[slen + 1];
        return EditDistanceDamerauLevenshteinLike.editDistanceWithBuffers(s, t, threshold, back2, back1, cost);
    }

    private static int editDistanceWithBuffers(CharSequence s, CharSequence t, short threshold, short[] back2, short[] back1, short[] cost) {
        int slen = s.length();
        int tlen = t.length();
        if (slen == 0) {
            return tlen <= threshold ? tlen : -1;
        }
        if (tlen == 0) {
            return slen <= threshold ? slen : -1;
        }
        if (Math.abs(slen - tlen) > threshold) {
            return -1;
        }
        if (slen > tlen) {
            CharSequence tmp = s;
            s = t;
            t = tmp;
            slen = tlen;
            tlen = (short)t.length();
        }
        EditDistanceDamerauLevenshteinLike.initMemoiseTables((short)threshold, back2, back1, cost, (short)slen);
        for (int j = 1; j <= tlen; j = (short)(j + 1)) {
            cost[0] = j;
            int min = Math.max(1, j - threshold);
            short max = EditDistanceDamerauLevenshteinLike.min((short)slen, (short)(j + threshold));
            if (min > 1) {
                cost[min - 1] = Short.MAX_VALUE;
            }
            EditDistanceDamerauLevenshteinLike.iterateOverStripe(s, t, (short)j, cost, back1, back2, min, max);
            short[] tempCost = back2;
            back2 = back1;
            back1 = cost;
            cost = tempCost;
        }
        if (back1[slen] > threshold) {
            return -1;
        }
        return back1[slen];
    }

    private static void iterateOverStripe(CharSequence s, CharSequence t, short j, short[] cost, short[] back1, short[] back2, int min, int max) {
        for (int i = min; i <= max; ++i) {
            cost[i] = s.charAt(i - 1) == t.charAt(j - 1) ? back1[i - 1] : (short)(1 + EditDistanceDamerauLevenshteinLike.min(cost[i - 1], back1[i], back1[i - 1]));
            if (i < 2 || j < 2 || s.charAt(i - 2) != t.charAt(j - 1) || s.charAt(i - 1) != t.charAt(j - 2)) continue;
            cost[i] = EditDistanceDamerauLevenshteinLike.min(cost[i], (short)(back2[i - 2] + 1));
        }
    }

    private static void initMemoiseTables(short threshold, short[] back2, short[] back1, short[] cost, short slen) {
        short boundary = (short)(EditDistanceDamerauLevenshteinLike.min(slen, threshold) + 1);
        for (short i = 0; i < boundary; i = (short)(i + 1)) {
            back1[i] = i;
            back2[i] = i;
        }
        Arrays.fill(back1, (int)boundary, slen + 1, (short)Short.MAX_VALUE);
        Arrays.fill(back2, (int)boundary, slen + 1, (short)Short.MAX_VALUE);
        Arrays.fill(cost, 0, slen + 1, (short)Short.MAX_VALUE);
    }

    private static short min(short a, short b) {
        return a <= b ? a : b;
    }

    private static short min(short a, short b, short c) {
        return EditDistanceDamerauLevenshteinLike.min(a, EditDistanceDamerauLevenshteinLike.min(b, c));
    }
}

