/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.pipeline;

import edu.stanford.nlp.io.IOUtils;
import edu.stanford.nlp.io.RuntimeIOException;
import edu.stanford.nlp.ling.CoreAnnotations;
import edu.stanford.nlp.ling.CoreLabel;
import edu.stanford.nlp.pipeline.Annotation;
import edu.stanford.nlp.pipeline.AnnotationOutputter;
import edu.stanford.nlp.pipeline.StanfordCoreNLP;
import edu.stanford.nlp.util.CoreMap;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.util.List;

public class TaggedTextOutputter
extends AnnotationOutputter {
    @Override
    public void print(Annotation doc, OutputStream target, AnnotationOutputter.Options options) throws IOException {
        PrintWriter os = new PrintWriter(IOUtils.encodedOutputStreamWriter(target, options.encoding));
        TaggedTextOutputter.print(doc, os, options);
        os.flush();
    }

    private static void print(Annotation annotation, PrintWriter pw, AnnotationOutputter.Options options) throws IOException {
        List sentences = (List)annotation.get(CoreAnnotations.SentencesAnnotation.class);
        if (sentences != null) {
            for (CoreMap sentence : sentences) {
                StringBuilder sentenceToWrite = new StringBuilder();
                for (CoreLabel token : (List)sentence.get(CoreAnnotations.TokensAnnotation.class)) {
                    if (sentenceToWrite.length() > 0) {
                        sentenceToWrite.append(" ");
                    }
                    sentenceToWrite.append(token.value());
                    String tag = (String)token.get(CoreAnnotations.PartOfSpeechAnnotation.class);
                    if (tag == null) continue;
                    sentenceToWrite.append("_" + tag);
                }
                pw.print(sentenceToWrite);
                pw.print(System.lineSeparator());
            }
        }
    }

    public static void prettyPrint(Annotation annotation, OutputStream stream, StanfordCoreNLP pipeline) {
        TaggedTextOutputter.prettyPrint(annotation, new PrintWriter(stream), pipeline);
    }

    public static void prettyPrint(Annotation annotation, PrintWriter pw, StanfordCoreNLP pipeline) {
        try {
            TaggedTextOutputter.print(annotation, pw, TaggedTextOutputter.getOptions(pipeline.getProperties()));
        }
        catch (IOException e) {
            throw new RuntimeIOException(e);
        }
    }
}

