/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.process;

import edu.stanford.nlp.pipeline.CoreNLPProtos;
import edu.stanford.nlp.process.Morphology;
import edu.stanford.nlp.util.ProcessProtobufRequest;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public class ProcessMorphologyRequest
extends ProcessProtobufRequest {
    public CoreNLPProtos.MorphologyResponse processRequest(CoreNLPProtos.MorphologyRequest request) {
        Morphology morpha = new Morphology();
        CoreNLPProtos.MorphologyResponse.Builder responseBuilder = CoreNLPProtos.MorphologyResponse.newBuilder();
        for (CoreNLPProtos.MorphologyRequest.TaggedWord tw : request.getWordsList()) {
            String word = tw.getWord();
            String tag = tw.getXpos();
            String lemma = morpha.lemma(word, tag);
            CoreNLPProtos.MorphologyResponse.WordTagLemma.Builder wtlBuilder = CoreNLPProtos.MorphologyResponse.WordTagLemma.newBuilder();
            wtlBuilder.setWord(word);
            wtlBuilder.setXpos(tag);
            wtlBuilder.setLemma(lemma);
            responseBuilder.addWords(wtlBuilder.build());
        }
        return responseBuilder.build();
    }

    @Override
    public void processInputStream(InputStream in, OutputStream out2) throws IOException {
        CoreNLPProtos.MorphologyRequest request = CoreNLPProtos.MorphologyRequest.parseFrom(in);
        CoreNLPProtos.MorphologyResponse response = this.processRequest(request);
        response.writeTo(out2);
    }

    public static void main(String[] args) throws IOException {
        ProcessProtobufRequest.process(new ProcessMorphologyRequest(), args);
    }
}

