/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.process;

import edu.stanford.nlp.ling.CoreAnnotations;
import edu.stanford.nlp.ling.CoreLabel;
import edu.stanford.nlp.process.TSVUtils;
import edu.stanford.nlp.semgraph.SemanticGraph;
import edu.stanford.nlp.semgraph.SemanticGraphCoreAnnotations;
import edu.stanford.nlp.simple.Sentence;
import edu.stanford.nlp.util.ArrayCoreMap;
import edu.stanford.nlp.util.CoreMap;
import edu.stanford.nlp.util.Iterables;
import edu.stanford.nlp.util.Pair;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;

public class TSVSentenceIterator
implements Iterator<Sentence> {
    private final Iterator<List<String>> source;
    private final List<SentenceField> fields;

    public TSVSentenceIterator(Iterator<List<String>> recordSource, List<SentenceField> fields) {
        this.source = recordSource;
        this.fields = fields;
    }

    public static Sentence toSentence(List<SentenceField> fields, List<String> entries) {
        return new Sentence(TSVSentenceIterator.toCoreMap(fields, entries));
    }

    public static CoreMap toCoreMap(List<SentenceField> fields, List<String> entries) {
        ArrayCoreMap map = new ArrayCoreMap(fields.size());
        Optional<Object> tokens = Optional.empty();
        block22: for (Pair<SentenceField, String> entry : Iterables.zip(fields, entries)) {
            SentenceField field = (SentenceField)((Object)entry.first);
            Iterator<Pair<SentenceField, String>> value = TSVUtils.unescapeSQL((String)entry.second);
            switch (field) {
                case WORDS: {
                    int i;
                    List<String> values = TSVUtils.parseArray((String)((Object)value));
                    if (!tokens.isPresent()) {
                        tokens = Optional.of(new ArrayList(values.size()));
                        for (i = 0; i < values.size(); ++i) {
                            ((List)tokens.get()).add(new CoreLabel());
                        }
                    }
                    int beginChar = 0;
                    for (int i2 = 0; i2 < values.size(); ++i2) {
                        ((CoreLabel)((List)tokens.get()).get(i2)).setValue(values.get(i2));
                        ((CoreLabel)((List)tokens.get()).get(i2)).setWord(values.get(i2));
                        ((CoreLabel)((List)tokens.get()).get(i2)).setBeginPosition(beginChar);
                        ((CoreLabel)((List)tokens.get()).get(i2)).setEndPosition(beginChar + values.get(i2).length());
                        beginChar += values.get(i2).length() + 1;
                    }
                    continue block22;
                }
                case LEMMAS: {
                    int i;
                    List<String> values = TSVUtils.parseArray((String)((Object)value));
                    if (!tokens.isPresent()) {
                        tokens = Optional.of(new ArrayList(values.size()));
                        for (i = 0; i < values.size(); ++i) {
                            ((List)tokens.get()).add(new CoreLabel());
                        }
                    }
                    for (i = 0; i < values.size(); ++i) {
                        ((CoreLabel)((List)tokens.get()).get(i)).setLemma(values.get(i));
                    }
                    continue block22;
                }
                case POS_TAGS: {
                    int i;
                    List<String> values = TSVUtils.parseArray((String)((Object)value));
                    if (!tokens.isPresent()) {
                        tokens = Optional.of(new ArrayList(values.size()));
                        for (i = 0; i < values.size(); ++i) {
                            ((List)tokens.get()).add(new CoreLabel());
                        }
                    }
                    for (i = 0; i < values.size(); ++i) {
                        ((CoreLabel)((List)tokens.get()).get(i)).setTag(values.get(i));
                    }
                    continue block22;
                }
                case NER_TAGS: {
                    int i;
                    List<String> values = TSVUtils.parseArray((String)((Object)value));
                    if (!tokens.isPresent()) {
                        tokens = Optional.of(new ArrayList(values.size()));
                        for (i = 0; i < values.size(); ++i) {
                            ((List)tokens.get()).add(new CoreLabel());
                        }
                    }
                    for (i = 0; i < values.size(); ++i) {
                        ((CoreLabel)((List)tokens.get()).get(i)).setNER(values.get(i));
                    }
                    continue block22;
                }
            }
        }
        Optional<Object> docId = Optional.empty();
        Optional<String> sentenceId = Optional.empty();
        Optional<Object> sentenceIndex = Optional.empty();
        for (Pair<SentenceField, String> entry : Iterables.zip(fields, entries)) {
            SentenceField field = (SentenceField)((Object)entry.first);
            String value = TSVUtils.unescapeSQL((String)entry.second);
            switch (field) {
                case ID: {
                    sentenceId = Optional.of(value);
                    break;
                }
                case DOC_ID: {
                    docId = Optional.of(value);
                    break;
                }
                case SENTENCE_INDEX: {
                    sentenceIndex = Optional.of(Integer.parseInt(value));
                    break;
                }
                case GLOSS: {
                    value = value.replace("\\n", "\n").replace("\\t", "\t");
                    map.set(CoreAnnotations.TextAnnotation.class, value);
                    break;
                }
            }
        }
        map.set(CoreAnnotations.SentenceIDAnnotation.class, sentenceId.orElse("-1"));
        map.set(CoreAnnotations.DocIDAnnotation.class, docId.orElse("???"));
        map.set(CoreAnnotations.SentenceIndexAnnotation.class, sentenceIndex.orElse(0));
        if (tokens.isPresent()) {
            block32: for (Pair<SentenceField, String> entry : Iterables.zip(fields, entries)) {
                SentenceField field = (SentenceField)((Object)entry.first);
                String value = TSVUtils.unescapeSQL((String)entry.second);
                switch (field) {
                    case DOC_CHAR_BEGIN: {
                        int i;
                        List<String> values = TSVUtils.parseArray(value);
                        for (i = 0; i < ((List)tokens.get()).size(); ++i) {
                            ((CoreLabel)((List)tokens.get()).get(i)).setBeginPosition(Integer.parseInt(values.get(i)));
                        }
                        continue block32;
                    }
                    case DOC_CHAR_END: {
                        int i;
                        List<String> values = TSVUtils.parseArray(value);
                        for (i = 0; i < ((List)tokens.get()).size(); ++i) {
                            ((CoreLabel)((List)tokens.get()).get(i)).setEndPosition(Integer.parseInt(values.get(i)));
                        }
                        continue block32;
                    }
                }
            }
        }
        if (tokens.isPresent()) {
            for (int i = 0; i < ((List)tokens.get()).size(); ++i) {
                ((CoreLabel)((List)tokens.get()).get(i)).set(CoreAnnotations.DocIDAnnotation.class, docId.orElse("???"));
                ((CoreLabel)((List)tokens.get()).get(i)).set(CoreAnnotations.SentenceIndexAnnotation.class, sentenceIndex.orElse(-1));
                ((CoreLabel)((List)tokens.get()).get(i)).set(CoreAnnotations.IndexAnnotation.class, i + 1);
                ((CoreLabel)((List)tokens.get()).get(i)).set(CoreAnnotations.TokenBeginAnnotation.class, i);
                ((CoreLabel)((List)tokens.get()).get(i)).set(CoreAnnotations.TokenEndAnnotation.class, i + 1);
            }
        }
        if (tokens.isPresent()) {
            map.set(CoreAnnotations.TokensAnnotation.class, tokens.get());
            map.set(CoreAnnotations.TokenBeginAnnotation.class, 0);
            map.set(CoreAnnotations.TokenEndAnnotation.class, ((List)tokens.get()).size());
            for (Pair<SentenceField, String> entry : Iterables.zip(fields, entries)) {
                SentenceField field = (SentenceField)((Object)entry.first);
                String value = TSVUtils.unescapeSQL((String)entry.second);
                switch (field) {
                    case DEPENDENCIES_BASIC: {
                        SemanticGraph graph = TSVUtils.parseJsonTree(value, (List)tokens.get());
                        map.set(SemanticGraphCoreAnnotations.BasicDependenciesAnnotation.class, graph);
                        break;
                    }
                    case DEPENDENCIES_COLLAPSED: {
                        SemanticGraph graph = TSVUtils.parseJsonTree(value, (List)tokens.get());
                        map.set(SemanticGraphCoreAnnotations.CollapsedDependenciesAnnotation.class, graph);
                        break;
                    }
                    case DEPENDENCIES_COLLAPSED_CC: {
                        SemanticGraph graph = TSVUtils.parseJsonTree(value, (List)tokens.get());
                        map.set(SemanticGraphCoreAnnotations.CollapsedCCProcessedDependenciesAnnotation.class, graph);
                        break;
                    }
                    case DEPENDENCIES_ALTERNATE: {
                        SemanticGraph graph = TSVUtils.parseJsonTree(value, (List)tokens.get());
                        map.set(SemanticGraphCoreAnnotations.AlternativeDependenciesAnnotation.class, graph);
                        break;
                    }
                }
            }
        }
        return map;
    }

    @Override
    public boolean hasNext() {
        return this.source.hasNext();
    }

    @Override
    public Sentence next() {
        return TSVSentenceIterator.toSentence(this.fields, this.source.next());
    }

    public static enum SentenceField {
        ID,
        DEPENDENCIES_BASIC,
        DEPENDENCIES_COLLAPSED,
        DEPENDENCIES_COLLAPSED_CC,
        DEPENDENCIES_ALTERNATE,
        WORDS,
        LEMMAS,
        POS_TAGS,
        NER_TAGS,
        DOC_ID,
        SENTENCE_INDEX,
        CORPUS_ID,
        DOC_CHAR_BEGIN,
        DOC_CHAR_END,
        GLOSS,
        IGNORE;


        public boolean isToken() {
            switch (this) {
                case WORDS: 
                case LEMMAS: 
                case POS_TAGS: 
                case NER_TAGS: {
                    return true;
                }
            }
            return false;
        }
    }
}

