/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.quoteattribution.Sieves.QMSieves;

import edu.stanford.nlp.ling.CoreAnnotations;
import edu.stanford.nlp.pipeline.Annotation;
import edu.stanford.nlp.pipeline.QuoteAttributionAnnotator;
import edu.stanford.nlp.quoteattribution.Person;
import edu.stanford.nlp.quoteattribution.Sieves.QMSieves.QMSieve;
import edu.stanford.nlp.quoteattribution.Sieves.Sieve;
import edu.stanford.nlp.util.CoreMap;
import edu.stanford.nlp.util.Pair;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class ClosestMentionSieve
extends QMSieve {
    public ClosestMentionSieve(Annotation doc, Map<String, List<Person>> characterMap, Map<Integer, String> pronounCorefMap, Set<String> animacySet) {
        super(doc, characterMap, pronounCorefMap, animacySet, "closestBaseline");
    }

    public Sieve.MentionData getClosestMention(CoreMap quote) {
        int forwardDistance;
        Sieve.MentionData closestBackward = this.findClosestMentionInSpanBackward(new Pair<Integer, Integer>(0, (Integer)quote.get(CoreAnnotations.TokenBeginAnnotation.class) - 1));
        Sieve.MentionData closestForward = this.findClosestMentionInSpanForward(new Pair<Integer, Integer>((Integer)quote.get(CoreAnnotations.TokenEndAnnotation.class), ((List)this.doc.get(CoreAnnotations.TokensAnnotation.class)).size() - 1));
        int backDistance = (Integer)quote.get(CoreAnnotations.TokenBeginAnnotation.class) - closestBackward.end;
        if (backDistance < (forwardDistance = closestForward.begin - (Integer)quote.get(CoreAnnotations.TokenEndAnnotation.class) + 1)) {
            return closestBackward;
        }
        return closestForward;
    }

    @Override
    public void doQuoteToMention(Annotation doc) {
        List quotes = (List)doc.get(CoreAnnotations.QuotationsAnnotation.class);
        for (CoreMap quote : quotes) {
            if (quote.get(QuoteAttributionAnnotator.MentionAnnotation.class) != null) continue;
            Sieve.MentionData md = this.getClosestMention(quote);
            ClosestMentionSieve.fillInMention(quote, md, this.sieveName);
        }
    }
}

