/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.quoteattribution.Sieves.QMSieves;

import edu.stanford.nlp.ling.CoreAnnotations;
import edu.stanford.nlp.pipeline.Annotation;
import edu.stanford.nlp.pipeline.QuoteAttributionAnnotator;
import edu.stanford.nlp.quoteattribution.Person;
import edu.stanford.nlp.quoteattribution.Sieves.QMSieves.QMSieve;
import edu.stanford.nlp.util.CoreMap;
import edu.stanford.nlp.util.Pair;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class LooseConversationalSieve
extends QMSieve {
    public LooseConversationalSieve(Annotation doc, Map<String, List<Person>> characterMap, Map<Integer, String> pronounCorefMap, Set<String> animacySet) {
        super(doc, characterMap, pronounCorefMap, animacySet, "loose");
    }

    @Override
    public void doQuoteToMention(Annotation doc) {
        List quotes = (List)doc.get(CoreAnnotations.QuotationsAnnotation.class);
        ArrayList skipChains = new ArrayList();
        ArrayList<Pair<Integer, Integer>> currChain = new ArrayList<Pair<Integer, Integer>>();
        for (int quote_idx = 0; quote_idx < quotes.size(); ++quote_idx) {
            CoreMap coreMap = (CoreMap)quotes.get(quote_idx);
            if (coreMap.get(QuoteAttributionAnnotator.MentionAnnotation.class) != null) continue;
            int para_idx = this.getQuoteParagraph(coreMap);
            if (currChain.size() != 0 && (Integer)((Pair)currChain.get((int)(currChain.size() - 1))).second != para_idx - 2) {
                skipChains.add(currChain);
                currChain = new ArrayList();
            }
            currChain.add(new Pair<Integer, Integer>(quote_idx, para_idx));
        }
        if (currChain.size() != 0) {
            skipChains.add(currChain);
        }
        for (List list : skipChains) {
            Pair firstQuoteAndParagraphIdx = (Pair)list.get(0);
            int firstParagraph = (Integer)firstQuoteAndParagraphIdx.second;
            for (int prevQuoteIdx = (Integer)firstQuoteAndParagraphIdx.first - 1; prevQuoteIdx >= 0; --prevQuoteIdx) {
                CoreMap prevQuote = (CoreMap)quotes.get(prevQuoteIdx);
                if (this.getQuoteParagraph(prevQuote) != firstParagraph - 2 || prevQuote.get(QuoteAttributionAnnotator.MentionAnnotation.class) == null) continue;
                for (Pair quoteAndParagraphIdx : list) {
                    CoreMap quote = (CoreMap)quotes.get((Integer)quoteAndParagraphIdx.first);
                    LooseConversationalSieve.fillInMention(quote, this.getMentionData(prevQuote), this.sieveName);
                }
            }
        }
    }
}

