/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.quoteattribution.Sieves.QMSieves;

import edu.stanford.nlp.ling.CoreAnnotations;
import edu.stanford.nlp.pipeline.Annotation;
import edu.stanford.nlp.pipeline.QuoteAttributionAnnotator;
import edu.stanford.nlp.quoteattribution.Person;
import edu.stanford.nlp.quoteattribution.QuoteAttributionUtils;
import edu.stanford.nlp.quoteattribution.Sieves.QMSieves.QMSieve;
import edu.stanford.nlp.util.CoreMap;
import edu.stanford.nlp.util.Pair;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class OneNameSentenceSieve
extends QMSieve {
    public OneNameSentenceSieve(Annotation doc, Map<String, List<Person>> characterMap, Map<Integer, String> pronounCorefMap, Set<String> animacySet) {
        super(doc, characterMap, pronounCorefMap, animacySet, "Deterministic oneNameSentence");
    }

    @Override
    public void doQuoteToMention(Annotation doc) {
        this.oneNameSentence(doc);
        this.oneSpeakerSentence(doc);
    }

    public void oneNameSentence(Annotation doc) {
        List quotes = (List)doc.get(CoreAnnotations.QuotationsAnnotation.class);
        for (CoreMap quote : quotes) {
            String name;
            List p;
            Pair<Integer, Integer> range;
            if (quote.get(QuoteAttributionAnnotator.MentionAnnotation.class) != null || (range = QuoteAttributionUtils.getRemainderInSentence(doc, quote)) == null) continue;
            Pair<ArrayList<String>, ArrayList<Pair<Integer, Integer>>> namesAndNameIndices = this.scanForNames(range);
            ArrayList names = (ArrayList)namesAndNameIndices.first;
            ArrayList nameIndices = (ArrayList)namesAndNameIndices.second;
            ArrayList<Integer> pronounsIndices = this.scanForPronouns(range);
            if (names.size() != 1 || (p = (List)this.characterMap.get(name = ((String)names.get(0)).replaceAll("\\s+", " "))).size() != 1 || pronounsIndices.size() != 0) continue;
            OneNameSentenceSieve.fillInMention(quote, this.tokenRangeToString((Pair)nameIndices.get(0)), (Integer)((Pair)nameIndices.get((int)0)).first, (Integer)((Pair)nameIndices.get((int)0)).second, this.sieveName, "name");
        }
    }
}

